/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff;

public class CharArrayCharSequence
implements CharSequence {
    private final char[] chars;
    private final int length;
    private final int start;

    private static char[] createCopy(char[] chars) {
        char[] copy = new char[chars.length];
        System.arraycopy(chars, 0, copy, 0, chars.length);
        return copy;
    }

    public CharArrayCharSequence(char[] chars) {
        this(CharArrayCharSequence.createCopy(chars), 0, chars.length);
    }

    private CharArrayCharSequence(char[] chars, int start, int length) {
        if (start + length > chars.length) {
            throw new IndexOutOfBoundsException("Length " + length + " overflow");
        }
        this.chars = chars;
        this.start = start;
        this.length = length;
    }

    @Override
    public char charAt(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException("Index " + index + " is greater than length " + this.length);
        }
        return this.chars[index + this.start];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (end < start) {
            throw new IndexOutOfBoundsException("Invalid input start=" + start + ", end=" + end);
        }
        if (start == 0 && end == this.length) {
            return this;
        }
        return new CharArrayCharSequence(this.chars, this.start + start, end - start);
    }

    @Override
    public String toString() {
        return new String(this.chars, this.start, this.length);
    }

    public static char[] sequenceToArray(CharSequence seq) {
        if (seq == null) {
            throw new NullPointerException("CharSequence can't be NULL");
        }
        char[] chars = new char[seq.length()];
        for (int i = 0; i < seq.length(); ++i) {
            chars[i] = seq.charAt(i);
        }
        return chars;
    }
}

