/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff;

import java.io.IOException;
import java.io.Reader;

public abstract class CharIterator {
    public abstract boolean hasNext();

    public abstract char next() throws IOException;

    public static CharIterator instanceOf(final CharSequence seq) {
        return new CharIterator(){
            private int position = 0;

            @Override
            public boolean hasNext() {
                return this.position < seq.length();
            }

            @Override
            public char next() {
                return seq.charAt(this.position++);
            }
        };
    }

    public static CharIterator instanceOf(final Reader reader) throws IOException {
        return new CharIterator(){
            private int next;
            {
                this.next = reader.read();
            }

            @Override
            public boolean hasNext() {
                return this.next != -1;
            }

            @Override
            public char next() throws IOException {
                char n = (char)this.next;
                this.next = reader.read();
                return n;
            }
        };
    }
}

