/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.conversion;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.cyclopsgroup.caff.conversion.ConversionSupport;
import org.cyclopsgroup.caff.conversion.Converter;
import org.cyclopsgroup.caff.conversion.ConverterFactory;
import org.cyclopsgroup.caff.conversion.NullFriendlyConverter;
import org.cyclopsgroup.caff.conversion.SimpleConverter;

public class AnnotatedConverter<T>
implements Converter<T> {
    private final Converter<T> proxy;

    public AnnotatedConverter(Class<T> type, AnnotatedElement ... access) {
        this.proxy = ((Builder)new Builder().withAccess(access)).toConverter(type);
    }

    public AnnotatedConverter(Class<T> type, Annotation annotation) {
        this.proxy = ((Builder)new Builder().withAnnotation(annotation)).toConverter(type);
    }

    public AnnotatedConverter(Class<T> type, PropertyDescriptor descriptor) {
        this.proxy = ((Builder)new Builder().withAccess(new AnnotatedElement[]{descriptor.getReadMethod(), descriptor.getWriteMethod()})).toConverter(type);
    }

    @Override
    public T fromCharacters(CharSequence text) {
        return this.proxy.fromCharacters(text);
    }

    @Override
    public CharSequence toCharacters(T value) {
        return this.proxy.toCharacters(value);
    }

    private static class Builder<T> {
        private Annotation annotation;

        private Builder() {
        }

        private Converter<T> toConverter(Class<T> type) {
            if (this.annotation == null) {
                return new SimpleConverter<T>(type);
            }
            ConversionSupport support = this.annotation.annotationType().getAnnotation(ConversionSupport.class);
            if (support == null) {
                throw new AssertionError((Object)("Annotation " + this.annotation + " is not annotated with " + ConversionSupport.class));
            }
            try {
                ConverterFactory<?> factory = support.factoryType().newInstance();
                Converter<?> converter = factory.getConverterFor(type, this.annotation);
                return new NullFriendlyConverter(converter);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Can't create converter for " + this.annotation, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Can't create converter for " + this.annotation, e);
            }
        }

        private Builder<T> withAccess(AnnotatedElement ... elements) {
            for (AnnotatedElement access : elements) {
                if (access == null) continue;
                for (Annotation a : access.getAnnotations()) {
                    if (!a.annotationType().isAnnotationPresent(ConversionSupport.class)) continue;
                    this.annotation = a;
                    return this;
                }
            }
            return this;
        }

        private Builder<T> withAnnotation(Annotation annotation) {
            this.annotation = annotation;
            return this;
        }
    }
}

