/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.conversion;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.cyclopsgroup.caff.NormalizedValue;
import org.cyclopsgroup.caff.conversion.ConversionFailedException;
import org.cyclopsgroup.caff.conversion.Converter;

public class EnumConverter<T extends Enum<T>>
implements Converter<T> {
    private final Map<String, T> stringToValue;
    private final Map<T, String> valueToString;

    public EnumConverter(Class<T> enumType) {
        boolean normalized = NormalizedValue.class.isAssignableFrom(enumType);
        HashMap<String, Enum> stringValues = new HashMap<String, Enum>();
        HashMap<Enum, String> valueStrings = new HashMap<Enum, String>();
        for (Enum e : EnumSet.allOf(enumType)) {
            String key = normalized ? ((NormalizedValue)((Object)e)).getIdentifier().toString() : e.name();
            stringValues.put(key, e);
            valueStrings.put(e, key);
        }
        this.stringToValue = Collections.unmodifiableMap(stringValues);
        this.valueToString = Collections.unmodifiableMap(valueStrings);
    }

    @Override
    public T fromCharacters(CharSequence text) {
        Enum result = (Enum)this.stringToValue.get(((Object)text).toString());
        if (result == null) {
            throw new ConversionFailedException("Value " + text + " is unknown");
        }
        return (T)result;
    }

    @Override
    public CharSequence toCharacters(T value) {
        return this.valueToString.get(value);
    }
}

