/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.conversion;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.cyclopsgroup.caff.conversion.ConversionFailedException;
import org.cyclopsgroup.caff.conversion.Converter;

public class SimpleReflectiveConverter<T>
implements Converter<T> {
    private final Constructor<T> constructor;
    private final Method toStringMethod;
    private final Class<T> type;

    public SimpleReflectiveConverter(Class<T> type) {
        this.type = type;
        try {
            this.constructor = type.getConstructor(String.class);
            this.toStringMethod = type.getMethod("toString", new Class[0]);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Can't find constructor with string for type " + type, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Can't find constructor with string for type " + type, e);
        }
    }

    @Override
    public T fromCharacters(CharSequence text) {
        try {
            return this.constructor.newInstance(((Object)text).toString());
        }
        catch (InstantiationException e) {
            throw new ConversionFailedException("Can't call " + this.type + "(String) with " + text, e);
        }
        catch (IllegalAccessException e) {
            throw new ConversionFailedException("Can't call " + this.type + "(String) with " + text, e);
        }
        catch (InvocationTargetException e) {
            throw new ConversionFailedException("Can't call " + this.type + "(String) with " + text, e);
        }
    }

    @Override
    public CharSequence toCharacters(T value) {
        try {
            return (CharSequence)this.toStringMethod.invoke(value, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ConversionFailedException("Can't call " + this.type + ".toString() on " + value, e);
        }
        catch (InvocationTargetException e) {
            throw new ConversionFailedException("Can't call " + this.type + ".toString() on " + value, e);
        }
    }
}

