/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.dp;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.cyclopsgroup.caff.dp.DocumentProcessor;
import org.cyclopsgroup.caff.dp.Instrument;

public class InstrumentedDocumentProcessor
implements DocumentProcessor {
    private final List<Instrument> instruments;

    public InstrumentedDocumentProcessor(List<Instrument> instruments) {
        this.instruments = Collections.unmodifiableList(new ArrayList<Instrument>(instruments));
    }

    private void doProcess(LineNumberReader input, PrintWriter output) throws IOException {
        ArrayDeque<Instrument> stack = new ArrayDeque<Instrument>();
        String line = input.readLine();
        while (line != null) {
            try {
                this.processSegment("$LINE_START$" + line, output, stack);
            }
            catch (RuntimeException e) {
                throw new IOException("Can't parse line " + input.getLineNumber() + ":" + line, e);
            }
            line = input.readLine();
        }
    }

    @Override
    public void process(Reader input, Writer output) throws IOException {
        LineNumberReader in = input instanceof LineNumberReader ? (LineNumberReader)input : new LineNumberReader(input);
        PrintWriter out = output instanceof PrintWriter ? (PrintWriter)output : new PrintWriter(output);
        this.doProcess(in, out);
    }

    private void processSegment(String segment, PrintWriter out, Deque<Instrument> stack) throws IOException {
        int consumed;
        int p;
        int position = segment.length() + 1;
        Instrument selected = null;
        boolean toClose = false;
        for (Instrument i : this.instruments) {
            int p2 = i.searchToOpen(segment, stack.peek());
            if (p2 == -1 || p2 >= position) continue;
            selected = i;
            position = p2;
        }
        if (stack.peek() != null && (p = stack.peek().searchToClose(segment)) != -1 && p < position) {
            selected = stack.peek();
            toClose = true;
            position = p;
        }
        if (selected == null) {
            this.writeText(segment, stack, out);
            return;
        }
        if (position > 0) {
            this.writeText(segment.substring(0, position), stack, out);
        }
        if (toClose) {
            consumed = stack.pop().close(segment.substring(position), out);
        } else {
            consumed = selected.open(segment.substring(position), out);
            stack.push(selected);
        }
        if (position + consumed < segment.length()) {
            this.processSegment(segment.substring(position + consumed), out, stack);
        }
    }

    private void writeText(String text, Deque<Instrument> stack, PrintWriter output) throws IOException {
        if (stack.peek() == null) {
            output.print(StringUtils.removeStart((String)text, (String)"$LINE_START$"));
        } else {
            stack.peek().printText(text, output);
        }
    }
}

