/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.format;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.cyclopsgroup.caff.CharIterator;
import org.cyclopsgroup.caff.conversion.AnnotatedConverter;
import org.cyclopsgroup.caff.conversion.Converter;
import org.cyclopsgroup.caff.format.CSVField;
import org.cyclopsgroup.caff.format.CSVParser;
import org.cyclopsgroup.caff.format.CSVType;
import org.cyclopsgroup.caff.ref.ValueReference;
import org.cyclopsgroup.caff.ref.ValueReferenceScanner;

class CSVImpl<T> {
    private static final char QUOTE = '\"';
    private final int fields;
    private final Map<Integer, Slot> slots;

    CSVImpl(Class<T> beanType) {
        CSVType typeAnnotation = beanType.getAnnotation(CSVType.class);
        if (typeAnnotation == null) {
            throw new IllegalArgumentException("Type " + beanType + " isn't annotated with " + CSVType.class);
        }
        this.fields = typeAnnotation.fields();
        if (this.fields <= 0) {
            throw new IllegalArgumentException("Type " + beanType + " defines invalid number of CSV fields: " + this.fields);
        }
        ValueReferenceScanner<T> scanner = new ValueReferenceScanner<T>(beanType);
        final HashMap slots = new HashMap();
        scanner.scanForAnnotation(CSVField.class, new ValueReferenceScanner.Listener<T, CSVField>(){

            @Override
            public void handleReference(ValueReference<T> reference, CSVField field, AccessibleObject access) {
                Slot slot = new Slot(reference, new AnnotatedConverter(reference.getType(), access), field);
                slots.put(field.position(), slot);
            }
        });
        this.slots = Collections.unmodifiableMap(slots);
    }

    void populate(final T bean, CharIterator in) throws IOException {
        CSVParser parser = new CSVParser(){

            @Override
            protected void handleField(int position, CharSequence content) throws IOException {
                Slot slot = (Slot)CSVImpl.this.slots.get(position);
                if (slot != null) {
                    slot.write(bean, content);
                }
            }
        };
        parser.parse(in);
    }

    void print(T bean, Writer out) throws IOException {
        for (int i = 0; i < this.fields; ++i) {
            Slot slot;
            if (i != 0) {
                out.write(44);
            }
            if ((slot = this.slots.get(i)) == null) continue;
            String value = ((Object)slot.read(bean)).toString();
            boolean quoteRequired = slot.fieldAnnotation.alwaysQuote();
            if (value.indexOf(34) > -1) {
                quoteRequired = true;
                value = value.toString().replaceAll("\"", "\"\"");
            }
            if (quoteRequired) {
                out.write(34);
                out.write(value);
                out.write(34);
                continue;
            }
            out.write(value);
        }
    }

    private class Slot {
        private final Converter<Object> converter;
        private final CSVField fieldAnnotation;
        private final ValueReference<T> reference;

        private Slot(ValueReference<T> reference, Converter<Object> converter, CSVField fieldAnnotation) {
            this.reference = reference;
            this.converter = converter;
            this.fieldAnnotation = fieldAnnotation;
        }

        private CharSequence read(T bean) {
            return this.converter.toCharacters(this.reference.readValue(bean));
        }

        private void write(T bean, CharSequence value) {
            this.reference.writeValue(this.converter.fromCharacters(value), bean);
        }
    }
}

