/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.ref;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.cyclopsgroup.caff.ref.AccessFailureException;
import org.cyclopsgroup.caff.ref.ValueReference;

class FieldValueReference<T>
extends ValueReference<T> {
    private final Field field;

    FieldValueReference(Field field) {
        if (field == null) {
            throw new NullPointerException("Field can't be NULL");
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            throw new IllegalArgumentException("Only public field can be directly referenced: " + field);
        }
        this.field = field;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Class<?> getType() {
        return this.field.getType();
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return !Modifier.isFinal(this.field.getModifiers());
    }

    @Override
    public Object readValue(T owner) throws AccessFailureException {
        try {
            return this.field.get(owner);
        }
        catch (IllegalAccessException e) {
            throw new AccessFailureException("Can't get field " + this.field + " of " + owner, e);
        }
    }

    @Override
    public void writeValue(Object value, T owner) throws AccessFailureException {
        if (value == null && this.field.getType().isPrimitive()) {
            return;
        }
        try {
            this.field.set(owner, value);
        }
        catch (IllegalAccessException e) {
            throw new AccessFailureException("Can't set field " + this.field + " of " + owner + " to " + value, e);
        }
    }
}

