/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.ref;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.cyclopsgroup.caff.ref.AccessFailureException;
import org.cyclopsgroup.caff.ref.ValueReference;

class PropertyValueReference<T>
extends ValueReference<T> {
    private final String name;
    private final Method reader;
    private final Class<?> type;
    private final Method writer;

    private static Method nullIfNotPublic(Method method) {
        if (method == null) {
            return null;
        }
        return Modifier.isPublic(method.getModifiers()) ? method : null;
    }

    PropertyValueReference(PropertyDescriptor descriptor) {
        this.name = descriptor.getName();
        this.reader = PropertyValueReference.nullIfNotPublic(descriptor.getReadMethod());
        this.writer = PropertyValueReference.nullIfNotPublic(descriptor.getWriteMethod());
        this.type = descriptor.getPropertyType();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isReadable() {
        return this.reader != null;
    }

    @Override
    public boolean isWritable() {
        return this.writer != null;
    }

    @Override
    public Object readValue(T owner) {
        if (this.reader == null) {
            throw new IllegalStateException("Property " + this.name + " isn't readable");
        }
        try {
            return this.reader.invoke(owner, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new AccessFailureException("Can't read property " + this.name + " from object " + owner, e);
        }
        catch (InvocationTargetException e) {
            throw new AccessFailureException("Can't read property " + this.name + " from object " + owner, e);
        }
    }

    @Override
    public void writeValue(Object value, T owner) {
        if (this.writer == null) {
            throw new IllegalStateException("Property " + this.name + " isn't writable");
        }
        if (value == null && this.type.isPrimitive()) {
            return;
        }
        try {
            this.writer.invoke(owner, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Can't set property " + this.name + " of object " + owner + " to " + value, e);
        }
        catch (IllegalAccessException e) {
            throw new AccessFailureException("Can't set property " + this.name + " of object " + owner + " to " + value, e);
        }
        catch (InvocationTargetException e) {
            throw new AccessFailureException("Can't set property " + this.name + " of object " + owner + " to " + value, e);
        }
    }
}

