/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.token;

import org.cyclopsgroup.caff.token.TokenEvent;
import org.cyclopsgroup.caff.token.TokenEventHandler;
import org.cyclopsgroup.caff.token.ValueTokenizer;

public class EscapingValueTokenizer
implements ValueTokenizer {
    private final char delimiter;
    private final char escaper;

    public EscapingValueTokenizer() {
        this(' ', '\\');
    }

    public EscapingValueTokenizer(char delimiter, char escaper) {
        this.escaper = escaper;
        this.delimiter = delimiter;
    }

    @Override
    public String escape(String output) {
        if (output.indexOf(this.escaper) == -1 && output.indexOf(this.delimiter) == -1) {
            return output;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int j = 0;
        while (i < output.length()) {
            int e = output.indexOf(this.escaper, i);
            int d = output.indexOf(this.delimiter, i);
            if (e == -1 && d == -1) {
                sb.append(output.substring(i));
                break;
            }
            j = e >= 0 && d >= 0 ? Math.min(e, d) : Math.max(e, d);
            sb.append(output.substring(i, j)).append(this.escaper).append(output.charAt(j));
            i = ++j;
        }
        return sb.toString();
    }

    public final char getDelimiter() {
        return this.delimiter;
    }

    public final char getEscaper() {
        return this.escaper;
    }

    @Override
    public void parse(CharSequence input, TokenEventHandler handler) {
        ProcessingState state = ProcessingState.READY;
        StringBuilder word = null;
        int wordStart = 0;
        block5: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (state) {
                case READY: {
                    if (c == this.delimiter) continue block5;
                    wordStart = i;
                    word = new StringBuilder();
                    if (c == this.escaper) {
                        state = ProcessingState.ESCAPING;
                        continue block5;
                    }
                    state = ProcessingState.WORD;
                    word.append(c);
                    continue block5;
                }
                case WORD: {
                    if (c == this.delimiter) {
                        state = ProcessingState.READY;
                        TokenEvent ev = new TokenEvent(word.toString(), wordStart, i, true);
                        handler.handleEvent(ev);
                        word = null;
                        continue block5;
                    }
                    if (c == this.escaper) {
                        state = ProcessingState.ESCAPING;
                        continue block5;
                    }
                    word.append(c);
                    continue block5;
                }
                case ESCAPING: {
                    state = ProcessingState.WORD;
                    word.append(c);
                }
            }
        }
        if (word != null) {
            TokenEvent ev = new TokenEvent(word.toString(), wordStart, input.length(), false);
            handler.handleEvent(ev);
        }
    }

    private static enum ProcessingState {
        ESCAPING,
        READY,
        WORD;

    }
}

