/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.util;

import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.cyclopsgroup.caff.util.ByteUtils;

public final class UUIDUtils {
    public static UUID fromBytes(byte[] bytes) {
        long mostBits = ByteUtils.readLong(bytes, 0);
        long leastBits = 0L;
        if (bytes.length > 8) {
            leastBits = ByteUtils.readLong(bytes, 8);
        }
        return new UUID(mostBits, leastBits);
    }

    public static UUID fromString(String id) {
        return UUIDUtils.fromBytes(Base64.decodeBase64((String)id));
    }

    public static byte[] toBytes(UUID id) {
        byte[] bytes = new byte[16];
        ByteUtils.writeLong(id.getMostSignificantBits(), bytes, 0);
        ByteUtils.writeLong(id.getLeastSignificantBits(), bytes, 8);
        return bytes;
    }

    public static String toString(UUID id) {
        return Base64.encodeBase64URLSafeString((byte[])UUIDUtils.toBytes(id));
    }

    public static String randomStringId() {
        return UUIDUtils.toString(UUID.randomUUID());
    }

    private UUIDUtils() {
    }
}

