/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.internal.StaticCredentialsProvider;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cyclopsgroup.kaufman.aws.ExpressionUtils;

public class ChainedCredentialsProvider
implements AWSCredentialsProvider {
    private static final Log LOG = LogFactory.getLog(ChainedCredentialsProvider.class);
    private final AWSCredentialsProvider instance;

    public ChainedCredentialsProvider(List<Object> chain) throws IOException {
        for (Object initObject : chain) {
            if (initObject instanceof AWSCredentialsProvider) {
                LOG.info((Object)("Returning crendentials provider " + initObject));
                this.instance = (AWSCredentialsProvider)initObject;
                return;
            }
            if (initObject instanceof AWSCredentials) {
                LOG.info((Object)("Returning credentials " + initObject));
                this.instance = new StaticCredentialsProvider((AWSCredentials)initObject);
                return;
            }
            if (!(initObject instanceof File) && !(initObject instanceof String)) continue;
            File file = initObject instanceof String ? new File(ExpressionUtils.populate(((String)initObject).trim())) : (File)initObject;
            if (!file.exists()) {
                LOG.info((Object)("Skip file " + file + " since it does't exist"));
                continue;
            }
            LOG.info((Object)("Return credentials in file " + file));
            this.instance = new StaticCredentialsProvider((AWSCredentials)new PropertiesCredentials(file));
            return;
        }
        throw new IllegalStateException("Can't create AWSCredentialsProvider from chain " + chain);
    }

    public AWSCredentials getCredentials() {
        return this.instance.getCredentials();
    }

    final AWSCredentialsProvider getInstance() {
        return this.instance;
    }

    public void refresh() {
        this.instance.refresh();
    }
}

