/*
 * Decompiled with CFR 0.152.
 */
package dafny;

import dafny.Tuple2;
import dafny.Tuple3;
import java.math.BigInteger;

public class BigRational {
    public static final BigRational ZERO = new BigRational(0);
    BigInteger num;
    BigInteger den;

    public String toString() {
        if (this.den.equals(BigInteger.ONE) || this.num.equals(BigInteger.ZERO)) {
            return this.num + ".0";
        }
        Tuple2<Boolean, Integer> t = this.IsPowerOf10(this.den);
        Integer log10 = t.dtor__1();
        if (t.dtor__0().booleanValue()) {
            String digits;
            String sign;
            if (this.num.signum() < 0) {
                sign = "-";
                digits = this.num.negate().toString();
            } else {
                sign = "";
                digits = this.num.toString();
            }
            if (log10 < digits.length()) {
                int n = digits.length() - log10;
                return sign + digits.substring(0, n) + "." + digits.substring(n);
            }
            int z = log10 - digits.length();
            StringBuffer outputBuffer = new StringBuffer(z);
            for (int i = 0; i < z; ++i) {
                outputBuffer.append("0");
            }
            return sign + "0." + outputBuffer.toString() + digits;
        }
        return "(" + this.num + ".0 / " + this.den + ".0)";
    }

    public Tuple2<Boolean, Integer> IsPowerOf10(BigInteger x) {
        int log10 = 0;
        if (x.equals(BigInteger.ZERO)) {
            return new Tuple2<Boolean, Integer>(false, log10);
        }
        while (true) {
            if (x.equals(BigInteger.ONE)) {
                return new Tuple2<Boolean, Integer>(true, log10);
            }
            if (!x.mod(BigInteger.TEN).equals(BigInteger.ZERO)) break;
            ++log10;
            x = x.divide(BigInteger.TEN);
        }
        return new Tuple2<Boolean, Integer>(false, log10);
    }

    public BigRational() {
        this(0, 1);
    }

    public BigRational(int n) {
        this(n, 1);
    }

    public BigRational(int n, int d) {
        this(BigInteger.valueOf(n), BigInteger.valueOf(d));
    }

    public BigRational(BigInteger n, BigInteger d) {
        assert (!d.equals(BigInteger.ZERO)) : "Precondition Failure";
        if (d.compareTo(BigInteger.ZERO) < 0) {
            this.num = n.negate();
            this.den = d.negate();
        } else {
            this.num = n;
            this.den = d;
        }
    }

    public BigInteger ToBigInteger() {
        if (this.num.equals(BigInteger.ZERO) || this.den.equals(BigInteger.ONE)) {
            return this.num;
        }
        if (0 < this.num.signum()) {
            return this.num.divide(this.den);
        }
        return this.num.subtract(this.den).add(BigInteger.ONE).divide(this.den);
    }

    private static Tuple3<BigInteger, BigInteger, BigInteger> Normalize(BigRational a, BigRational b) {
        BigInteger dd;
        BigInteger bb;
        BigInteger aa;
        if (a.num.equals(BigInteger.ZERO)) {
            aa = a.num;
            bb = b.num;
            dd = b.den;
        } else if (b.num.equals(BigInteger.ZERO)) {
            aa = a.num;
            dd = a.den;
            bb = b.num;
        } else {
            BigInteger gcd = a.den.gcd(b.den);
            BigInteger xx = a.den.divide(gcd);
            BigInteger yy = b.den.divide(gcd);
            aa = a.num.multiply(yy);
            bb = b.num.multiply(xx);
            dd = a.den.multiply(yy);
        }
        return new Tuple3<BigInteger, BigInteger, BigInteger>(aa, bb, dd);
    }

    public BigRational reduce() {
        BigInteger gcd = this.num.abs().gcd(this.den);
        if (gcd.equals(BigInteger.ONE)) {
            return this;
        }
        return new BigRational(this.num.divide(gcd), this.den.divide(gcd));
    }

    public int compareTo(BigRational that) {
        int asign = this.num.signum();
        int bsign = that.num.signum();
        if (asign < 0 && 0 <= bsign) {
            return -1;
        }
        if (asign <= 0 && 0 < bsign) {
            return -1;
        }
        if (bsign < 0 && 0 <= asign) {
            return 1;
        }
        if (bsign <= 0 && 0 < asign) {
            return 1;
        }
        Tuple3<BigInteger, BigInteger, BigInteger> n = BigRational.Normalize(this, that);
        return n.dtor__0().compareTo(n.dtor__1());
    }

    public int signum() {
        return this.num.signum();
    }

    public int hashCode() {
        return this.num.hashCode() + 29 * this.den.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigRational o = (BigRational)obj;
        Tuple3<BigInteger, BigInteger, BigInteger> t = BigRational.Normalize(this, o);
        return t.dtor__0().equals(t.dtor__1());
    }

    public static BigRational add(BigRational a, BigRational b) {
        Tuple3<BigInteger, BigInteger, BigInteger> t = BigRational.Normalize(a, b);
        return new BigRational(t.dtor__0().add(t.dtor__1()), t.dtor__2());
    }

    public static BigRational subtract(BigRational a, BigRational b) {
        Tuple3<BigInteger, BigInteger, BigInteger> t = BigRational.Normalize(a, b);
        return new BigRational(t.dtor__0().subtract(t.dtor__1()), t.dtor__2());
    }

    public static BigRational negate(BigRational a) {
        return new BigRational(a.num.negate(), a.den);
    }

    public static BigRational multiply(BigRational a, BigRational b) {
        return new BigRational(a.num.multiply(b.num), a.den.multiply(b.den));
    }

    public static BigRational divide(BigRational a, BigRational b) {
        BigRational bReciprocal = 0 < b.num.signum() ? new BigRational(b.den, b.num) : new BigRational(b.den.negate(), b.num.negate());
        return BigRational.multiply(a, bReciprocal);
    }

    public BigRational add(BigRational b) {
        return BigRational.add(this, b);
    }

    public BigRational subtract(BigRational b) {
        return BigRational.subtract(this, b);
    }

    public BigRational negate() {
        return new BigRational(this.num.negate(), this.den);
    }

    public BigRational multiply(BigRational b) {
        return BigRational.multiply(this, b);
    }

    public BigRational divide(BigRational b) {
        return BigRational.divide(this, b);
    }
}

