/*
 * Decompiled with CFR 0.152.
 */
package dafny;

import dafny.DafnySequence;
import dafny.LazyDafnySequence;
import dafny.NonLazyDafnySequence;
import java.util.ArrayDeque;

final class ConcatDafnySequence<T>
extends LazyDafnySequence<T> {
    private DafnySequence<T> left;
    private DafnySequence<T> right;
    private NonLazyDafnySequence<T> ans = null;
    private final int length;

    ConcatDafnySequence(DafnySequence<T> left, DafnySequence<T> right) {
        this.left = left;
        this.right = right;
        this.length = left.length() + right.length();
    }

    @Override
    protected NonLazyDafnySequence<T> force() {
        if (this.ans == null) {
            this.ans = this.computeElements();
            this.left = null;
            this.right = null;
        }
        return this.ans;
    }

    @Override
    public int length() {
        return this.length;
    }

    private NonLazyDafnySequence<T> computeElements() {
        ArrayDeque<DafnySequence<T>> toVisit = new ArrayDeque<DafnySequence<T>>();
        toVisit.push(this.right);
        DafnySequence<T> first = this.left;
        while (first instanceof ConcatDafnySequence && ((ConcatDafnySequence)first).ans == null) {
            toVisit.push(((ConcatDafnySequence)first).right);
            first = ((ConcatDafnySequence)first).left;
        }
        toVisit.push(first);
        DafnySequence.Copier<T> copier = first.newCopier(this.length);
        while (!toVisit.isEmpty()) {
            DafnySequence seq = (DafnySequence)toVisit.pop();
            if (seq instanceof ConcatDafnySequence) {
                ConcatDafnySequence cseq = (ConcatDafnySequence)seq;
                if (cseq.ans != null) {
                    copier.copyFrom(cseq.ans);
                    continue;
                }
                toVisit.push(cseq.right);
                toVisit.push(cseq.left);
                continue;
            }
            copier.copyFrom(seq);
        }
        return copier.result();
    }
}

