/*
 * Decompiled with CFR 0.152.
 */
package dafny;

import dafny.Array;
import dafny.CodePoint;
import dafny.DafnyHaltException;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Helpers {
    private static final BigInteger ULONG_LIMIT = new BigInteger("18446744073709551616");

    public static DafnySequence<? extends DafnySequence<? extends Character>> FromMainArguments(String[] args) {
        TypeDescriptor<DafnySequence<Character>> type = DafnySequence._typeDescriptor(TypeDescriptor.CHAR);
        Array<DafnySequence<Character>> dafnyArgs = Array.newArray(type, args.length + 1);
        dafnyArgs.set(0, DafnySequence.asString("java"));
        for (int i = 0; i < args.length; ++i) {
            dafnyArgs.set(i + 1, DafnySequence.asString(args[i]));
        }
        return DafnySequence.fromArray(type, dafnyArgs);
    }

    public static DafnySequence<? extends DafnySequence<? extends CodePoint>> UnicodeFromMainArguments(String[] args) {
        TypeDescriptor<DafnySequence<CodePoint>> type = DafnySequence._typeDescriptor(TypeDescriptor.UNICODE_CHAR);
        Array<DafnySequence<CodePoint>> dafnyArgs = Array.newArray(type, args.length + 1);
        dafnyArgs.set(0, DafnySequence.asUnicodeString("java"));
        for (int i = 0; i < args.length; ++i) {
            dafnyArgs.set(i + 1, DafnySequence.asUnicodeString(args[i]));
        }
        return DafnySequence.fromArray(type, dafnyArgs);
    }

    public static String ToStringLiteral(DafnySequence<? extends CodePoint> dafnyString) {
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        for (CodePoint codePoint : dafnyString) {
            Helpers.AppendCodePointWithEscaping(builder, codePoint.value());
        }
        builder.append("\"");
        return builder.toString();
    }

    public static String ToCharLiteral(int codePoint) {
        StringBuilder builder = new StringBuilder();
        builder.append("'");
        Helpers.AppendCodePointWithEscaping(builder, codePoint);
        builder.append("'");
        return builder.toString();
    }

    private static void AppendCodePointWithEscaping(StringBuilder builder, int codePoint) {
        switch (codePoint) {
            case 10: {
                builder.append("\\n");
                break;
            }
            case 13: {
                builder.append("\\r");
                break;
            }
            case 9: {
                builder.append("\\t");
                break;
            }
            case 0: {
                builder.append("\\0");
                break;
            }
            case 39: {
                builder.append("\\'");
                break;
            }
            case 34: {
                builder.append("\\\"");
                break;
            }
            case 92: {
                builder.append("\\\\");
                break;
            }
            default: {
                builder.appendCodePoint(codePoint);
            }
        }
    }

    public static <T> boolean Quantifier(Iterable<T> vals, boolean frall, Predicate<T> pred) {
        for (T t : vals) {
            if (pred.test(t) == frall) continue;
            return !frall;
        }
        return frall;
    }

    public static <T> T Id(T t) {
        return t;
    }

    public static <T, U> U Let(T t, Function<T, U> f) {
        return f.apply(t);
    }

    public static Iterable<BigInteger> IntegerRange(final BigInteger lo, final BigInteger hi) {
        assert (lo != null || hi != null);
        if (lo == null) {
            return () -> {
                Stream<BigInteger> infiniteStream = Stream.iterate(hi.subtract(BigInteger.ONE), i -> i.subtract(BigInteger.ONE));
                return infiniteStream.iterator();
            };
        }
        if (hi == null) {
            return () -> {
                Stream<BigInteger> infiniteStream = Stream.iterate(lo, i -> i.add(BigInteger.ONE));
                return infiniteStream.iterator();
            };
        }
        return () -> new Iterator<BigInteger>(){
            private BigInteger i;
            {
                this.i = lo;
            }

            @Override
            public boolean hasNext() {
                return this.i.compareTo(hi) < 0;
            }

            @Override
            public BigInteger next() {
                BigInteger j = this.i;
                this.i = this.i.add(BigInteger.ONE);
                return j;
            }
        };
    }

    public static Iterable<BigInteger> AllIntegers() {
        return () -> new Iterator<BigInteger>(){
            BigInteger i = BigInteger.ZERO;

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public BigInteger next() {
                BigInteger j = this.i;
                this.i = this.i.equals(BigInteger.ZERO) ? BigInteger.ONE : (this.i.signum() > 0 ? this.i.negate() : this.i.negate().add(BigInteger.ONE));
                return j;
            }
        };
    }

    public static Iterable<Boolean> AllBooleans() {
        return () -> IntStream.range(0, 2).mapToObj(i -> i == 1).iterator();
    }

    public static Iterable<Character> AllChars() {
        return () -> IntStream.range(0, 65536).mapToObj(i -> Character.valueOf((char)i)).iterator();
    }

    public static Iterable<CodePoint> AllUnicodeChars() {
        return () -> IntStream.concat(IntStream.range(0, 55296), IntStream.range(57344, 0x110000)).mapToObj(CodePoint::valueOf).iterator();
    }

    public static <G> String toString(G g) {
        if (g == null) {
            return "null";
        }
        return g.toString();
    }

    public static int toInt(BigInteger i) {
        return i.intValue();
    }

    public static void outOfRange(String msg) {
        throw new DafnyHaltException(msg);
    }

    public static int toIntChecked(BigInteger i, String msg) {
        int r = i.intValue();
        if (!BigInteger.valueOf(r).equals(i)) {
            msg = (msg != null ? msg : "value out of range for a 32-bit int") + ": " + i;
            Helpers.outOfRange(msg);
        }
        return r;
    }

    public static int toIntChecked(long i, String msg) {
        int r = (int)i;
        if ((long)r != i) {
            msg = (msg != null ? msg : "value out of range for a 32-bit int") + ": " + i;
            Helpers.outOfRange(msg);
        }
        return r;
    }

    public static int unsignedToIntChecked(byte i) {
        int r = Helpers.unsignedToInt(i);
        return r;
    }

    public static int unsignedToIntChecked(short i) {
        int r = Helpers.unsignedToInt(i);
        return r;
    }

    public static int unsignedToIntChecked(long i, String msg) {
        int r = Helpers.unsignedToInt(i);
        if ((long)r != i) {
            msg = (msg != null ? msg : "value out of range for a 32-bit int") + ": " + i;
            Helpers.outOfRange(msg);
        }
        return r;
    }

    public static int toInt(int i) {
        return i;
    }

    public static int toInt(long l) {
        return (int)l;
    }

    public static int unsignedToInt(byte x) {
        return x & 0xFF;
    }

    public static int unsignedToInt(short x) {
        return x & 0xFFFF;
    }

    public static int unsignedToInt(long x) {
        return (int)x;
    }

    public static BigInteger unsignedLongToBigInteger(long l) {
        if (0L <= l) {
            return BigInteger.valueOf(l);
        }
        return BigInteger.valueOf(l).add(ULONG_LIMIT);
    }

    public static byte divideUnsignedByte(byte a, byte b) {
        return (byte)Integer.divideUnsigned(a & 0xFF, b & 0xFF);
    }

    public static short divideUnsignedShort(short a, short b) {
        return (short)Integer.divideUnsigned(a & 0xFFFF, b & 0xFFFF);
    }

    public static byte remainderUnsignedByte(byte a, byte b) {
        return (byte)Integer.remainderUnsigned(a & 0xFF, b & 0xFF);
    }

    public static short remainderUnsignedShort(short a, short b) {
        return (short)Integer.remainderUnsigned(a & 0xFFFF, b & 0xFFFF);
    }

    public static int bv8ShiftRight(byte a, byte amount) {
        if (a < 0) {
            return (a & 0xFF) >>> amount;
        }
        return a >>> amount;
    }

    public static int bv16ShiftRight(short a, byte amount) {
        if (a < 0) {
            return (a & 0xFFFF) >>> amount;
        }
        return a >>> amount;
    }

    public static int bv32ShiftRight(int a, byte amount) {
        if (amount == 32) {
            return 0;
        }
        if (a < 0) {
            return (a & 0xFFFFFFFF) >>> amount;
        }
        return a >>> amount;
    }

    public static long bv64ShiftRight(long a, byte amount) {
        if (amount == 64) {
            return 0L;
        }
        return a >>> amount;
    }

    public static int bv32ShiftLeft(int a, byte amount) {
        if (amount == 32) {
            return 0;
        }
        return a << amount;
    }

    public static long bv64ShiftLeft(long a, byte amount) {
        if (amount == 64) {
            return 0L;
        }
        return a << amount;
    }

    public static void withHaltHandling(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (DafnyHaltException e) {
            System.out.println("[Program halted] " + e.getMessage());
            System.exit(1);
        }
    }
}

