/*
 * Decompiled with CFR 0.152.
 */
package dafny;

import dafny.BigRational;
import dafny.CodePoint;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

public abstract class TypeDescriptor<T> {
    final Class<?> boxedClass;
    final Class<?> unboxedClass;
    public static final TypeDescriptor<Byte> BYTE = new ByteType(0);
    public static final TypeDescriptor<Short> SHORT = new ShortType(0);
    public static final TypeDescriptor<Integer> INT = new IntType(0);
    public static final TypeDescriptor<Long> LONG = new LongType(0L);
    public static final TypeDescriptor<Boolean> BOOLEAN = new BooleanType(Boolean.FALSE);
    public static final TypeDescriptor<Character> CHAR = new CharType('D');
    public static final TypeDescriptor<CodePoint> UNICODE_CHAR = new UnicodeCharType(CodePoint.valueOf(68));
    public static final TypeDescriptor<BigInteger> BIG_INTEGER = TypeDescriptor.referenceWithDefault(BigInteger.class, BigInteger.ZERO);
    public static final TypeDescriptor<BigRational> BIG_RATIONAL = TypeDescriptor.referenceWithDefault(BigRational.class, BigRational.ZERO);
    public static final TypeDescriptor<Object> OBJECT = TypeDescriptor.reference(Object.class);
    public static final TypeDescriptor<byte[]> BYTE_ARRAY = TypeDescriptor.reference(byte[].class);
    public static final TypeDescriptor<short[]> SHORT_ARRAY = TypeDescriptor.reference(short[].class);
    public static final TypeDescriptor<int[]> INT_ARRAY = TypeDescriptor.reference(int[].class);
    public static final TypeDescriptor<long[]> LONG_ARRAY = TypeDescriptor.reference(long[].class);
    public static final TypeDescriptor<boolean[]> BOOLEAN_ARRAY = TypeDescriptor.reference(boolean[].class);
    public static final TypeDescriptor<char[]> CHAR_ARRAY = TypeDescriptor.reference(char[].class);
    public static final TypeDescriptor<int[]> UNICODE_CHAR_ARRAY = TypeDescriptor.reference(int[].class);

    TypeDescriptor(Class<?> javaClass) {
        this(javaClass, javaClass);
    }

    TypeDescriptor(Class<?> boxedClass, Class<?> unboxedClass) {
        this.boxedClass = boxedClass;
        this.unboxedClass = unboxedClass;
    }

    public final boolean isPrimitive() {
        return this.unboxedClass.isPrimitive();
    }

    public abstract T defaultValue();

    public abstract boolean isInstance(Object var1);

    public abstract TypeDescriptor<?> arrayType();

    public final Object newArray(int length) {
        return Array.newInstance(this.unboxedClass, length);
    }

    public final Object newArray(int ... dims) {
        return Array.newInstance(this.unboxedClass, dims);
    }

    public abstract T getArrayElement(Object var1, int var2);

    public abstract void setArrayElement(Object var1, int var2, T var3);

    public final int getArrayLength(Object array) {
        return Array.getLength(array);
    }

    public abstract Object cloneArray(Object var1);

    public abstract void fillArray(Object var1, T var2);

    public final Object fillThenReturnArray(Object array, T value) {
        this.fillArray(array, value);
        return array;
    }

    public final void copyArrayTo(Object src, int srcPos, Object dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    public abstract boolean arrayDeepEquals(Object var1, Object var2);

    public Object toArray(Collection<T> coll) {
        Object arr = this.newArray(coll.size());
        int i = 0;
        for (T elt : coll) {
            this.setArrayElement(arr, i++, elt);
        }
        return arr;
    }

    public String toString() {
        return this.boxedClass.toString();
    }

    public static <T> TypeDescriptor<T> reference(Class<T> javaClass) {
        return TypeDescriptor.referenceWithDefault(javaClass, null);
    }

    public static <T> TypeDescriptor<T> referenceWithDefault(Class<T> javaClass, T defaultValue) {
        return TypeDescriptor.referenceWithInitializer(javaClass, () -> defaultValue);
    }

    public static <T> TypeDescriptor<T> referenceWithInitializer(Class<?> javaClass, Initializer<T> initializer) {
        return new ReferenceType<T>(javaClass, initializer);
    }

    public static <T> TypeDescriptor<T> referenceWithInitializerAndTypeDescriptor(TypeDescriptor<T> typeDescriptor, Initializer<T> initializer) {
        return new ReferenceType<T>(typeDescriptor.boxedClass, initializer);
    }

    public static TypeDescriptor<Byte> byteWithDefault(byte d) {
        return new ByteType(d);
    }

    public static TypeDescriptor<Short> shortWithDefault(short d) {
        return new ShortType(d);
    }

    public static TypeDescriptor<Integer> intWithDefault(int d) {
        return new IntType(d);
    }

    public static TypeDescriptor<Long> longWithDefault(long d) {
        return new LongType(d);
    }

    public static TypeDescriptor<Boolean> booleanWithDefault(boolean d) {
        return new BooleanType(d);
    }

    public static TypeDescriptor<Character> charWithDefault(char d) {
        return new CharType(d);
    }

    public static TypeDescriptor<CodePoint> unicodeCharWithDefault(int d) {
        return new UnicodeCharType(CodePoint.valueOf(d));
    }

    public static <A, R> TypeDescriptor<Function<A, R>> function(TypeDescriptor<A> argType, TypeDescriptor<R> returnType) {
        Class<Function> functionClass = Function.class;
        return TypeDescriptor.reference(functionClass);
    }

    public static <T> TypeDescriptor<T> findType(Class<?> cls, TypeDescriptor<?> ... args) {
        Class[] typeMethodArgTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            typeMethodArgTypes[i] = TypeDescriptor.class;
        }
        try {
            Method typeMethod = cls.getMethod("_typeDescriptor", typeMethodArgTypes);
            TypeDescriptor ans = (TypeDescriptor)typeMethod.invoke(null, (Object[])args);
            return ans;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            TypeDescriptor<?> ans = TypeDescriptor.reference(cls);
            return ans;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    @FunctionalInterface
    public static interface Initializer<T> {
        public T defaultValue();
    }

    private static final class ReferenceType<T>
    extends TypeDescriptor<T> {
        private final Initializer<T> initializer;
        private TypeDescriptor<?> arrayType;

        public ReferenceType(Class<?> javaClass, Initializer<T> initializer) {
            super(javaClass);
            assert (!javaClass.isPrimitive());
            this.initializer = initializer;
        }

        @Override
        public T defaultValue() {
            return this.initializer.defaultValue();
        }

        @Override
        public boolean isInstance(Object object) {
            return this.boxedClass.isInstance(object);
        }

        @Override
        public TypeDescriptor<?> arrayType() {
            if (this.arrayType == null) {
                this.arrayType = ReferenceType.reference(this.newArray(0).getClass());
            }
            return this.arrayType;
        }

        @Override
        public T getArrayElement(Object array, int index) {
            Object[] castArray = (Object[])array;
            return (T)castArray[index];
        }

        @Override
        public void setArrayElement(Object array, int index, T value) {
            Object[] castArray = (Object[])array;
            castArray[index] = value;
        }

        @Override
        public Object cloneArray(Object array) {
            Object[] castArray = (Object[])array;
            return castArray.clone();
        }

        @Override
        public void fillArray(Object array, T value) {
            Object[] castArray = (Object[])array;
            int n = castArray.length;
            for (int i = 0; i < n; ++i) {
                castArray[i] = value;
            }
        }

        @Override
        public boolean arrayDeepEquals(Object array1, Object array2) {
            Object[] castArray1 = (Object[])array1;
            Object[] castArray2 = (Object[])array2;
            return Arrays.deepEquals(castArray1, castArray2);
        }
    }

    private static final class ByteType
    extends TypeDescriptor<Byte> {
        private final Byte DEFAULT;

        public ByteType(byte d) {
            super(Byte.TYPE);
            this.DEFAULT = d;
        }

        @Override
        public Byte defaultValue() {
            return this.DEFAULT;
        }

        @Override
        public boolean isInstance(Object object) {
            return object instanceof Byte;
        }

        @Override
        public TypeDescriptor<?> arrayType() {
            return BYTE_ARRAY;
        }

        @Override
        public Byte getArrayElement(Object array, int index) {
            return ((byte[])array)[index];
        }

        @Override
        public void setArrayElement(Object array, int index, Byte value) {
            ((byte[])array)[index] = value;
        }

        @Override
        public Object cloneArray(Object array) {
            return ((byte[])array).clone();
        }

        @Override
        public void fillArray(Object array, Byte value) {
            Arrays.fill((byte[])array, value);
        }

        @Override
        public boolean arrayDeepEquals(Object array1, Object array2) {
            byte[] castArray1 = (byte[])array1;
            byte[] castArray2 = (byte[])array2;
            return Arrays.equals(castArray1, castArray2);
        }
    }

    private static final class ShortType
    extends TypeDescriptor<Short> {
        private final Short DEFAULT;

        public ShortType(short d) {
            super(Short.TYPE);
            this.DEFAULT = d;
        }

        @Override
        public Short defaultValue() {
            return this.DEFAULT;
        }

        @Override
        public boolean isInstance(Object object) {
            return object instanceof Short;
        }

        @Override
        public TypeDescriptor<?> arrayType() {
            return SHORT_ARRAY;
        }

        @Override
        public Short getArrayElement(Object array, int index) {
            return ((short[])array)[index];
        }

        @Override
        public void setArrayElement(Object array, int index, Short value) {
            ((short[])array)[index] = value;
        }

        @Override
        public Object cloneArray(Object array) {
            return ((short[])array).clone();
        }

        @Override
        public void fillArray(Object array, Short value) {
            Arrays.fill((short[])array, value);
        }

        @Override
        public boolean arrayDeepEquals(Object array1, Object array2) {
            short[] castArray1 = (short[])array1;
            short[] castArray2 = (short[])array2;
            return Arrays.equals(castArray1, castArray2);
        }
    }

    private static final class IntType
    extends TypeDescriptor<Integer> {
        private final Integer DEFAULT;

        public IntType(int d) {
            super(Integer.TYPE);
            this.DEFAULT = d;
        }

        @Override
        public Integer defaultValue() {
            return this.DEFAULT;
        }

        @Override
        public boolean isInstance(Object object) {
            return object instanceof Integer;
        }

        @Override
        public TypeDescriptor<?> arrayType() {
            return INT_ARRAY;
        }

        @Override
        public Integer getArrayElement(Object array, int index) {
            return ((int[])array)[index];
        }

        @Override
        public void setArrayElement(Object array, int index, Integer value) {
            ((int[])array)[index] = value;
        }

        @Override
        public Object cloneArray(Object array) {
            return ((int[])array).clone();
        }

        @Override
        public void fillArray(Object array, Integer value) {
            Arrays.fill((int[])array, value);
        }

        @Override
        public boolean arrayDeepEquals(Object array1, Object array2) {
            int[] castArray1 = (int[])array1;
            int[] castArray2 = (int[])array2;
            return Arrays.equals(castArray1, castArray2);
        }
    }

    private static final class LongType
    extends TypeDescriptor<Long> {
        private final Long DEFAULT;

        public LongType(long d) {
            super(Long.TYPE);
            this.DEFAULT = d;
        }

        @Override
        public Long defaultValue() {
            return this.DEFAULT;
        }

        @Override
        public boolean isInstance(Object object) {
            return object instanceof Long;
        }

        @Override
        public TypeDescriptor<?> arrayType() {
            return LONG_ARRAY;
        }

        @Override
        public Long getArrayElement(Object array, int index) {
            return ((long[])array)[index];
        }

        @Override
        public void setArrayElement(Object array, int index, Long value) {
            ((long[])array)[index] = value;
        }

        @Override
        public Object cloneArray(Object array) {
            return ((long[])array).clone();
        }

        @Override
        public void fillArray(Object array, Long value) {
            Arrays.fill((long[])array, value);
        }

        @Override
        public boolean arrayDeepEquals(Object array1, Object array2) {
            long[] castArray1 = (long[])array1;
            long[] castArray2 = (long[])array2;
            return Arrays.equals(castArray1, castArray2);
        }
    }

    private static final class BooleanType
    extends TypeDescriptor<Boolean> {
        private final Boolean DEFAULT;

        public BooleanType(boolean d) {
            super(Boolean.TYPE);
            this.DEFAULT = d;
        }

        @Override
        public Boolean defaultValue() {
            return this.DEFAULT;
        }

        @Override
        public boolean isInstance(Object object) {
            return object instanceof Boolean;
        }

        @Override
        public TypeDescriptor<?> arrayType() {
            return BOOLEAN_ARRAY;
        }

        @Override
        public Boolean getArrayElement(Object array, int index) {
            return ((boolean[])array)[index];
        }

        @Override
        public void setArrayElement(Object array, int index, Boolean value) {
            ((boolean[])array)[index] = value;
        }

        @Override
        public Object cloneArray(Object array) {
            return ((boolean[])array).clone();
        }

        @Override
        public void fillArray(Object array, Boolean value) {
            Arrays.fill((boolean[])array, value);
        }

        @Override
        public boolean arrayDeepEquals(Object array1, Object array2) {
            boolean[] castArray1 = (boolean[])array1;
            boolean[] castArray2 = (boolean[])array2;
            return Arrays.equals(castArray1, castArray2);
        }
    }

    private static final class CharType
    extends TypeDescriptor<Character> {
        private final Character DEFAULT;

        public CharType(char d) {
            super(Character.TYPE);
            this.DEFAULT = Character.valueOf(d);
        }

        @Override
        public Character defaultValue() {
            return this.DEFAULT;
        }

        @Override
        public boolean isInstance(Object object) {
            return object instanceof Character;
        }

        @Override
        public TypeDescriptor<?> arrayType() {
            return CHAR_ARRAY;
        }

        @Override
        public Character getArrayElement(Object array, int index) {
            return Character.valueOf(((char[])array)[index]);
        }

        @Override
        public void setArrayElement(Object array, int index, Character value) {
            ((char[])array)[index] = value.charValue();
        }

        @Override
        public Object cloneArray(Object array) {
            return ((char[])array).clone();
        }

        @Override
        public void fillArray(Object array, Character value) {
            Arrays.fill((char[])array, value.charValue());
        }

        @Override
        public boolean arrayDeepEquals(Object array1, Object array2) {
            char[] castArray1 = (char[])array1;
            char[] castArray2 = (char[])array2;
            return Arrays.equals(castArray1, castArray2);
        }
    }

    private static final class UnicodeCharType
    extends TypeDescriptor<CodePoint> {
        private final CodePoint DEFAULT;

        public UnicodeCharType(CodePoint d) {
            super(CodePoint.class, Integer.TYPE);
            this.DEFAULT = d;
        }

        @Override
        public CodePoint defaultValue() {
            return this.DEFAULT;
        }

        @Override
        public boolean isInstance(Object object) {
            return object instanceof CodePoint;
        }

        @Override
        public TypeDescriptor<?> arrayType() {
            return UNICODE_CHAR_ARRAY;
        }

        @Override
        public CodePoint getArrayElement(Object array, int index) {
            return CodePoint.valueOf(((int[])array)[index]);
        }

        @Override
        public void setArrayElement(Object array, int index, CodePoint value) {
            ((int[])array)[index] = value.value();
        }

        @Override
        public Object cloneArray(Object array) {
            return ((int[])array).clone();
        }

        @Override
        public void fillArray(Object array, CodePoint value) {
            Arrays.fill((int[])array, value.value());
        }

        @Override
        public boolean arrayDeepEquals(Object array1, Object array2) {
            int[] castArray1 = (int[])array1;
            int[] castArray2 = (int[])array2;
            return Arrays.equals(castArray1, castArray2);
        }
    }
}

