/*
 * Decompiled with CFR 0.152.
 */
package dafny;

import dafny.TypeDescriptor;
import java.util.List;

public final class Array<T>
implements Cloneable {
    private final TypeDescriptor<T> eltType;
    private final Object array;

    private Array(TypeDescriptor<T> eltType, Object array) {
        this.eltType = eltType;
        this.array = array;
    }

    public static <T> Array<T> newArray(TypeDescriptor<T> eltType, int length) {
        return new Array<T>(eltType, eltType.newArray(length));
    }

    public static <T> Array<T> fromList(TypeDescriptor<T> eltType, List<T> elements) {
        return new Array<T>(eltType, eltType.toArray(elements));
    }

    public TypeDescriptor<T> elementType() {
        return this.eltType;
    }

    public Object unwrap() {
        return this.array;
    }

    public T get(int index) {
        return this.eltType.getArrayElement(this.array, index);
    }

    public void set(int index, T value) {
        this.eltType.setArrayElement(this.array, index, value);
    }

    public int length() {
        return this.eltType.getArrayLength(this.array);
    }

    public void fill(T value) {
        this.eltType.fillArray(this.array, value);
    }

    public Array<T> copy() {
        return new Array<T>(this.eltType, this.eltType.cloneArray(this.array));
    }

    public void copy(int offset, Array<T> to, int toOffset, int length) {
        System.arraycopy(this.array, offset, to.array, toOffset, length);
    }

    public Array<T> copyOfRange(int lo, int hi) {
        Array<T> newArray = Array.newArray(this.eltType, hi - lo);
        this.copy(lo, newArray, 0, hi - lo);
        return newArray;
    }

    public boolean deepEquals(Array<T> other) {
        return this.eltType.arrayDeepEquals(this.array, other.array);
    }

    public static <T> Array<T> wrap(TypeDescriptor<T> eltType, Object array) {
        return new Array<T>(eltType, array);
    }

    public static <T> Array<T> wrap(TypeDescriptor<T> eltType, T[] array) {
        return new Array<T>(eltType, array);
    }

    public static Array<Byte> wrap(byte[] array) {
        return new Array<Byte>(TypeDescriptor.BYTE, array);
    }

    public static Array<Short> wrap(short[] array) {
        return new Array<Short>(TypeDescriptor.SHORT, array);
    }

    public static Array<Integer> wrap(int[] array) {
        return new Array<Integer>(TypeDescriptor.INT, array);
    }

    public static Array<Long> wrap(long[] array) {
        return new Array<Long>(TypeDescriptor.LONG, array);
    }

    public static Array<Boolean> wrap(boolean[] array) {
        return new Array<Boolean>(TypeDescriptor.BOOLEAN, array);
    }

    public static Array<Character> wrap(char[] array) {
        return new Array<Character>(TypeDescriptor.CHAR, array);
    }

    public static Object unwrap(Array<?> array) {
        return array.unwrap();
    }

    public static <T> T[] unwrapObjects(Array<T> array) {
        return (Object[])array.array;
    }

    public static byte[] unwrapBytes(Array<Byte> array) {
        return (byte[])array.array;
    }

    public static short[] unwrapShorts(Array<Short> array) {
        return (short[])array.array;
    }

    public static int[] unwrapInts(Array<Integer> array) {
        return (int[])array.array;
    }

    public static long[] unwrapLongs(Array<Long> array) {
        return (long[])array.array;
    }

    public static boolean[] unwrapBooleans(Array<Boolean> array) {
        return (boolean[])array.array;
    }

    public static char[] unwrapChars(Array<Character> array) {
        return (char[])array.array;
    }
}

