/*
 * Decompiled with CFR 0.152.
 */
package dafny;

import dafny.Array;
import dafny.ArrayDafnySequence;
import dafny.CodePoint;
import dafny.ConcatDafnySequence;
import dafny.DafnyMultiset;
import dafny.Helpers;
import dafny.NonLazyDafnySequence;
import dafny.StringDafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Function;

public abstract class DafnySequence<T>
implements Iterable<T> {
    DafnySequence() {
    }

    @SafeVarargs
    public static <T> DafnySequence<T> of(TypeDescriptor<T> type, T ... elements) {
        Array<Object> array;
        if (!type.isPrimitive()) {
            array = Array.wrap(type, (Object[])elements.clone());
        } else {
            array = Array.newArray(type, elements.length);
            for (int i = 0; i < elements.length; ++i) {
                array.set(i, elements[i]);
            }
        }
        return DafnySequence.fromArray(type, array);
    }

    public static DafnySequence<Byte> of(byte ... elements) {
        return DafnySequence.fromArray(TypeDescriptor.BYTE, Array.wrap(elements));
    }

    public static DafnySequence<Short> of(short ... elements) {
        return DafnySequence.fromArray(TypeDescriptor.SHORT, Array.wrap(elements));
    }

    public static DafnySequence<Integer> of(int ... elements) {
        return DafnySequence.fromArray(TypeDescriptor.INT, Array.wrap(elements));
    }

    public static DafnySequence<Long> of(long ... elements) {
        return DafnySequence.fromArray(TypeDescriptor.LONG, Array.wrap(elements));
    }

    public static DafnySequence<Boolean> of(boolean ... elements) {
        return DafnySequence.fromArray(TypeDescriptor.BOOLEAN, Array.wrap(elements));
    }

    public static DafnySequence<Character> of(char ... elements) {
        return DafnySequence.fromArray(TypeDescriptor.CHAR, Array.wrap(elements));
    }

    public static <T> DafnySequence<T> empty(TypeDescriptor<T> type) {
        if (type == TypeDescriptor.CHAR) {
            return DafnySequence.asString("");
        }
        return ArrayDafnySequence.empty(type);
    }

    public static <T> DafnySequence<T> fromArray(TypeDescriptor<T> type, Array<T> elements) {
        return DafnySequence.fromRawArray(type, elements.unwrap());
    }

    public static <T> DafnySequence<T> fromRawArray(TypeDescriptor<T> type, Object elements) {
        if (type == TypeDescriptor.CHAR) {
            return DafnySequence.asString(new String((char[])elements));
        }
        return new ArrayDafnySequence<T>(Array.wrap(type, elements).copy());
    }

    public static <T> DafnySequence<T> unsafeWrapArray(Array<T> elements) {
        return new ArrayDafnySequence<T>(elements, true);
    }

    public static <T> DafnySequence<T> unsafeWrapRawArray(TypeDescriptor<T> type, Object elements) {
        return new ArrayDafnySequence<T>(Array.wrap(type, elements));
    }

    public static <T> DafnySequence<T> fromArrayRange(TypeDescriptor<T> type, Array<T> elements, int lo, int hi) {
        return new ArrayDafnySequence<T>(elements.copyOfRange(lo, hi));
    }

    public static <T> DafnySequence<T> fromRawArrayRange(TypeDescriptor<T> type, Object elements, int lo, int hi) {
        return DafnySequence.fromArrayRange(type, Array.wrap(type, elements), lo, hi);
    }

    public static <T> DafnySequence<T> fromList(TypeDescriptor<T> type, List<T> l) {
        assert (l != null) : "Precondition Violation";
        return new ArrayDafnySequence<T>(Array.fromList(type, l));
    }

    public static DafnySequence<Character> asString(String s) {
        return new StringDafnySequence(s);
    }

    public static DafnySequence<CodePoint> asUnicodeString(String s) {
        int[] codePoints = new int[s.codePointCount(0, s.length())];
        int charIndex = 0;
        for (int codePointIndex = 0; codePointIndex < codePoints.length; ++codePointIndex) {
            char c1;
            if (Character.isHighSurrogate(c1 = s.charAt(charIndex++))) {
                char c2;
                if (charIndex >= s.length()) {
                    throw new IllegalArgumentException();
                }
                if (!Character.isLowSurrogate(c2 = s.charAt(charIndex++))) {
                    throw new IllegalArgumentException();
                }
                codePoints[codePointIndex] = Character.toCodePoint(c1, c2);
                continue;
            }
            codePoints[codePointIndex] = c1;
        }
        return new ArrayDafnySequence<CodePoint>(Array.wrap(TypeDescriptor.UNICODE_CHAR, (Object)codePoints));
    }

    public static DafnySequence<Byte> fromBytes(byte[] bytes) {
        return DafnySequence.unsafeWrapBytes((byte[])bytes.clone());
    }

    public static DafnySequence<Byte> unsafeWrapBytes(byte[] bytes) {
        return DafnySequence.unsafeWrapArray(Array.wrap(bytes));
    }

    public static <T> DafnySequence<T> Create(TypeDescriptor<T> type, BigInteger length, Function<BigInteger, T> init) {
        int len = length.intValueExact();
        Array<T> values = Array.newArray(type, len);
        for (int i = 0; i < len; ++i) {
            values.set(i, init.apply(BigInteger.valueOf(i)));
        }
        return DafnySequence.fromArray(type, values);
    }

    public static <T> TypeDescriptor<DafnySequence<? extends T>> _typeDescriptor(TypeDescriptor<T> elementType) {
        return TypeDescriptor.referenceWithDefault(DafnySequence.class, DafnySequence.empty(elementType));
    }

    public Array<T> toArray() {
        return Array.fromList(this.elementType(), this.asList());
    }

    public Object toRawArray() {
        return this.toArray().unwrap();
    }

    public static byte[] toByteArray(DafnySequence<Byte> seq) {
        return Array.unwrapBytes(seq.toArray());
    }

    public static int[] toIntArray(DafnySequence<Integer> seq) {
        return Array.unwrapInts(seq.toArray());
    }

    public abstract TypeDescriptor<T> elementType();

    public <U> boolean isPrefixOf(DafnySequence<U> other) {
        assert (other != null) : "Precondition Violation";
        if (other.length() < this.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (Objects.equals(this.select(i), other.select(i))) continue;
            return false;
        }
        return true;
    }

    public <U> boolean isProperPrefixOf(DafnySequence<U> other) {
        assert (other != null) : "Precondition Violation";
        return this.length() < other.length() && this.isPrefixOf(other);
    }

    protected List<T> asList() {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return DafnySequence.this.select(index);
            }

            @Override
            public int size() {
                return DafnySequence.this.length();
            }

            @Override
            public Iterator<T> iterator() {
                return DafnySequence.this.iterator();
            }
        };
    }

    public static <T> DafnySequence<T> concatenate(DafnySequence<? extends T> th, DafnySequence<? extends T> other) {
        assert (th != null) : "Precondition Violation";
        assert (other != null) : "Precondition Violation";
        if (th.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return th;
        }
        return new ConcatDafnySequence<T>(th, other);
    }

    abstract Copier<T> newCopier(int var1);

    public abstract T select(int var1);

    public T selectUnsigned(byte i) {
        return this.select(Byte.toUnsignedInt(i));
    }

    public T selectUnsigned(short i) {
        return this.select(Short.toUnsignedInt(i));
    }

    public T selectUnsigned(int i) {
        return this.select(Integer.toUnsignedLong(i));
    }

    public T select(long i) {
        return this.select(BigInteger.valueOf(i));
    }

    public T selectUnsigned(long i) {
        return this.select(Helpers.unsignedLongToBigInteger(i));
    }

    public T select(BigInteger i) {
        return this.select(i.intValue());
    }

    public abstract int length();

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public final int cardinalityInt() {
        return this.length();
    }

    public abstract <R> DafnySequence<R> update(int var1, R var2);

    public static <R> DafnySequence<R> update(DafnySequence<? extends R> seq, BigInteger b, R t) {
        return seq.update(b.intValue(), t);
    }

    public static <R> DafnySequence<R> update(DafnySequence<? extends R> seq, int idx, R t) {
        return seq.update(idx, t);
    }

    public static <R> DafnySequence<R> update(DafnySequence<? extends R> seq, long idx, R t) {
        return seq.update((int)idx, t);
    }

    public boolean contains(Object t) {
        assert (t != null) : "Precondition Violation";
        return this.asList().indexOf(t) != -1;
    }

    public abstract DafnySequence<T> subsequence(int var1, int var2);

    public final DafnySequence<T> drop(int lo) {
        assert (lo >= 0 && lo <= this.length()) : "Precondition Violation";
        return this.subsequence(lo, this.length());
    }

    public DafnySequence<T> dropUnsigned(byte lo) {
        return this.drop(Byte.toUnsignedInt(lo));
    }

    public DafnySequence<T> dropUnsigned(short lo) {
        return this.drop(Short.toUnsignedInt(lo));
    }

    public DafnySequence<T> dropUnsigned(int lo) {
        return this.drop(Integer.toUnsignedLong(lo));
    }

    public DafnySequence<T> drop(long lo) {
        return this.drop(BigInteger.valueOf(lo));
    }

    public DafnySequence<T> dropUnsigned(long lo) {
        return this.drop(Helpers.unsignedLongToBigInteger(lo));
    }

    public DafnySequence<T> drop(BigInteger lo) {
        return this.drop(lo.intValue());
    }

    public final DafnySequence<T> take(int hi) {
        assert (hi >= 0 && hi <= this.length()) : "Precondition Violation";
        return this.subsequence(0, hi);
    }

    public DafnySequence<T> takeUnsigned(byte hi) {
        return this.take(Byte.toUnsignedInt(hi));
    }

    public DafnySequence<T> takeUnsigned(short hi) {
        return this.take(Short.toUnsignedInt(hi));
    }

    public DafnySequence<T> takeUnsigned(int hi) {
        return this.take(Integer.toUnsignedLong(hi));
    }

    public DafnySequence<T> take(long hi) {
        return this.take(BigInteger.valueOf(hi));
    }

    public DafnySequence<T> takeUnsigned(long hi) {
        return this.take(Helpers.unsignedLongToBigInteger(hi));
    }

    public DafnySequence<T> take(BigInteger hi) {
        return this.take(hi.intValue());
    }

    public final DafnySequence<? extends DafnySequence<? extends T>> slice(List<Integer> l) {
        assert (l != null) : "Precondition Violation";
        ArrayList<DafnySequence<T>> list = new ArrayList<DafnySequence<T>>();
        int curr = 0;
        for (Integer i : l) {
            assert (i != null) : "Precondition Violation";
            list.add(this.subsequence(curr, curr + i));
            curr += i.intValue();
        }
        TypeDescriptor<T> eexx = this.elementType();
        TypeDescriptor<DafnySequence<T>> ssxx = DafnySequence._typeDescriptor(eexx);
        return DafnySequence.fromList(ssxx, list);
    }

    public DafnyMultiset<T> asDafnyMultiset() {
        return new DafnyMultiset<T>(this.asList());
    }

    @Override
    public abstract Iterator<T> iterator();

    @Override
    public Spliterator<T> spliterator() {
        return this.asList().spliterator();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DafnySequence)) {
            return false;
        }
        DafnySequence other = (DafnySequence)obj;
        return this.equalsNonLazy(other.force());
    }

    protected boolean equalsNonLazy(NonLazyDafnySequence<T> other) {
        return this.asList().equals(other.asList());
    }

    public abstract int hashCode();

    public String toString() {
        return this.asList().toString();
    }

    public String verbatimString() {
        if (this.elementType() == TypeDescriptor.UNICODE_CHAR) {
            int[] codePoints = new int[this.length()];
            int i = 0;
            for (Integer ch : this.asList()) {
                codePoints[i++] = ch;
            }
            return new String(codePoints, 0, codePoints.length);
        }
        StringBuilder builder = new StringBuilder(this.length());
        for (Character ch : this.asList()) {
            builder.append(ch);
        }
        return builder.toString();
    }

    public Iterable<T> Elements() {
        return this;
    }

    public HashSet<T> UniqueElements() {
        return new HashSet<T>(this.asList());
    }

    protected abstract NonLazyDafnySequence<T> force();

    static interface Copier<T> {
        public void copyFrom(DafnySequence<T> var1);

        public NonLazyDafnySequence<T> result();
    }
}

