/*
 * Decompiled with CFR 0.152.
 */
package ch.sbs.jhyphen;

import ch.sbs.jhyphen.CompilationException;
import ch.sbs.jhyphen.Hyphen;
import ch.sbs.jhyphen.HyphenationException;
import ch.sbs.jhyphen.StandardHyphenationException;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Hyphenator {
    public static final byte SHY = 1;
    public static final byte ZWSP = 2;
    private static ByteBuffer wordHyphens = ByteBuffer.allocate(50);
    private static final Map<File, Charset> charsets = new HashMap<File, Charset>();
    private final Pointer dictionary;
    private final Charset charset;

    public Hyphenator(File dictionaryFile) throws CompilationException, FileNotFoundException {
        if (!dictionaryFile.exists()) {
            throw new FileNotFoundException("Dictionary file at " + dictionaryFile.getAbsolutePath() + " doesn't exist.");
        }
        try {
            this.charset = Hyphenator.getCharset(dictionaryFile);
        }
        catch (UnsupportedCharsetException e) {
            throw new CompilationException(e);
        }
        this.dictionary = Hyphen.getLibrary().hnj_hyphen_load(dictionaryFile.getAbsolutePath());
    }

    public String hyphenate(String text, Character shy, Character zwsp) throws StandardHyphenationException {
        int i;
        if (shy == null && zwsp == null) {
            return text;
        }
        byte[] hyphens = this.hyphenate(text);
        StringBuffer hyphenatedText = new StringBuffer();
        for (i = 0; i < hyphens.length; ++i) {
            hyphenatedText.append(text.charAt(i));
            if (shy != null && hyphens[i] == 1) {
                hyphenatedText.append(shy);
                continue;
            }
            if (zwsp == null || hyphens[i] != 2) continue;
            hyphenatedText.append(zwsp);
        }
        hyphenatedText.append(text.charAt(i));
        return hyphenatedText.toString();
    }

    public byte[] hyphenate(String text) throws StandardHyphenationException {
        Matcher matcher = Pattern.compile("['\\p{L}]+").matcher(text);
        StringBuffer hyphenBuffer = new StringBuffer();
        int pos = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            while (pos++ < start) {
                hyphenBuffer.append('0');
            }
            String word = text.substring(start, end);
            byte[] wordBytes = this.encode(word = word.toLowerCase());
            int wordSize = wordBytes.length;
            if (wordSize > wordHyphens.capacity()) {
                wordHyphens = ByteBuffer.allocate(wordSize * 2);
            }
            PointerByReference repPointer = new PointerByReference(Pointer.NULL);
            PointerByReference posPointer = new PointerByReference(Pointer.NULL);
            PointerByReference cutPointer = new PointerByReference(Pointer.NULL);
            Hyphen.getLibrary().hnj_hyphen_hyphenate2(this.dictionary, wordBytes, wordSize, wordHyphens, null, repPointer, posPointer, cutPointer);
            if (repPointer.getValue() != Pointer.NULL) {
                throw new StandardHyphenationException("Text contains non-standard hyphenation points.");
            }
            hyphenBuffer.append(new String(wordHyphens.array(), 0, word.length()));
            pos = end;
        }
        while (pos < text.length()) {
            hyphenBuffer.append('0');
            ++pos;
        }
        hyphenBuffer.deleteCharAt(pos - 1);
        byte[] hyphens = new byte[hyphenBuffer.length()];
        StringCharacterIterator iter = new StringCharacterIterator(hyphenBuffer.toString());
        int i = 0;
        char c = iter.first();
        while (c != '\uffff') {
            hyphens[i++] = (c & '\u0001') > 0 ? (byte)1 : 0;
            c = iter.next();
        }
        matcher = Pattern.compile("[\\p{L}\\p{N}]-(?=[\\p{L}\\p{N}])").matcher(text);
        while (matcher.find()) {
            hyphens[matcher.start() + 1] = 2;
        }
        return hyphens;
    }

    protected String hyphenate(String text, int lineLength, Character hyphen, Character noHyphen) {
        Break b = this.hyphenate(text, lineLength);
        String hyphenatedText = "";
        hyphenatedText = hyphenatedText + b.getText().substring(0, b.getBreakPosition());
        if (b.hasHyphen()) {
            if (hyphen != null) {
                hyphenatedText = hyphenatedText + hyphen;
            }
        } else if (noHyphen != null) {
            hyphenatedText = hyphenatedText + noHyphen;
        }
        hyphenatedText = hyphenatedText + b.getText().substring(b.getBreakPosition());
        return hyphenatedText;
    }

    public Break hyphenate(String text, int lineLength) {
        if (text.length() <= lineLength) {
            return new NoBreak(text);
        }
        ABreak lastOkBreak = null;
        int p = 0;
        boolean isWord = false;
        block0: for (String s : Hyphenator.splitInclDelimiter(text, Pattern.compile("['\\p{L}]+"))) {
            if (isWord) {
                int[] cut;
                int[] pos;
                String[] rep;
                String word = s;
                int wordStart = p;
                byte[] wordBytes = this.encode(word = word.toLowerCase());
                int wordSize = wordBytes.length;
                if (wordSize > wordHyphens.capacity()) {
                    wordHyphens = ByteBuffer.allocate(wordSize * 2);
                }
                PointerByReference repPointer = new PointerByReference(Pointer.NULL);
                PointerByReference posPointer = new PointerByReference(Pointer.NULL);
                PointerByReference cutPointer = new PointerByReference(Pointer.NULL);
                Hyphen.getLibrary().hnj_hyphen_hyphenate2(this.dictionary, wordBytes, wordSize, wordHyphens, null, repPointer, posPointer, cutPointer);
                String hyphenString = new String(wordHyphens.array(), 0, word.length());
                if (repPointer.getValue() != Pointer.NULL && posPointer.getValue() != Pointer.NULL && cutPointer.getValue() != Pointer.NULL) {
                    rep = repPointer.getValue().getStringArray(0L, wordSize, this.charset.name());
                    pos = posPointer.getValue().getIntArray(0L, wordSize);
                    cut = cutPointer.getValue().getIntArray(0L, wordSize);
                } else {
                    rep = new String[wordSize];
                    pos = new int[wordSize];
                    cut = new int[wordSize];
                }
                StringCharacterIterator hyphens = new StringCharacterIterator(hyphenString);
                int posInWord = 0;
                char c = hyphens.first();
                while (c != '\uffff') {
                    ++posInWord;
                    if ((c & '\u0001') > 0) {
                        ABreak b = rep != null && rep[posInWord - 1] != null ? new NonStandardBreak(text, wordStart + posInWord - pos[posInWord - 1], cut[posInWord - 1], rep[posInWord - 1]) : new StandardBreak(text, wordStart + posInWord);
                        if (b.getBreakPosition() > lineLength) break block0;
                        if (lastOkBreak == null || b.compareTo(lastOkBreak) > 0) {
                            lastOkBreak = b;
                        }
                    }
                    c = hyphens.next();
                }
            } else if (!s.isEmpty()) {
                Matcher m = Pattern.compile("([\\p{L}\\p{N}]|^)-(?=([\\p{L}\\p{N}]|$))").matcher(s);
                while (m.find()) {
                    String g = m.group();
                    if (g.charAt(0) == '-' && p == 0 || g.charAt(g.length() - 1) == '-' && p + s.length() == text.length()) continue;
                    BreakAfterHyphen b = new BreakAfterHyphen(text, p + m.start() + g.indexOf(45) + 1);
                    if (b.getBreakPosition() > lineLength) break block0;
                    if (lastOkBreak != null && b.compareTo(lastOkBreak) <= 0) continue;
                    lastOkBreak = b;
                }
            }
            p += s.length();
            isWord = !isWord;
        }
        if (lastOkBreak != null) {
            return lastOkBreak;
        }
        return new EmptyLine(text);
    }

    public void close() {
        Hyphen.getLibrary().hnj_hyphen_free(this.dictionary);
    }

    private byte[] encode(String str) {
        return this.charset.encode(str).array();
    }

    private static Charset getCharset(File dictionaryFile) throws UnsupportedCharsetException, FileNotFoundException {
        Charset cs = charsets.get(dictionaryFile);
        if (cs == null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(dictionaryFile));
                String charsetName = reader.readLine();
                charsetName = charsetName.replaceAll("\\s+", "");
                cs = Charset.forName(charsetName);
                charsets.put(dictionaryFile, cs);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read first line of file");
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return cs;
    }

    private static Iterable<String> splitInclDelimiter(final String text, final Pattern delimiterPattern) {
        return new Iterable<String>(){

            @Override
            public final Iterator<String> iterator() {
                return new Iterator<String>(){
                    Matcher m;
                    int i;
                    String nextNext;
                    String next;
                    boolean done;
                    {
                        this.m = delimiterPattern.matcher(text);
                        this.i = 0;
                        this.nextNext = null;
                        this.next = null;
                        this.done = false;
                    }

                    private String computeNext() {
                        if (this.nextNext != null) {
                            String n = this.nextNext;
                            this.nextNext = null;
                            return n;
                        }
                        if (this.m.find()) {
                            String n = text.substring(this.i, this.m.start());
                            this.nextNext = this.m.group();
                            this.i = this.m.end();
                            return n;
                        }
                        if (this.i >= 0) {
                            String n = text.substring(this.i);
                            this.i = -1;
                            return n;
                        }
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.done) {
                            return false;
                        }
                        if (this.next != null) {
                            return true;
                        }
                        this.next = this.computeNext();
                        if (this.next == null) {
                            this.done = true;
                        }
                        return this.hasNext();
                    }

                    @Override
                    public String next() throws NoSuchElementException {
                        if (this.done) {
                            throw new NoSuchElementException();
                        }
                        if (this.next != null) {
                            String n = this.next;
                            this.next = null;
                            return n;
                        }
                        this.next = this.computeNext();
                        if (this.next == null) {
                            this.done = true;
                        }
                        return this.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static class NonStandardBreak
    extends ABreak {
        private NonStandardBreak(String text, int repStart, int repLength, String repString) {
            int breakPosInRep = repString.indexOf(61);
            if (breakPosInRep < 0) {
                throw new HyphenationException("Table error");
            }
            String toReplace = text.substring(repStart, repStart + repLength);
            if (toReplace.toUpperCase().equals(toReplace) && !toReplace.toLowerCase().equals(toReplace)) {
                repString = repString.toUpperCase();
            }
            this.text = text.substring(0, repStart) + repString.substring(0, breakPosInRep) + repString.substring(breakPosInRep + 1) + text.substring(repStart + repLength);
            this.position = repStart + breakPosInRep;
            this.hyphen = true;
        }
    }

    private static class StandardBreak
    extends ABreak {
        private StandardBreak(String text, int position) {
            this.text = text;
            this.position = position;
            this.hyphen = true;
        }
    }

    private static class BreakAfterHyphen
    extends ABreak {
        private BreakAfterHyphen(String text, int position) {
            this.text = text;
            this.position = position;
            this.hyphen = false;
        }
    }

    private static class EmptyLine
    extends ABreak {
        private EmptyLine(String text) {
            this.text = text;
            this.position = 0;
            this.hyphen = false;
        }
    }

    private static class NoBreak
    extends ABreak {
        private NoBreak(String text) {
            this.text = text;
            this.position = text.length();
            this.hyphen = false;
        }
    }

    private static abstract class ABreak
    implements Break {
        protected String text;
        protected int position;
        protected boolean hyphen;

        private ABreak() {
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public int getBreakPosition() {
            return this.position;
        }

        @Override
        public boolean hasHyphen() {
            return this.hyphen;
        }

        @Override
        public int compareTo(Break that) {
            if (this.getBreakPosition() > that.getBreakPosition()) {
                return 1;
            }
            if (this.getBreakPosition() < that.getBreakPosition()) {
                return -1;
            }
            if (!this.hasHyphen() && that.hasHyphen()) {
                return 1;
            }
            if (this.hasHyphen() && !that.hasHyphen()) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            String s = this.getText().substring(0, this.getBreakPosition());
            if (this.hasHyphen()) {
                s = s + "-";
            }
            return s;
        }
    }

    public static interface Break
    extends Comparable<Break> {
        public String getText();

        public int getBreakPosition();

        public boolean hasHyphen();
    }
}

