/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.braille.css;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermNumber;
import cz.vutbr.web.css.TermPair;
import cz.vutbr.web.css.TermPercent;
import cz.vutbr.web.css.TermString;
import cz.vutbr.web.domassign.DeclarationTransformer;
import cz.vutbr.web.domassign.Repeater;
import cz.vutbr.web.domassign.Variator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.daisy.braille.css.BrailleCSSProperty;
import org.daisy.braille.css.SupportedBrailleCSS;
import org.daisy.braille.css.TermDotPattern;

public class BrailleCSSDeclarationTransformer
extends DeclarationTransformer {
    private static final Set<String> validContentFuncNames = new HashSet<String>(Arrays.asList("content", "attr", "counter", "counters", "string", "leader", "flow", "target-text", "target-string", "target-counter", "target-content"));
    private static final Pattern customContentFuncName = Pattern.compile("^-.*");
    private static final Pattern customDisplayIdent = Pattern.compile("^-.*");

    public BrailleCSSDeclarationTransformer() {
        this(new SupportedBrailleCSS());
    }

    public BrailleCSSDeclarationTransformer(SupportedCSS css) {
        super(css);
    }

    protected Map<String, Method> parsingMethods() {
        HashMap<String, Method> map = new HashMap<String, Method>(this.css.getTotalProperties(), 1.0f);
        for (String property : this.css.getDefinedPropertyNames()) {
            try {
                Method m = BrailleCSSDeclarationTransformer.class.getDeclaredMethod(BrailleCSSDeclarationTransformer.camelCase((String)("process-" + property)), Declaration.class, Map.class, Map.class);
                map.put(property, m);
            }
            catch (Exception e) {
                try {
                    Method m = DeclarationTransformer.class.getDeclaredMethod(DeclarationTransformer.camelCase((String)("process-" + property)), Declaration.class, Map.class, Map.class);
                    map.put(property, m);
                }
                catch (Exception e2) {
                    log.debug("Unable to find method for property {}.", (Object)property);
                }
            }
        }
        log.debug("Totally found {} parsing methods", (Object)map.size());
        return map;
    }

    public boolean parseDeclaration(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        String property = d.getProperty().toLowerCase();
        if (!this.css.isSupportedCSSProperty(property)) {
            if (property.startsWith("-")) {
                if (d.size() == 1) {
                    Term term = (Term)d.get(0);
                    if (term instanceof TermIdent) {
                        return this.genericProperty(BrailleCSSProperty.GenericVendorCSSPropertyProxy.class, (TermIdent)term, true, properties, property);
                    }
                    if (term instanceof TermInteger) {
                        return this.genericTerm(TermInteger.class, term, d.getProperty(), BrailleCSSProperty.GenericVendorCSSPropertyProxy.valueOf(null), false, properties, values);
                    }
                    if (term instanceof TermFunction) {
                        return this.genericTerm(TermFunction.class, term, d.getProperty(), BrailleCSSProperty.GenericVendorCSSPropertyProxy.valueOf(null), false, properties, values);
                    }
                }
                log.warn("Ignoring unsupported declaration: " + BrailleCSSDeclarationTransformer.declarationToString(d));
            } else {
                log.debug("Ignoring unsupported property: " + property);
            }
        } else {
            block16: {
                try {
                    Method m = (Method)this.methods.get(property);
                    if (m == null) break block16;
                    try {
                        return (Boolean)m.invoke((Object)this, d, properties, values);
                    }
                    catch (IllegalAccessException e) {
                        if (super.parseDeclaration(d, properties, values)) {
                            return true;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        if (super.parseDeclaration(d, properties, values)) {
                            return true;
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            log.warn("Ignoring unsupported declaration: " + BrailleCSSDeclarationTransformer.declarationToString(d));
        }
        return false;
    }

    private static String declarationToString(Declaration d) {
        StringBuilder b = new StringBuilder();
        b.append(d.getProperty()).append(":");
        for (Term t : d) {
            b.append(" ").append(t);
        }
        b.append(";");
        return b.toString();
    }

    private boolean processBorder(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        BorderVariator border = new BorderVariator();
        border.assignTermsFromDeclaration(d);
        border.assignDefaults(properties, values);
        return border.vary(properties, values);
    }

    private boolean processBorderAlign(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        BorderAlignRepeater r = new BorderAlignRepeater();
        return r.repeatOverFourTermDeclaration(d, properties, values);
    }

    private boolean processBorderBottom(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        BorderSideVariator borderSide = new BorderSideVariator("bottom");
        borderSide.assignTermsFromDeclaration(d);
        borderSide.assignDefaults(properties, values);
        return borderSide.vary(properties, values);
    }

    private boolean processBorderBottomAlign(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdent(BrailleCSSProperty.BorderAlign.class, d, properties);
    }

    private boolean processBorderBottomPattern(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrDotPattern(BrailleCSSProperty.BorderPattern.class, BrailleCSSProperty.BorderPattern.dot_pattern, d, properties, values);
    }

    private boolean processBorderBottomStyle(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdent(BrailleCSSProperty.BorderStyle.class, d, properties);
    }

    private boolean processBorderBottomWidth(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.BorderWidth.class, BrailleCSSProperty.BorderWidth.integer, true, d, properties, values);
    }

    private boolean processBorderLeft(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        BorderSideVariator borderSide = new BorderSideVariator("left");
        borderSide.assignTermsFromDeclaration(d);
        borderSide.assignDefaults(properties, values);
        return borderSide.vary(properties, values);
    }

    private boolean processBorderLeftAlign(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdent(BrailleCSSProperty.BorderAlign.class, d, properties);
    }

    private boolean processBorderLeftPattern(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrDotPattern(BrailleCSSProperty.BorderPattern.class, BrailleCSSProperty.BorderPattern.dot_pattern, d, properties, values);
    }

    private boolean processBorderLeftStyle(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdent(BrailleCSSProperty.BorderStyle.class, d, properties);
    }

    private boolean processBorderLeftWidth(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.BorderWidth.class, BrailleCSSProperty.BorderWidth.integer, true, d, properties, values);
    }

    private boolean processBorderRight(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        BorderSideVariator borderSide = new BorderSideVariator("right");
        borderSide.assignTermsFromDeclaration(d);
        borderSide.assignDefaults(properties, values);
        return borderSide.vary(properties, values);
    }

    private boolean processBorderRightAlign(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdent(BrailleCSSProperty.BorderAlign.class, d, properties);
    }

    private boolean processBorderRightPattern(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrDotPattern(BrailleCSSProperty.BorderPattern.class, BrailleCSSProperty.BorderPattern.dot_pattern, d, properties, values);
    }

    private boolean processBorderRightStyle(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdent(BrailleCSSProperty.BorderStyle.class, d, properties);
    }

    private boolean processBorderRightWidth(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.BorderWidth.class, BrailleCSSProperty.BorderWidth.integer, true, d, properties, values);
    }

    private boolean processBorderStyle(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        BorderStyleRepeater r = new BorderStyleRepeater();
        return r.repeatOverFourTermDeclaration(d, properties, values);
    }

    private boolean processBorderTop(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        BorderSideVariator borderSide = new BorderSideVariator("top");
        borderSide.assignTermsFromDeclaration(d);
        borderSide.assignDefaults(properties, values);
        return borderSide.vary(properties, values);
    }

    private boolean processBorderTopAlign(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdent(BrailleCSSProperty.BorderAlign.class, d, properties);
    }

    private boolean processBorderTopPattern(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrDotPattern(BrailleCSSProperty.BorderPattern.class, BrailleCSSProperty.BorderPattern.dot_pattern, d, properties, values);
    }

    private boolean processBorderTopStyle(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdent(BrailleCSSProperty.BorderStyle.class, d, properties);
    }

    private boolean processBorderTopWidth(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.BorderWidth.class, BrailleCSSProperty.BorderWidth.integer, true, d, properties, values);
    }

    private boolean processBorderWidth(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        BorderWidthRepeater r = new BorderWidthRepeater();
        return r.repeatOverFourTermDeclaration(d, properties, values);
    }

    private boolean processBrailleCharset(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdent(BrailleCSSProperty.BrailleCharset.class, d, properties);
    }

    protected boolean processContent(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() == 1 && this.genericOneIdent(BrailleCSSProperty.Content.class, d, properties)) {
            return true;
        }
        TermList list = tf.createList();
        for (Term t : d.asList()) {
            if (t instanceof TermString) {
                list.add((Object)t);
                continue;
            }
            if (t instanceof TermFunction) {
                String funcName = ((TermFunction)t).getFunctionName();
                if (validContentFuncNames.contains(funcName.toLowerCase()) || customContentFuncName.matcher(funcName).matches()) {
                    list.add((Object)t);
                    continue;
                }
                return false;
            }
            return false;
        }
        if (list.isEmpty()) {
            return false;
        }
        properties.put("content", BrailleCSSProperty.Content.content_list);
        values.put("content", (Term<?>)list);
        return true;
    }

    private boolean processDisplay(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        String prop;
        if (d.size() != 1) {
            return false;
        }
        Term t = (Term)d.get(0);
        if (this.genericTermIdent(BrailleCSSProperty.Display.class, t, false, prop = d.getProperty(), properties)) {
            return true;
        }
        if (t instanceof TermIdent && customDisplayIdent.matcher((CharSequence)((TermIdent)t).getValue()).matches()) {
            properties.put(prop, BrailleCSSProperty.Display.custom);
            values.put(prop, t);
            return true;
        }
        return false;
    }

    private boolean processFlow(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrIdentifier(BrailleCSSProperty.Flow.class, BrailleCSSProperty.Flow.identifier, true, d, properties, values);
    }

    private boolean processHyphenateCharacter(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        String prop;
        if (d.size() != 1) {
            return false;
        }
        Term term = (Term)d.get(0);
        if (this.genericTermIdent(BrailleCSSProperty.HyphenateCharacter.class, term, false, prop = d.getProperty(), properties)) {
            return true;
        }
        if (TermString.class.isInstance(term)) {
            properties.put(prop, BrailleCSSProperty.HyphenateCharacter.braille_string);
            values.put(prop, term);
            return true;
        }
        return false;
    }

    private boolean processHyphens(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdent(BrailleCSSProperty.Hyphens.class, d, properties);
    }

    private boolean processLeft(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.AbsoluteMargin.class, BrailleCSSProperty.AbsoluteMargin.integer, true, d, properties, values);
    }

    private boolean processLetterSpacing(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (this.genericOneIdentOrInteger(BrailleCSSProperty.LetterSpacing.class, BrailleCSSProperty.LetterSpacing.length, true, d, properties, values)) {
            return true;
        }
        log.warn("{} not supported, illegal number", (Object)d);
        return false;
    }

    private boolean processLineHeight(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() != 1) {
            return false;
        }
        Term term = (Term)d.get(0);
        return this.genericTermIdent(BrailleCSSProperty.LineHeight.class, term, false, d.getProperty(), properties) || this.genericTerm(TermInteger.class, term, d.getProperty(), BrailleCSSProperty.LineHeight.number, true, properties, values) || this.genericTerm(TermNumber.class, term, d.getProperty(), BrailleCSSProperty.LineHeight.number, true, properties, values) || this.genericTerm(TermPercent.class, term, d.getProperty(), BrailleCSSProperty.LineHeight.percentage, true, properties, values);
    }

    private boolean processListStyle(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.processListStyleType(d, properties, values);
    }

    private boolean processListStyleType(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        String propertyName = "list-style-type";
        if (d.size() != 1) {
            return false;
        }
        Term term = (Term)d.get(0);
        if (this.genericTermIdent(BrailleCSSProperty.ListStyleType.class, term, false, propertyName, properties)) {
            return true;
        }
        try {
            if (term instanceof TermIdent) {
                properties.put(propertyName, BrailleCSSProperty.ListStyleType.counter_style_name);
                values.put(propertyName, term);
                return true;
            }
            if (TermString.class.isInstance(term)) {
                properties.put(propertyName, BrailleCSSProperty.ListStyleType.braille_string);
                values.put(propertyName, term);
                return true;
            }
            if (TermFunction.class.isInstance(term) && "symbols".equals(((TermFunction)term).getFunctionName().toLowerCase())) {
                properties.put(propertyName, BrailleCSSProperty.ListStyleType.symbols_fn);
                values.put(propertyName, term);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean processMarginBottom(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.Margin.class, BrailleCSSProperty.Margin.integer, true, d, properties, values);
    }

    private boolean processMarginLeft(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.Margin.class, BrailleCSSProperty.Margin.integer, false, d, properties, values);
    }

    private boolean processMarginRight(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.Margin.class, BrailleCSSProperty.Margin.integer, false, d, properties, values);
    }

    private boolean processMarginTop(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.Margin.class, BrailleCSSProperty.Margin.integer, true, d, properties, values);
    }

    private boolean processMargin(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        MarginRepeater r = new MarginRepeater();
        return r.repeatOverFourTermDeclaration(d, properties, values);
    }

    private boolean processMaxHeight(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.MaxHeight.class, BrailleCSSProperty.MaxHeight.integer, false, d, properties, values);
    }

    private boolean processMaxLength(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.MaxLength.class, BrailleCSSProperty.MaxLength.integer, false, d, properties, values);
    }

    private boolean processMinLength(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.MinLength.class, BrailleCSSProperty.MinLength.integer, false, d, properties, values);
    }

    private boolean processPaddingBottom(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.Padding.class, BrailleCSSProperty.Padding.integer, true, d, properties, values);
    }

    private boolean processPaddingLeft(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.Padding.class, BrailleCSSProperty.Padding.integer, true, d, properties, values);
    }

    private boolean processPaddingRight(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.Padding.class, BrailleCSSProperty.Padding.integer, true, d, properties, values);
    }

    private boolean processPaddingTop(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.Padding.class, BrailleCSSProperty.Padding.integer, true, d, properties, values);
    }

    private boolean processPadding(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        PaddingRepeater r = new PaddingRepeater();
        return r.repeatOverFourTermDeclaration(d, properties, values);
    }

    private boolean processPage(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrIdentifier(BrailleCSSProperty.Page.class, BrailleCSSProperty.Page.identifier, true, d, properties, values);
    }

    private boolean processRenderTableBy(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() == 1 && this.genericOneIdent(BrailleCSSProperty.RenderTableBy.class, d, properties)) {
            return true;
        }
        TermList list = tf.createList();
        for (Term t : d.asList()) {
            if (t instanceof TermIdent) {
                list.add((Object)t);
                continue;
            }
            return false;
        }
        if (list.isEmpty()) {
            return false;
        }
        properties.put("render-table-by", BrailleCSSProperty.RenderTableBy.axes);
        values.put("render-table-by", (Term<?>)list);
        return true;
    }

    private boolean processRight(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.AbsoluteMargin.class, BrailleCSSProperty.AbsoluteMargin.integer, true, d, properties, values);
    }

    private boolean processSize(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() == 1 && this.genericOneIdent(BrailleCSSProperty.StringSet.class, d, properties)) {
            return true;
        }
        TermInteger width = null;
        TermInteger height = null;
        for (Term t : d.asList()) {
            if (height != null || !(t instanceof TermInteger)) {
                return false;
            }
            if (width == null) {
                width = (TermInteger)t;
                continue;
            }
            height = (TermInteger)t;
        }
        if (height == null) {
            return false;
        }
        TermList size = tf.createList(2);
        size.add(width);
        size.add(height);
        properties.put("size", BrailleCSSProperty.Size.integer_pair);
        values.put("size", (Term<?>)size);
        return true;
    }

    protected boolean processStringSet(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() == 1 && this.genericOneIdent(BrailleCSSProperty.StringSet.class, d, properties)) {
            return true;
        }
        HashSet<String> validFuncNames = new HashSet<String>(Arrays.asList("content", "attr"));
        TermList list = tf.createList();
        TermList contentList = tf.createList();
        String stringName = null;
        boolean first = true;
        for (Term t : d.asList()) {
            if (stringName == null) {
                if (t instanceof TermIdent) {
                    stringName = (String)((TermIdent)t).getValue();
                    continue;
                }
                return false;
            }
            if (t instanceof TermIdent) {
                if (contentList.isEmpty()) {
                    return false;
                }
                TermPair pair = tf.createPair((Object)stringName, (Object)contentList);
                if (!first) {
                    pair.setOperator(Term.Operator.COMMA);
                }
                list.add((Object)pair);
                stringName = (String)((TermIdent)t).getValue();
                contentList = tf.createList();
                first = false;
                continue;
            }
            if (t instanceof TermString) {
                contentList.add((Object)t);
                continue;
            }
            if (t instanceof TermFunction && validFuncNames.contains(((TermFunction)t).getFunctionName().toLowerCase())) {
                contentList.add((Object)t);
                continue;
            }
            return false;
        }
        if (contentList.isEmpty()) {
            return false;
        }
        TermPair pair = tf.createPair(stringName, (Object)contentList);
        if (!first) {
            pair.setOperator(Term.Operator.COMMA);
        }
        list.add((Object)pair);
        properties.put("string-set", BrailleCSSProperty.StringSet.list_values);
        values.put("string-set", (Term<?>)list);
        return true;
    }

    private boolean processTableHeaderPolicy(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdent(BrailleCSSProperty.TableHeaderPolicy.class, d, properties);
    }

    private boolean processTextIndent(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdentOrInteger(BrailleCSSProperty.TextIndent.class, BrailleCSSProperty.TextIndent.integer, false, d, properties, values);
    }

    protected boolean processTextTransform(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() == 1 && this.genericOneIdent(BrailleCSSProperty.TextTransform.class, d, properties)) {
            return true;
        }
        TermList list = tf.createList();
        for (Term t : d.asList()) {
            if (t instanceof TermIdent) {
                String value = ((String)((TermIdent)t).getValue()).toLowerCase();
                if (value.equals("auto")) continue;
                list.add((Object)t);
                continue;
            }
            return false;
        }
        if (list.isEmpty()) {
            return false;
        }
        properties.put("text-transform", BrailleCSSProperty.TextTransform.list_values);
        values.put("text-transform", (Term<?>)list);
        return true;
    }

    private boolean processVolumeBreakAfter(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdent(BrailleCSSProperty.VolumeBreak.class, d, properties);
    }

    private boolean processVolumeBreakBefore(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdent(BrailleCSSProperty.VolumeBreak.class, d, properties);
    }

    private boolean processVolumeBreakInside(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        TermFunction fun;
        Term term;
        if (this.genericOneIdent(BrailleCSSProperty.VolumeBreakInside.class, d, properties)) {
            return true;
        }
        if (d.size() == 1 && (term = (Term)d.get(0)) instanceof TermFunction && "-obfl-keep".equals((fun = (TermFunction)term).getFunctionName()) && fun.size() == 1 && fun.get(0) instanceof TermInteger) {
            properties.put("volume-break-inside", BrailleCSSProperty.VolumeBreakInside.obfl_keep);
            values.put("volume-break-inside", (Term<?>)fun);
            return true;
        }
        return false;
    }

    private boolean processWhiteSpace(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        return this.genericOneIdent(BrailleCSSProperty.WhiteSpace.class, d, properties);
    }

    private boolean processWordSpacing(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (this.genericOneIdentOrInteger(BrailleCSSProperty.WordSpacing.class, BrailleCSSProperty.WordSpacing.length, true, d, properties, values)) {
            return true;
        }
        log.warn("{} not supported, illegal number", (Object)d);
        return false;
    }

    private <T extends CSSProperty> boolean genericOneIdentOrDotPattern(Class<T> type, T dotPatternIdentification, Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() != 1) {
            return false;
        }
        Term term = (Term)d.get(0);
        if (this.genericTermIdent(type, term, false, d.getProperty(), properties)) {
            return true;
        }
        try {
            if (TermIdent.class.isInstance(term)) {
                String propertyName = d.getProperty();
                TermDotPattern value = TermDotPattern.createDotPattern((TermIdent)term);
                properties.put(propertyName, dotPatternIdentification);
                values.put(propertyName, (Term<?>)value);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private <T extends CSSProperty> boolean genericOneIdentOrIdentifier(Class<T> type, T identifierIdentification, boolean sanify, Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        if (d.size() != 1) {
            return false;
        }
        return this.genericTermIdent(type, (Term)d.get(0), false, d.getProperty(), properties) || this.genericTerm(TermIdent.class, (Term)d.get(0), d.getProperty(), identifierIdentification, sanify, properties, values);
    }

    private final void assignDefault(String propertyName, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        Term dv;
        CSSProperty dp = this.css.getDefaultProperty(propertyName);
        if (dp != null) {
            properties.put(propertyName, dp);
        }
        if ((dv = this.css.getDefaultValue(propertyName)) != null) {
            values.put(propertyName, dv);
        }
    }

    private final class BorderSideVariator
    extends Variator {
        public static final int ALIGN = 0;
        public static final int STYLE = 1;
        public static final int WIDTH = 2;
        private final String borderPatternName;

        public BorderSideVariator(String side) {
            super(3, BrailleCSSDeclarationTransformer.this.css);
            this.names.add("border-" + side + "-align");
            this.types.add(BrailleCSSProperty.BorderAlign.class);
            this.names.add("border-" + side + "-style");
            this.types.add(BrailleCSSProperty.BorderStyle.class);
            this.names.add("border-" + side + "-width");
            this.types.add(BrailleCSSProperty.BorderWidth.class);
            this.borderPatternName = "border-" + side + "-pattern";
        }

        public void assignDefaults(Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
            super.assignDefaults(properties, values);
            BrailleCSSDeclarationTransformer.this.assignDefault(this.borderPatternName, properties, values);
        }

        protected boolean variant(int variant, Variator.IntegerRef iteration, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
            int i = iteration.get();
            switch (variant) {
                case 2: {
                    return BrailleCSSDeclarationTransformer.this.genericTermIdent((Class)this.types.get(variant), (Term)this.terms.get(i), true, (String)this.names.get(variant), properties) || BrailleCSSDeclarationTransformer.this.genericTerm(TermInteger.class, (Term)this.terms.get(i), (String)this.names.get(variant), BrailleCSSProperty.BorderWidth.integer, false, properties, values);
                }
                case 0: 
                case 1: {
                    return BrailleCSSDeclarationTransformer.this.genericTermIdent((Class)this.types.get(variant), (Term)this.terms.get(i), true, (String)this.names.get(variant), properties);
                }
            }
            return false;
        }

        private boolean patternVariant(Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
            if (this.terms.size() != 1) {
                return false;
            }
            Term t = (Term)this.terms.get(0);
            if (BrailleCSSDeclarationTransformer.this.genericTermIdent(BrailleCSSProperty.BorderPattern.class, t, false, this.borderPatternName, properties)) {
                return true;
            }
            try {
                if (TermIdent.class.isInstance(t)) {
                    TermDotPattern value = TermDotPattern.createDotPattern((TermIdent)t);
                    properties.put(this.borderPatternName, BrailleCSSProperty.BorderPattern.dot_pattern);
                    values.put(this.borderPatternName, (Term<?>)value);
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        public boolean vary(Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
            boolean rv = false;
            if (super.vary(properties, values)) {
                rv = true;
            }
            if (this.patternVariant(properties, values)) {
                rv = true;
            }
            return rv;
        }
    }

    private final class BorderVariator
    extends Variator {
        public static final int WIDTH = 0;
        public static final int STYLE = 1;
        public static final int ALIGN = 2;
        private List<Repeater> repeaters;

        public BorderVariator() {
            super(3, BrailleCSSDeclarationTransformer.this.css);
            this.types.add(BrailleCSSProperty.BorderWidth.class);
            this.types.add(BrailleCSSProperty.BorderStyle.class);
            this.types.add(BrailleCSSProperty.BorderAlign.class);
            this.repeaters = new ArrayList<Repeater>(this.variants);
            this.repeaters.add(new BorderWidthRepeater());
            this.repeaters.add(new BorderStyleRepeater());
            this.repeaters.add(new BorderAlignRepeater());
        }

        protected boolean variant(int variant, Variator.IntegerRef iteration, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
            int i = iteration.get();
            Term term = (Term)this.terms.get(i);
            switch (variant) {
                case 0: 
                case 1: 
                case 2: {
                    Repeater r = this.repeaters.get(variant);
                    r.assignTerms(new Term[]{term, term, term, term});
                    return r.repeat(properties, values);
                }
            }
            return false;
        }

        protected boolean checkInherit(int variant, Term<?> term, Map<String, CSSProperty> properties) {
            if (!(term instanceof TermIdent) || !"INHERIT".equalsIgnoreCase((String)((TermIdent)term).getValue())) {
                return false;
            }
            if (variant == -1) {
                for (int i = 0; i < this.variants; ++i) {
                    Repeater r = this.repeaters.get(i);
                    r.assignTerms(new Term[]{term, term, term, term});
                    r.repeat(properties, null);
                }
                return true;
            }
            Repeater r = this.repeaters.get(variant);
            r.assignTerms(new Term[]{term, term, term, term});
            r.repeat(properties, null);
            return true;
        }

        public void assignDefaults(Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
            for (Repeater r : this.repeaters) {
                r.assignDefaults(properties, values);
            }
        }
    }

    private final class BorderWidthRepeater
    extends Repeater {
        public BorderWidthRepeater() {
            super(4, BrailleCSSDeclarationTransformer.this.css);
            this.type = BrailleCSSProperty.BorderWidth.class;
            this.names.add("border-top-width");
            this.names.add("border-right-width");
            this.names.add("border-bottom-width");
            this.names.add("border-left-width");
        }

        protected boolean operation(int i, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
            return BrailleCSSDeclarationTransformer.this.genericTermIdent(this.type, (Term)this.terms.get(i), false, (String)this.names.get(i), properties) || BrailleCSSDeclarationTransformer.this.genericTerm(TermInteger.class, (Term)this.terms.get(i), (String)this.names.get(i), BrailleCSSProperty.BorderWidth.integer, false, properties, values);
        }
    }

    private final class BorderAlignRepeater
    extends Repeater {
        public BorderAlignRepeater() {
            super(4, BrailleCSSDeclarationTransformer.this.css);
            this.type = BrailleCSSProperty.BorderAlign.class;
            this.names.add("border-top-align");
            this.names.add("border-right-align");
            this.names.add("border-bottom-align");
            this.names.add("border-left-align");
        }

        protected boolean operation(int i, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
            return BrailleCSSDeclarationTransformer.this.genericTermIdent(BrailleCSSProperty.BorderAlign.class, (Term)this.terms.get(i), false, (String)this.names.get(i), properties);
        }
    }

    private final class BorderStyleRepeater
    extends Repeater {
        public BorderStyleRepeater() {
            super(4, BrailleCSSDeclarationTransformer.this.css);
            this.type = BrailleCSSProperty.BorderStyle.class;
            this.names.add("border-top-style");
            this.names.add("border-right-style");
            this.names.add("border-bottom-style");
            this.names.add("border-left-style");
        }

        protected boolean operation(int i, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
            return BrailleCSSDeclarationTransformer.this.genericTermIdent(BrailleCSSProperty.BorderStyle.class, (Term)this.terms.get(i), false, (String)this.names.get(i), properties);
        }
    }

    private final class PaddingRepeater
    extends Repeater {
        public PaddingRepeater() {
            super(4, BrailleCSSDeclarationTransformer.this.css);
            this.type = BrailleCSSProperty.Padding.class;
            this.names.add("padding-top");
            this.names.add("padding-right");
            this.names.add("padding-bottom");
            this.names.add("padding-left");
        }

        protected boolean operation(int i, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
            return BrailleCSSDeclarationTransformer.this.genericTermIdent(this.type, (Term)this.terms.get(i), true, (String)this.names.get(i), properties) || BrailleCSSDeclarationTransformer.this.genericTerm(TermInteger.class, (Term)this.terms.get(i), (String)this.names.get(i), BrailleCSSProperty.Padding.integer, false, properties, values);
        }
    }

    private final class MarginRepeater
    extends Repeater {
        public MarginRepeater() {
            super(4, BrailleCSSDeclarationTransformer.this.css);
            this.type = BrailleCSSProperty.Margin.class;
            this.names.add("margin-top");
            this.names.add("margin-right");
            this.names.add("margin-bottom");
            this.names.add("margin-left");
        }

        protected boolean operation(int i, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
            return BrailleCSSDeclarationTransformer.this.genericTermIdent(this.type, (Term)this.terms.get(i), true, (String)this.names.get(i), properties) || BrailleCSSDeclarationTransformer.this.genericTerm(TermInteger.class, (Term)this.terms.get(i), (String)this.names.get(i), BrailleCSSProperty.Margin.integer, false, properties, values);
        }
    }
}

