/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.braille.css;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.MediaQueryList;
import cz.vutbr.web.css.RuleList;
import cz.vutbr.web.css.RuleMedia;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.csskit.antlr.CSSInputStream;
import cz.vutbr.web.csskit.antlr.CSSParserFactory;
import cz.vutbr.web.csskit.antlr.CSSSource;
import cz.vutbr.web.csskit.antlr.CSSSourceReader;
import cz.vutbr.web.csskit.antlr.TreeUtil;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.daisy.braille.css.BrailleCSSLexer;
import org.daisy.braille.css.BrailleCSSParser;
import org.daisy.braille.css.BrailleCSSRuleFactory;
import org.daisy.braille.css.BrailleCSSTreeParser;
import org.daisy.braille.css.Preparator;
import org.fit.net.DataURLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrailleCSSParserFactory
extends CSSParserFactory {
    private static final BrailleCSSRuleFactory ruleFactory = new BrailleCSSRuleFactory();
    private static final Logger log = LoggerFactory.getLogger(BrailleCSSParserFactory.class);

    public StyleSheet parse(CSSSource source, CSSSourceReader cssReader, boolean inlinePriority) throws IOException, CSSException {
        StyleSheet sheet = (StyleSheet)ruleFactory.createStyleSheet().unlock();
        Preparator preparator = new Preparator(source.inlineElement, inlinePriority, null);
        StyleSheet ret = this.parseAndImport(source, cssReader, sheet, preparator, null);
        return ret;
    }

    public StyleSheet append(CSSSource source, CSSSourceReader cssReader, boolean inlinePriority, StyleSheet sheet) throws IOException, CSSException {
        Preparator preparator = new Preparator(source.inlineElement, inlinePriority, null);
        StyleSheet ret = this.parseAndImport(source, cssReader, sheet, preparator, null);
        return ret;
    }

    private StyleSheet parseAndImport(CSSSource source, CSSSourceReader cssReader, StyleSheet sheet, Preparator preparator, MediaQueryList media) throws CSSException, IOException {
        BrailleCSSTreeParser parser = BrailleCSSParserFactory.createTreeParser(source, cssReader, preparator);
        BrailleCSSParserFactory.parse(parser, source.type);
        for (int i = 0; i < parser.getImportPaths().size(); ++i) {
            String path = parser.getImportPaths().get(i);
            MediaQueryList imedia = parser.getImportMedia().get(i);
            if (CSSFactory.getAutoImportMedia().matches((List)imedia)) {
                URL url = DataURLHandler.createURL((URL)source.base, (String)path);
                try {
                    if (!cssReader.supportsMediaType(null, url)) continue;
                    this.parseAndImport(new CSSSource(url, source.encoding, (String)null), cssReader, sheet, preparator, imedia);
                }
                catch (IOException e) {
                    log.warn("Couldn't read imported style sheet: {}", (Object)e.getMessage(), (Object)e);
                }
                continue;
            }
            log.trace("Skipping import {} (media not matching)", (Object)path);
        }
        RuleList rules = parser.getRules();
        if (media != null) {
            RuleMedia rm = CSSFactory.getRuleFactory().createMedia();
            rm.setMediaQueries(media);
            log.debug("Wrapping rules {} into RuleMedia: {}", (Object)rules, (Object)rm);
            rm.unlock();
            rm.replaceAll((List)rules);
        }
        return BrailleCSSParserFactory.addRulesToStyleSheet((RuleList)rules, (StyleSheet)sheet);
    }

    public MediaQueryList parseMediaQuery(String query) {
        try {
            CSSInputStream input = CSSInputStream.newInstance((String)query, (URL)new URL("file://media/query/url"));
            CommonTokenStream tokens = BrailleCSSParserFactory.feedLexer(input);
            BrailleCSSParser parser = new BrailleCSSParser((TokenStream)tokens);
            parser.init();
            CommonTree ast = (CommonTree)parser.media().getTree();
            BrailleCSSTreeParser tparser = BrailleCSSParserFactory.feedAST(tokens, ast, null, null);
            return tparser.media();
        }
        catch (IOException e) {
            log.error("I/O error during media query parsing: {}", (Object)e.getMessage());
            return null;
        }
        catch (CSSException e) {
            log.warn("Malformed media query {}", (Object)query);
            return null;
        }
        catch (RecognitionException e) {
            log.warn("Malformed media query {}", (Object)query);
            return null;
        }
    }

    public List<CombinedSelector> parseSelector(String selector, Map<String, String> namespaces) {
        try {
            CSSInputStream input = CSSInputStream.newInstance((String)selector, null);
            CommonTokenStream tokens = BrailleCSSParserFactory.feedLexer(input);
            BrailleCSSParser parser = new BrailleCSSParser((TokenStream)tokens);
            parser.init();
            CommonTree ast = (CommonTree)parser.combined_selector_list().getTree();
            BrailleCSSTreeParser tparser = BrailleCSSParserFactory.feedAST(tokens, ast, null, namespaces);
            return tparser.combined_selector_list();
        }
        catch (IOException e) {
            log.error("I/O error during selector parsing: {}", (Object)e.getMessage());
            return null;
        }
        catch (CSSException e) {
            log.warn("Malformed selector {}", (Object)selector);
            return null;
        }
        catch (RecognitionException e) {
            log.warn("Malformed selector {}", (Object)selector);
            return null;
        }
    }

    public RuleList parseInlineStyle(String style, Context context) {
        try {
            CSSInputStream input = CSSInputStream.newInstance((String)style, null);
            CommonTokenStream tokens = BrailleCSSParserFactory.feedLexer(input);
            CommonTree ast = BrailleCSSParserFactory.feedParser(tokens, CSSSource.SourceType.INLINE, context);
            Preparator preparator = new Preparator(null, true, context);
            BrailleCSSTreeParser tparser = BrailleCSSParserFactory.feedAST(tokens, ast, preparator, null);
            return tparser.inlinestyle();
        }
        catch (IOException e) {
            log.error("I/O error during inline style parsing: {}", (Object)e.getMessage());
            return null;
        }
        catch (CSSException e) {
            log.warn("Malformed inline style {}", (Object)style);
            return null;
        }
        catch (RecognitionException e) {
            log.warn("Malformed inline style {}", (Object)style);
            return null;
        }
    }

    public RuleList parseInlineStyle(String style) {
        return this.parseInlineStyle(style, Context.ELEMENT);
    }

    public RuleList parseInlinePageStyle(String style) {
        return this.parseInlineStyle(style, Context.PAGE);
    }

    public RuleList parseInlineVolumeStyle(String style) {
        return this.parseInlineStyle(style, Context.VOLUME);
    }

    public RuleList parseInlineVendorAtRuleStyle(String style) {
        return this.parseInlineStyle(style, Context.VENDOR_RULE);
    }

    public List<Declaration> parseSimpleInlineStyle(String style) {
        try {
            CSSInputStream input = CSSInputStream.newInstance((String)style, null);
            CommonTokenStream tokens = BrailleCSSParserFactory.feedLexer(input);
            BrailleCSSParser parser = new BrailleCSSParser((TokenStream)tokens);
            parser.init();
            CommonTree ast = (CommonTree)parser.simple_inlinestyle().getTree();
            BrailleCSSTreeParser tparser = BrailleCSSParserFactory.feedAST(tokens, ast, null, null);
            return tparser.simple_inlinestyle();
        }
        catch (IOException e) {
            log.error("I/O error during inline style parsing: {}", (Object)e.getMessage());
            return null;
        }
        catch (CSSException e) {
            log.warn("Malformed inline style {}", (Object)style);
            return null;
        }
        catch (RecognitionException e) {
            log.warn("Malformed inline style {}", (Object)style);
            return null;
        }
    }

    public Declaration parseDeclaration(String declaration) {
        try {
            CSSInputStream input = CSSInputStream.newInstance((String)declaration, null);
            CommonTokenStream tokens = BrailleCSSParserFactory.feedLexer(input);
            BrailleCSSParser parser = new BrailleCSSParser((TokenStream)tokens);
            parser.init();
            CommonTree ast = (CommonTree)parser.declaration().getTree();
            BrailleCSSTreeParser tparser = BrailleCSSParserFactory.feedAST(tokens, ast, null, null);
            return tparser.declaration();
        }
        catch (IOException e) {
            log.error("I/O error during declaration parsing: {}", (Object)e.getMessage());
            return null;
        }
        catch (CSSException e) {
            log.warn("Malformed declaration {}", (Object)declaration);
            return null;
        }
        catch (RecognitionException e) {
            log.warn("Malformed declaration {}", (Object)declaration);
            return null;
        }
    }

    private static BrailleCSSTreeParser createTreeParser(CSSSource source, CSSSourceReader cssReader, Preparator preparator) throws IOException, CSSException {
        CSSInputStream input = BrailleCSSParserFactory.getInput((CSSSource)source, (CSSSourceReader)cssReader);
        CommonTokenStream tokens = BrailleCSSParserFactory.feedLexer(input);
        CommonTree ast = BrailleCSSParserFactory.feedParser(tokens, source.type, Context.ELEMENT);
        return BrailleCSSParserFactory.feedAST(tokens, ast, preparator, null);
    }

    private static CommonTokenStream feedLexer(CSSInputStream source) throws CSSException {
        try {
            BrailleCSSLexer lexer = new BrailleCSSLexer((CharStream)source);
            lexer.init();
            return new CommonTokenStream((TokenSource)lexer);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof CSSException) {
                throw (CSSException)re.getCause();
            }
            log.error("LEXER THROWS:", (Throwable)re);
            throw re;
        }
    }

    private static CommonTree feedParser(CommonTokenStream source, CSSSource.SourceType type, Context context) throws CSSException {
        BrailleCSSParser parser = new BrailleCSSParser((TokenStream)source);
        parser.init();
        return BrailleCSSParserFactory.getAST(parser, type, context);
    }

    private static BrailleCSSTreeParser feedAST(CommonTokenStream source, CommonTree ast, Preparator preparator, Map<String, String> namespaces) {
        if (log.isTraceEnabled()) {
            log.trace("Feeding tree parser with AST:\n{}", (Object)TreeUtil.toStringTree((CommonTree)ast));
        }
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)ast);
        nodes.setTokenStream((TokenStream)source);
        BrailleCSSTreeParser parser = new BrailleCSSTreeParser((TreeNodeStream)nodes);
        parser.init(preparator, ruleFactory, namespaces);
        return parser;
    }

    private static CommonTree getAST(BrailleCSSParser parser, CSSSource.SourceType type, Context context) throws CSSException {
        switch (type) {
            case INLINE: {
                try {
                    switch (context) {
                        case ELEMENT: 
                        case TEXT_TRANSFORM: 
                        case COUNTER_STYLE: {
                            return (CommonTree)parser.inlinestyle().getTree();
                        }
                        case PAGE: {
                            return (CommonTree)parser.inline_pagestyle().getTree();
                        }
                        case VOLUME: {
                            return (CommonTree)parser.inline_volumestyle().getTree();
                        }
                        case HYPHENATION_RESOURCE: {
                            return (CommonTree)parser.inline_hyphenation_resourcestyle().getTree();
                        }
                        case VENDOR_RULE: {
                            return (CommonTree)parser.inline_vendor_atrulestyle().getTree();
                        }
                    }
                }
                catch (RecognitionException re) {
                    throw BrailleCSSParserFactory.encapsulateException((Throwable)re, (String)"Unable to parse inline CSS style");
                }
                catch (RuntimeException re) {
                    throw BrailleCSSParserFactory.encapsulateException((Throwable)re, (String)"Unable to parse inline CSS style");
                }
            }
            case EMBEDDED: {
                try {
                    return (CommonTree)parser.stylesheet().getTree();
                }
                catch (RecognitionException re) {
                    throw BrailleCSSParserFactory.encapsulateException((Throwable)re, (String)"Unable to parse embedded CSS style");
                }
                catch (RuntimeException re) {
                    throw BrailleCSSParserFactory.encapsulateException((Throwable)re, (String)"Unable to parse embedded CSS style");
                }
            }
            case URL: {
                try {
                    return (CommonTree)parser.stylesheet().getTree();
                }
                catch (RecognitionException re) {
                    throw BrailleCSSParserFactory.encapsulateException((Throwable)re, (String)"Unable to parse URL CSS style");
                }
                catch (RuntimeException re) {
                    throw BrailleCSSParserFactory.encapsulateException((Throwable)re, (String)"Unable to parse URL CSS style");
                }
            }
        }
        throw new RuntimeException("Coding error");
    }

    private static RuleList parse(BrailleCSSTreeParser parser, CSSSource.SourceType type) throws CSSException {
        switch (type) {
            case INLINE: {
                try {
                    return parser.inlinestyle();
                }
                catch (RecognitionException re) {
                    throw BrailleCSSParserFactory.encapsulateException((Throwable)re, (String)"Unable to parse inline CSS style [AST]");
                }
                catch (RuntimeException re) {
                    throw BrailleCSSParserFactory.encapsulateException((Throwable)re, (String)"Unable to parse inline CSS style [AST]");
                }
            }
            case EMBEDDED: {
                try {
                    return parser.stylesheet();
                }
                catch (RecognitionException re) {
                    throw BrailleCSSParserFactory.encapsulateException((Throwable)re, (String)"Unable to parse embedded CSS style [AST]");
                }
                catch (RuntimeException re) {
                    throw BrailleCSSParserFactory.encapsulateException((Throwable)re, (String)"Unable to parse embedded CSS style [AST]");
                }
            }
            case URL: {
                try {
                    return parser.stylesheet();
                }
                catch (RecognitionException re) {
                    throw BrailleCSSParserFactory.encapsulateException((Throwable)re, (String)"Unable to parse file CSS style [AST]");
                }
                catch (RuntimeException re) {
                    throw BrailleCSSParserFactory.encapsulateException((Throwable)re, (String)"Unable to parse file CSS style [AST]");
                }
            }
        }
        throw new RuntimeException("Coding error");
    }

    public static enum Context {
        ELEMENT,
        PAGE,
        VOLUME,
        TEXT_TRANSFORM,
        HYPHENATION_RESOURCE,
        COUNTER_STYLE,
        VENDOR_RULE;

    }
}

