/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.braille.css;

import com.google.common.collect.ForwardingList;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.Rule;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.RuleMargin;
import cz.vutbr.web.css.RulePage;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.csskit.AbstractRuleBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.daisy.braille.css.AnyAtRule;
import org.daisy.braille.css.BrailleCSSParserFactory;
import org.daisy.braille.css.BrailleCSSRuleFactory;
import org.daisy.braille.css.RuleCounterStyle;
import org.daisy.braille.css.RuleHyphenationResource;
import org.daisy.braille.css.RuleTextTransform;
import org.daisy.braille.css.RuleVolume;
import org.daisy.braille.css.RuleVolumeArea;

public class InlineStyle
implements Cloneable,
Iterable<RuleBlock<?>> {
    private static final BrailleCSSParserFactory parserFactory = new BrailleCSSParserFactory();
    private static final Selector.SelectorPart dummyElementSelectorPart;
    private static final RuleMainBlock emptyBlock;
    private Optional<RuleMainBlock> mainStyle;
    private List<RuleBlock<?>> nestedStyles = new ArrayList();

    public InlineStyle(String style) {
        this(style, BrailleCSSParserFactory.Context.ELEMENT);
    }

    public InlineStyle(String style, BrailleCSSParserFactory.Context context) {
        ArrayList mainDeclarations = new ArrayList();
        for (RuleBlock block : parserFactory.parseInlineStyle(style, context)) {
            if (block == null) continue;
            if (block instanceof RuleSet) {
                RuleSet set = (RuleSet)block;
                List selectors = set.getSelectors();
                InlineStyle.assertThat(selectors.size() == 1);
                CombinedSelector combinedSelector = (CombinedSelector)selectors.get(0);
                Selector selector = (Selector)combinedSelector.get(0);
                InlineStyle.assertThat(selector.size() >= 1);
                InlineStyle.assertThat(dummyElementSelectorPart.equals(selector.get(0)));
                if (selector.size() == 1 && combinedSelector.size() == 1) {
                    mainDeclarations.addAll(set);
                    continue;
                }
                ArrayList<Selector> relativeSelector = new ArrayList<Selector>();
                selector.remove(0);
                if (selector.size() > 0) {
                    relativeSelector.add(selector);
                }
                relativeSelector.addAll(combinedSelector.subList(1, combinedSelector.size()));
                this.nestedStyles.add((RuleBlock<?>)new RuleRelativeBlock(relativeSelector, (List<Declaration>)set));
                continue;
            }
            if (block instanceof RuleTextTransform || block instanceof RuleHyphenationResource || block instanceof RuleCounterStyle || block instanceof RulePage || block instanceof RuleVolume || block instanceof RuleMargin || block instanceof RuleVolumeArea || block instanceof RuleRelativeBlock || block instanceof RuleRelativePage || block instanceof RuleRelativeVolume || block instanceof RuleRelativeHyphenationResource || block instanceof AnyAtRule) {
                this.nestedStyles.add(block);
                continue;
            }
            throw new RuntimeException("coding error");
        }
        this.mainStyle = new Optional((Object)new RuleMainBlock(mainDeclarations));
    }

    public RuleMainBlock getMainStyle() {
        if (((Optional)this.mainStyle).isPresent()) {
            return (RuleMainBlock)((Object)((Optional)this.mainStyle).get());
        }
        return emptyBlock;
    }

    @Override
    public Iterator<RuleBlock<?>> iterator() {
        final Iterator mainStyleItr = InlineStyle.filterNonEmpty(this.mainStyle.listIterator());
        final Iterator<RuleBlock<?>> nestedStylesItr = InlineStyle.filterNonEmpty(this.nestedStyles.listIterator());
        return new Iterator<RuleBlock<?>>(){
            int cursor = 0;

            @Override
            public boolean hasNext() {
                switch (this.cursor) {
                    case 0: {
                        if (!mainStyleItr.hasNext()) break;
                        return true;
                    }
                }
                return nestedStylesItr.hasNext();
            }

            @Override
            public RuleBlock<?> next() {
                switch (this.cursor) {
                    case 0: {
                        if (mainStyleItr.hasNext()) {
                            return (RuleBlock)mainStyleItr.next();
                        }
                        ++this.cursor;
                    }
                }
                return (RuleBlock)nestedStylesItr.next();
            }

            @Override
            public void remove() {
                switch (this.cursor) {
                    case 0: {
                        mainStyleItr.remove();
                        break;
                    }
                    default: {
                        nestedStylesItr.remove();
                    }
                }
            }
        };
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public Object clone() {
        InlineStyle clone;
        try {
            clone = (InlineStyle)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("coding error");
        }
        if (((Optional)this.mainStyle).isPresent()) {
            clone.mainStyle = new Optional(((Optional)this.mainStyle).get());
        }
        clone.nestedStyles = new ArrayList();
        for (RuleBlock<?> b : this.nestedStyles) {
            clone.nestedStyles.add((RuleBlock)b.clone());
        }
        return clone;
    }

    public static <C extends Collection<?>> Iterator<C> filterNonEmpty(final ListIterator<? extends C> input) {
        return new Iterator<C>(){

            @Override
            public boolean hasNext() {
                boolean hasNext = false;
                int lookahead = 0;
                while (input.hasNext()) {
                    Collection next = (Collection)input.next();
                    ++lookahead;
                    if (next.isEmpty()) continue;
                    hasNext = true;
                    break;
                }
                while (lookahead > 0) {
                    input.previous();
                    --lookahead;
                }
                return hasNext;
            }

            @Override
            public C next() {
                Collection next;
                while ((next = (Collection)input.next()).isEmpty()) {
                }
                return next;
            }

            @Override
            public void remove() {
                input.remove();
            }
        };
    }

    private static void assertThat(boolean test) {
        if (!test) {
            throw new RuntimeException("Coding error");
        }
    }

    static {
        BrailleCSSRuleFactory ruleFactory = new BrailleCSSRuleFactory();
        dummyElementSelectorPart = ruleFactory.createElementDOM(null, true);
        emptyBlock = new RuleMainBlock();
    }

    private static class Optional<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = 1L;

        private Optional(T object) {
            this.add(object);
        }

        private boolean isPresent() {
            return !this.isEmpty();
        }

        private T get() {
            return (T)this.get(0);
        }
    }

    public static class RuleRelativeHyphenationResource
    extends ForwardingRuleBlock<Declaration>
    implements RuleBlock<Declaration> {
        private final RuleHyphenationResource hyphenationResource;

        public RuleRelativeHyphenationResource(RuleHyphenationResource hyphenationResource) {
            super(hyphenationResource);
            this.hyphenationResource = hyphenationResource;
        }

        public RuleHyphenationResource asRuleHyphenationResource() {
            return this.hyphenationResource;
        }

        public RuleRelativeHyphenationResource clone() {
            return new RuleRelativeHyphenationResource((RuleHyphenationResource)((Object)this.delegate.clone()));
        }
    }

    public static class RuleRelativeVolume
    extends ForwardingRuleBlock<Rule<?>>
    implements RuleBlock<Rule<?>> {
        private final RuleVolume volume;

        public RuleRelativeVolume(RuleVolume volume) {
            super(volume);
            if (volume.getPseudo() == null) {
                throw new RuntimeException();
            }
            this.volume = volume;
        }

        public RuleVolume asRuleVolume() {
            return this.volume;
        }

        public RuleRelativeVolume clone() {
            return new RuleRelativeVolume((RuleVolume)((Object)this.delegate.clone()));
        }
    }

    public static class RuleRelativePage
    extends ForwardingRuleBlock<Rule<?>>
    implements RuleBlock<Rule<?>> {
        private final RulePage page;

        public RuleRelativePage(RulePage page) {
            super(page);
            if (page.getName() != null || page.getPseudo() == null) {
                throw new RuntimeException();
            }
            this.page = page;
        }

        public RulePage asRulePage() {
            return this.page;
        }

        public RuleRelativePage clone() {
            return new RuleRelativePage((RulePage)this.delegate.clone());
        }
    }

    private static abstract class ForwardingRuleBlock<E>
    extends ForwardingList<E> {
        final RuleBlock<E> delegate;

        ForwardingRuleBlock(RuleBlock<E> delegate) {
            this.delegate = delegate;
        }

        public List<E> delegate() {
            return this.delegate;
        }

        public StyleSheet getStyleSheet() {
            return this.delegate.getStyleSheet();
        }

        public void setStyleSheet(StyleSheet sheet) {
            this.delegate.setStyleSheet(sheet);
        }

        public List<E> asList() {
            return this.delegate.asList();
        }

        public Rule<E> replaceAll(List<E> replacement) {
            return this.delegate.replaceAll(replacement);
        }

        public Rule<E> unlock() {
            return this.delegate.unlock();
        }
    }

    public static class RuleRelativeBlock
    extends AbstractRuleBlock<Rule<?>> {
        private final List<Selector> selector;

        public RuleRelativeBlock(List<Selector> selector) {
            this.selector = selector;
        }

        public RuleRelativeBlock(List<Selector> selector, List<Declaration> declarations) {
            this(selector);
            this.unlock();
            this.addAll(declarations);
        }

        public boolean add(Rule<?> r) {
            if (!(r instanceof Declaration) && !(r instanceof RulePage)) {
                throw new IllegalArgumentException("Element must be either a Declaration or a RulePage, but got " + r);
            }
            return super.add(r);
        }

        public List<Selector> getSelector() {
            return this.selector;
        }
    }

    public static class RuleMainBlock
    extends AbstractRuleBlock<Declaration> {
        private RuleMainBlock() {
        }

        private RuleMainBlock(List<Declaration> declarations) {
            this();
            this.replaceAll(declarations);
        }
    }
}

