/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.braille.css;

import java.util.IllformedLocaleException;
import java.util.Locale;
import org.daisy.braille.css.LanguageRange;

public class LanguageTag
implements LanguageRange {
    private final Locale language;

    public LanguageTag(String identifier) throws IllegalArgumentException {
        try {
            this.language = new Locale.Builder().setLanguageTag(identifier.replace('_', '-')).build();
        }
        catch (IllformedLocaleException e) {
            throw new IllegalArgumentException("Language tag '" + identifier + "' could not be parsed", e);
        }
    }

    public String toString() {
        return this.language.toLanguageTag();
    }

    public String toString(int depth) {
        return this.toString();
    }

    @Override
    public boolean matches(Locale language) {
        String thisTag = this.language.toLanguageTag().toLowerCase();
        String otherTag = language.toLanguageTag().toLowerCase();
        return otherTag.equals(thisTag) || otherTag.startsWith(thisTag + "-");
    }
}

