/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.braille.css;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.Term;
import java.util.HashMap;
import org.daisy.braille.css.BrailleCSSDeclarationTransformer;
import org.daisy.braille.css.BrailleCSSParserFactory;
import org.daisy.braille.css.SupportedBrailleCSS;

public class PropertyValue
implements Cloneable {
    private CSSProperty property;
    private Term<?> value;
    private static BrailleCSSDeclarationTransformer transformerInstance = new BrailleCSSDeclarationTransformer(new SupportedBrailleCSS(true, false));
    private static final BrailleCSSParserFactory parserFactoryInstance = new BrailleCSSParserFactory();

    PropertyValue(CSSProperty property, Term<?> value) {
        this.property = property;
        this.value = value;
    }

    public CSSProperty getProperty() {
        return this.property;
    }

    public Term<?> getValue() {
        return this.value;
    }

    public Object clone() {
        PropertyValue clone;
        try {
            clone = (PropertyValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("coding error");
        }
        clone.property = this.property;
        if (this.value != null) {
            clone.value = (Term)this.value.clone();
        }
        return clone;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return this.property.toString();
    }

    public static PropertyValue parse(String property, String value) {
        return PropertyValue.parse(parserFactoryInstance.parseDeclaration(property + ":" + value));
    }

    public static PropertyValue parse(Declaration declaration) {
        HashMap<String, CSSProperty> properties = new HashMap<String, CSSProperty>();
        HashMap terms = new HashMap();
        if (!transformerInstance.parseDeclaration(declaration, properties, terms)) {
            return null;
        }
        String property = declaration.getProperty();
        return new PropertyValue((CSSProperty)properties.get(property), (Term)terms.get(property));
    }
}

