/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.braille.css;

import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.RuleMargin;
import cz.vutbr.web.csskit.AbstractRuleBlock;
import cz.vutbr.web.csskit.OutputUtil;
import java.util.List;

public class RuleMarginImpl
extends AbstractRuleBlock<Declaration>
implements RuleMargin {
    private final MarginArea marginArea;

    protected RuleMarginImpl(String area) {
        for (MarginArea a : MarginArea.values()) {
            if (!a.value.equals(area)) continue;
            this.marginArea = a;
            return;
        }
        throw new IllegalArgumentException("Illegal value for margin area: " + area);
    }

    public String getMarginArea() {
        return this.marginArea.value;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int depth) {
        StringBuilder sb = new StringBuilder();
        sb = OutputUtil.appendTimes((StringBuilder)sb, (String)"\t", (int)depth);
        sb.append("@").append(this.getMarginArea());
        sb.append(" {\n");
        sb = OutputUtil.appendList((StringBuilder)sb, (List)this.list, (String)"\n", (int)(depth + 1));
        sb.append("}\n");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getMarginArea().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RuleMarginImpl)) {
            return false;
        }
        RuleMarginImpl other = (RuleMarginImpl)((Object)obj);
        return this.getMarginArea().equals(other.getMarginArea());
    }

    private static enum MarginArea {
        TOPLEFT("top-left"),
        TOPCENTER("top-center"),
        TOPRIGHT("top-right"),
        BOTTOMLEFT("bottom-left"),
        BOTTOMCENTER("bottom-center"),
        BOTTOMRIGHT("bottom-right"),
        LEFT("left"),
        RIGHT("right"),
        FOOTNOTES("footnotes");

        public final String value;

        private MarginArea(String value) {
            this.value = value;
        }
    }
}

