/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.braille.css;

import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.PrettyOutput;
import cz.vutbr.web.css.Rule;
import cz.vutbr.web.csskit.AbstractRuleBlock;
import cz.vutbr.web.csskit.OutputUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.daisy.braille.css.RuleVolumeArea;

public class RuleVolume
extends AbstractRuleBlock<Rule<?>>
implements PrettyOutput {
    private static final Set<String> validPseudoIdents = new HashSet<String>(Arrays.asList("first", "last", "only"));
    private static final Set<String> validPseudoFuncNames = new HashSet<String>(Arrays.asList("nth", "nth-last"));
    protected String pseudo = null;

    public RuleVolume(String pseudo, String pseudoFuncArg) {
        this(pseudo, pseudoFuncArg, true);
    }

    RuleVolume(String pseudo, String pseudoFuncArg, boolean allowOnly) {
        this.replaceAll(new ArrayList());
        if (pseudo != null) {
            if (validPseudoIdents.contains(pseudo = pseudo.toLowerCase()) && (allowOnly || !"only".equals(pseudo))) {
                this.pseudo = pseudo;
            } else if (validPseudoFuncNames.contains(pseudo) && pseudoFuncArg != null) {
                this.pseudo = pseudo + "(" + pseudoFuncArg + ")";
            } else {
                throw new IllegalArgumentException("@volume" + (pseudo != null ? ":" + pseudo + (pseudoFuncArg != null ? "(" + pseudoFuncArg + ")" : "") : "") + " not allowed");
            }
        }
    }

    public String getPseudo() {
        return this.pseudo;
    }

    public boolean add(Rule<?> element) {
        if (element instanceof Declaration || element instanceof RuleVolumeArea) {
            return super.add(element);
        }
        throw new IllegalArgumentException("Rule must be either a Declaration or a RuleVolumeArea");
    }

    public String toString(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append("@volume");
        if (this.pseudo != null) {
            sb.append(":").append(this.pseudo);
        }
        sb.append(" ");
        sb.append(" {\n");
        List rules = this.list;
        sb = OutputUtil.appendList((StringBuilder)sb, (List)rules, (String)"", (int)(depth + 1));
        sb.append("}\n");
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }
}

