/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.braille.css;

import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.MatchCondition;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.csskit.CombinedSelectorImpl;
import cz.vutbr.web.csskit.OutputUtil;
import cz.vutbr.web.csskit.SelectorImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectorImpl
extends cz.vutbr.web.csskit.SelectorImpl {
    private static final Logger log = LoggerFactory.getLogger(SelectorImpl.class);

    public boolean add(Selector selector) throws UnsupportedOperationException {
        Selector.SelectorPart lastPart;
        if (this.size() > 0 && (lastPart = (Selector.SelectorPart)this.get(this.size() - 1)) instanceof Selector.PseudoElement) {
            if (!(lastPart instanceof PseudoElementImpl)) {
                throw new RuntimeException();
            }
            if (((PseudoElementImpl)lastPart).containsCustomPseudoClass()) {
                ((PseudoElementImpl)lastPart).add(selector);
                return true;
            }
        }
        throw new UnsupportedOperationException("Selectors should be combined with CombinedSelector");
    }

    public boolean add(Selector.SelectorPart part) {
        Selector.SelectorPart lastPart;
        if (part instanceof Selector.PseudoElement) {
            Selector.SelectorPart lastPart2;
            if (!(part instanceof PseudoElementImpl)) {
                throw new RuntimeException();
            }
            if (this.size() > 0 && (lastPart2 = (Selector.SelectorPart)this.get(this.size() - 1)) instanceof Selector.PseudoElement) {
                if (!(lastPart2 instanceof PseudoElementImpl)) {
                    throw new RuntimeException();
                }
                return ((PseudoElementImpl)lastPart2).add((PseudoElementImpl)part);
            }
        } else if (part instanceof Selector.PseudoClass && this.size() > 0 && (lastPart = (Selector.SelectorPart)this.get(this.size() - 1)) instanceof Selector.PseudoElement) {
            if (!(lastPart instanceof PseudoElementImpl)) {
                throw new RuntimeException();
            }
            return ((PseudoElementImpl)lastPart).add((Selector.PseudoClass)part);
        }
        return super.add((Object)part);
    }

    public static class PseudoElementImpl
    implements Selector.PseudoElement {
        private static final HashMap<String, PseudoElementDef> PSEUDO_ELEMENT_DEFS = new HashMap();
        private final String name;
        private final List<String> args;
        private final List<Selector.PseudoClass> pseudoClasses = new ArrayList<Selector.PseudoClass>();
        private final List<Selector> combinedSelectors = new ArrayList<Selector>();
        private PseudoElementImpl stackedPseudoElement = null;
        private boolean specifiedAsClass = false;

        public PseudoElementImpl(String name, String ... args) {
            if (name.startsWith(":")) {
                if ((name = name.substring(1)).startsWith(":")) {
                    name = name.substring(1);
                } else {
                    this.specifiedAsClass = true;
                }
            }
            this.name = name = name.toLowerCase();
            this.args = new ArrayList<String>();
            if ("top-of-page".equals(name) || name.startsWith("-")) {
                for (String a : args) {
                    this.args.add(a);
                }
            } else {
                if (!PSEUDO_ELEMENT_DEFS.containsKey(name)) {
                    throw new IllegalArgumentException(name + " is not a valid pseudo-element name");
                }
                PseudoElementDef def = PSEUDO_ELEMENT_DEFS.get(name);
                if (args.length > 0 && def.maxArgs == 0) {
                    throw new IllegalArgumentException(name + " must not be a function");
                }
                if (args.length == 0 && def.minArgs > 0) {
                    throw new IllegalArgumentException(name + " must be a function");
                }
                if (args.length < def.minArgs || args.length > def.maxArgs) {
                    throw new IllegalArgumentException(name + " requires " + def.minArgs + (def.maxArgs > def.minArgs ? ".." + def.maxArgs : "") + " " + (def.minArgs == 1 && def.maxArgs == 1 ? "argument" : "arguments"));
                }
                if (this.specifiedAsClass) {
                    this.specifiedAsClass = false;
                    log.warn("Use a double colon for pseudo element ::" + name);
                }
                switch (def) {
                    case ALTERNATE: {
                        if (args.length == 0) break;
                        Integer i = null;
                        String a = args[0];
                        try {
                            i = Integer.parseInt(a);
                            if (i > 1) {
                                this.args.add(a);
                            } else if (i < 1) {
                                i = null;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (i == null) {
                            throw new IllegalArgumentException("Argument of ::alternate must be a number greater than zero, but got " + a);
                        }
                        break;
                    }
                    default: {
                        for (String a : args) {
                            this.args.add(a);
                        }
                        break;
                    }
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String[] getArguments() {
            return this.args.toArray(new String[this.args.size()]);
        }

        public void computeSpecificity(CombinedSelector.Specificity spec) {
            spec.add(CombinedSelector.Specificity.Level.D);
        }

        public boolean matches(Element e, MatchCondition cond) {
            return true;
        }

        private boolean add(Selector.PseudoClass pseudoClass) {
            if (!this.combinedSelectors.isEmpty()) {
                throw new RuntimeException();
            }
            if (this.stackedPseudoElement != null) {
                return this.stackedPseudoElement.add(pseudoClass);
            }
            return this.pseudoClasses.add(pseudoClass);
        }

        private boolean add(PseudoElementImpl pseudoElement) {
            if (!this.combinedSelectors.isEmpty()) {
                throw new RuntimeException();
            }
            if (this.stackedPseudoElement != null) {
                return this.stackedPseudoElement.add(pseudoElement);
            }
            this.stackedPseudoElement = pseudoElement;
            return true;
        }

        private boolean add(Selector selector) {
            if (this.stackedPseudoElement != null) {
                return this.stackedPseudoElement.add(selector);
            }
            if (selector.getCombinator() == null) {
                throw new RuntimeException();
            }
            return this.combinedSelectors.add(selector);
        }

        public List<Selector.PseudoClass> getPseudoClasses() {
            return this.pseudoClasses;
        }

        public List<Selector> getCombinedSelectors() {
            return this.combinedSelectors;
        }

        public boolean hasStackedPseudoElement() {
            return this.stackedPseudoElement != null;
        }

        public PseudoElementImpl getStackedPseudoElement() {
            return this.stackedPseudoElement;
        }

        public boolean isSpecifiedAsClass() {
            return this.specifiedAsClass;
        }

        private boolean containsCustomPseudoClass() {
            if (this.specifiedAsClass) {
                return true;
            }
            if (this.stackedPseudoElement != null) {
                return this.stackedPseudoElement.containsCustomPseudoClass();
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(":");
            if (!this.specifiedAsClass) {
                sb.append(":");
            }
            sb.append(this.name);
            if (this.args.size() > 0) {
                sb.append("(");
                OutputUtil.appendList((StringBuilder)sb, this.args, (String)", ");
                sb.append(")");
            }
            if (!this.combinedSelectors.isEmpty()) {
                sb = OutputUtil.appendList((StringBuilder)sb, this.combinedSelectors, (String)"");
            } else {
                if (!this.pseudoClasses.isEmpty()) {
                    for (Selector.PseudoClass p : this.pseudoClasses) {
                        sb.append(p);
                    }
                }
                if (this.stackedPseudoElement != null) {
                    sb.append(this.stackedPseudoElement);
                }
            }
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.args.hashCode();
            result = 31 * result + this.pseudoClasses.hashCode();
            result = 31 * result + (this.stackedPseudoElement == null ? 0 : this.stackedPseudoElement.hashCode());
            result = 31 * result + (this.combinedSelectors == null ? 0 : this.combinedSelectors.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PseudoElementImpl other = (PseudoElementImpl)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            if (!this.args.equals(other.args)) {
                return false;
            }
            if (!this.pseudoClasses.equals(other.pseudoClasses)) {
                return false;
            }
            if (this.stackedPseudoElement == null) {
                if (other.stackedPseudoElement != null) {
                    return false;
                }
                if (this.combinedSelectors == null) {
                    if (other.combinedSelectors != null) {
                        return false;
                    }
                    if (!this.combinedSelectors.equals(other.combinedSelectors)) {
                        return false;
                    }
                }
            } else if (!this.stackedPseudoElement.equals(other.stackedPseudoElement)) {
                return false;
            }
            return true;
        }

        static {
            for (PseudoElementDef d : PseudoElementDef.values()) {
                PSEUDO_ELEMENT_DEFS.put(d.name, d);
            }
        }

        private static enum PseudoElementDef {
            BEFORE("before"),
            AFTER("after"),
            MARKER("marker"),
            DUPLICATE("duplicate"),
            ALTERNATE("alternate", 0, 1),
            LIST_ITEM("list-item"),
            LIST_HEADER("list-header"),
            TABLE_BY("table-by", 1),
            FOOTNOTE_CALL("footnote-call");

            private final String name;
            private final int minArgs;
            private final int maxArgs;

            private PseudoElementDef(String name) {
                this.name = name;
                this.minArgs = 0;
                this.maxArgs = 0;
            }

            private PseudoElementDef(String name, int args) {
                this(name, args, args);
            }

            private PseudoElementDef(String name, int minArgs, int maxArgs) {
                this.name = name;
                this.minArgs = minArgs;
                this.maxArgs = maxArgs;
            }
        }
    }

    public static class RelationalPseudoClassImpl
    implements Selector.PseudoClass {
        private final List<CombinedSelector> relativeSelector;

        public RelationalPseudoClassImpl(List<CombinedSelector> relativeSelector) {
            if (relativeSelector.size() < 1) {
                throw new RuntimeException(":has() must not be empty");
            }
            this.relativeSelector = relativeSelector;
        }

        public boolean matches(Element e, MatchCondition cond) {
            for (CombinedSelector s : this.relativeSelector) {
                if (!RelationalPseudoClassImpl.matchesRelative((List<Selector>)s, e, cond)) continue;
                return true;
            }
            return false;
        }

        public static boolean matchesRelative(List<Selector> selector, Element e, MatchCondition cond) {
            Iterator<Selector> it = selector.iterator();
            Selector first = it.next();
            Selector.Combinator combinator = first.getCombinator();
            ArrayList<Selector> rest = null;
            if (it.hasNext()) {
                rest = new ArrayList<Selector>();
                while (it.hasNext()) {
                    rest.add(it.next());
                }
            }
            switch (combinator) {
                case CHILD: 
                case DESCENDANT: {
                    Node child;
                    int i;
                    NodeList children = e.getChildNodes();
                    for (i = 0; i < children.getLength(); ++i) {
                        child = children.item(i);
                        if (!(child instanceof Element) || !first.matches((Element)child, cond) || rest != null && !RelationalPseudoClassImpl.matchesRelative(rest, (Element)child, cond)) continue;
                        return true;
                    }
                    if (combinator != Selector.Combinator.DESCENDANT) break;
                    for (i = 0; i < children.getLength(); ++i) {
                        child = children.item(i);
                        if (!(child instanceof Element) || !RelationalPseudoClassImpl.matchesRelative(selector, (Element)child, cond)) continue;
                        return true;
                    }
                    break;
                }
                case ADJACENT: 
                case PRECEDING: {
                    Node next;
                    for (next = e.getNextSibling(); next != null && !(next instanceof Element); next = next.getNextSibling()) {
                    }
                    if (next == null) break;
                    if (first.matches((Element)next, cond) && (rest == null || RelationalPseudoClassImpl.matchesRelative(rest, (Element)next, cond))) {
                        return true;
                    }
                    if (combinator != Selector.Combinator.PRECEDING || !RelationalPseudoClassImpl.matchesRelative(selector, (Element)next, cond)) break;
                    return true;
                }
            }
            return false;
        }

        public void computeSpecificity(CombinedSelector.Specificity specificity) {
            CombinedSelector mostSpecificSelector = null;
            CombinedSelectorImpl.SpecificityImpl highestSpecificity = null;
            for (CombinedSelector sel : this.relativeSelector) {
                CombinedSelectorImpl.SpecificityImpl spec = new CombinedSelectorImpl.SpecificityImpl();
                for (Selector s : sel) {
                    s.computeSpecificity((CombinedSelector.Specificity)spec);
                }
                if (highestSpecificity != null && spec.compareTo(highestSpecificity) <= 0) continue;
                mostSpecificSelector = sel;
                highestSpecificity = spec;
            }
            for (Selector s : mostSpecificSelector) {
                s.computeSpecificity(specificity);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(":has(");
            OutputUtil.appendList((StringBuilder)sb, this.relativeSelector, (String)", ");
            sb.append(")");
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            return 31 + this.relativeSelector.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RelationalPseudoClassImpl other = (RelationalPseudoClassImpl)obj;
            return this.relativeSelector.equals(other.relativeSelector);
        }
    }

    public static class NegationPseudoClassImpl
    implements Selector.PseudoClass {
        private final List<Selector> negatedSelector;

        public NegationPseudoClassImpl(List<Selector> negatedSelector) {
            if (negatedSelector.size() < 1) {
                throw new RuntimeException(":not() must not be empty");
            }
            this.negatedSelector = negatedSelector;
        }

        public boolean matches(Element e, MatchCondition cond) {
            for (Selector s : this.negatedSelector) {
                if (!s.matches(e, cond)) continue;
                return false;
            }
            return true;
        }

        public void computeSpecificity(CombinedSelector.Specificity specificity) {
            Selector mostSpecificSelector = null;
            CombinedSelectorImpl.SpecificityImpl highestSpecificity = null;
            for (Selector sel : this.negatedSelector) {
                CombinedSelectorImpl.SpecificityImpl spec = new CombinedSelectorImpl.SpecificityImpl();
                sel.computeSpecificity((CombinedSelector.Specificity)spec);
                if (highestSpecificity != null && spec.compareTo(highestSpecificity) <= 0) continue;
                mostSpecificSelector = sel;
                highestSpecificity = spec;
            }
            mostSpecificSelector.computeSpecificity(specificity);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(":not(");
            OutputUtil.appendList((StringBuilder)sb, this.negatedSelector, (String)", ");
            sb.append(")");
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            return 31 + this.negatedSelector.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NegationPseudoClassImpl other = (NegationPseudoClassImpl)obj;
            return this.negatedSelector.equals(other.negatedSelector);
        }
    }

    public static class PseudoClassImpl
    extends SelectorImpl.PseudoClassImpl {
        private final String name;
        private final String[] args;

        public PseudoClassImpl(String name, String ... args) {
            super(name, args);
            this.name = name;
            this.args = args;
        }

        public boolean matchesPosition(int position, int elementCount) {
            if (this.name.equals("first-child")) {
                return position == 1;
            }
            if (this.name.equals("last-child")) {
                return position == elementCount;
            }
            if (this.name.equals("only-child")) {
                return position == 1 && elementCount == 1;
            }
            if (this.name.equals("nth-child")) {
                return this.positionMatches(position, PseudoClassImpl.decodeIndex((String)this.args[0]));
            }
            if (this.name.equals("nth-last-child")) {
                return this.positionMatches(elementCount - position + 1, PseudoClassImpl.decodeIndex((String)this.args[0]));
            }
            log.warn("Don't know how to match " + this.toString() + " pseudo-class");
            return false;
        }
    }
}

