/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.braille.css;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.daisy.braille.css.BrailleCSSProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportedBrailleCSS
implements SupportedCSS {
    private static Logger log = LoggerFactory.getLogger(SupportedBrailleCSS.class);
    private static final int TOTAL_SUPPORTED_DECLARATIONS = 70;
    private static final TermFactory tf = CSSFactory.getTermFactory();
    private static final CSSProperty DEFAULT_UA_TEXT_ALIGN = CSSProperty.TextAlign.LEFT;
    private static final Term<?> DEFAULT_UA_TEXT_IDENT = tf.createInteger(Integer.valueOf(0));
    private static final Term<?> DEFAULT_UA_MARGIN = tf.createInteger(Integer.valueOf(0));
    private static final Term<?> DEFAULT_UA_PADDING = tf.createInteger(Integer.valueOf(0));
    private static final Term<?> DEFAULT_UA_BORDER_WIDTH = tf.createInteger(Integer.valueOf(1));
    private static final Term<?> DEFAULT_UA_ORPHANS = tf.createInteger(Integer.valueOf(2));
    private static final Term<?> DEFAULT_UA_WIDOWS = tf.createInteger(Integer.valueOf(2));
    private static final Term<?> DEFAULT_UA_LINE_HEIGHT = tf.createInteger(Integer.valueOf(1));
    private static final Term<?> DEFAULT_UA_LETTER_SPACING = tf.createInteger(Integer.valueOf(1));
    private static final Term<?> DEFAULT_UA_WORD_SPACING = tf.createInteger(Integer.valueOf(1));
    private Set<String> supportedCSSproperties;
    private Map<String, CSSProperty> defaultCSSproperties;
    private Map<String, Term<?>> defaultCSSvalues;
    private Map<String, Integer> ordinals;
    private Map<Integer, String> ordinalsRev;

    public SupportedBrailleCSS() {
        this(false, true);
    }

    public SupportedBrailleCSS(boolean allowComponentProperties, boolean allowShorthandProperties) {
        this.setSupportedCSS(allowComponentProperties, allowShorthandProperties);
        this.setOridinals();
    }

    public boolean isSupportedMedia(String media) {
        if (media == null) {
            return false;
        }
        return media.toLowerCase().equals("embossed");
    }

    public final boolean isSupportedCSSProperty(String property) {
        if (this.supportedCSSproperties.contains(property)) {
            return true;
        }
        if (this.defaultCSSproperties.containsKey(property)) {
            log.info("Shorthand or component property not supported: {}");
        }
        return false;
    }

    public final CSSProperty getDefaultProperty(String property) {
        CSSProperty value = this.defaultCSSproperties.get(property);
        log.debug("Asked for property {}'s default value: {}", (Object)property, (Object)value);
        return value;
    }

    public final Term<?> getDefaultValue(String property) {
        return this.defaultCSSvalues.get(property);
    }

    public final int getTotalProperties() {
        return this.defaultCSSproperties.size();
    }

    public final Set<String> getDefinedPropertyNames() {
        return this.defaultCSSproperties.keySet();
    }

    public String getRandomPropertyName() {
        Random generator = new Random();
        int o = generator.nextInt(this.getTotalProperties());
        return this.getPropertyName(o);
    }

    public int getOrdinal(String propertyName) {
        Integer i = this.ordinals.get(propertyName);
        return i == null ? -1 : i;
    }

    public String getPropertyName(int o) {
        return this.ordinalsRev.get(o);
    }

    private void setProperty(String name, CSSProperty defaultProperty) {
        this.setProperty(name, true, defaultProperty, null);
    }

    private void setProperty(String name, boolean allow, CSSProperty defaultProperty) {
        this.setProperty(name, allow, defaultProperty, null);
    }

    private void setProperty(String name, CSSProperty defaultProperty, Term<?> defaultValue) {
        this.setProperty(name, true, defaultProperty, defaultValue);
    }

    private void setProperty(String name, boolean allow, CSSProperty defaultProperty, Term<?> defaultValue) {
        if (allow) {
            this.supportedCSSproperties.add(name);
        }
        if (defaultProperty != null) {
            this.defaultCSSproperties.put(name, defaultProperty);
        }
        if (defaultValue != null) {
            this.defaultCSSvalues.put(name, defaultValue);
        }
    }

    private void setSupportedCSS(boolean allowComponentProperties, boolean allowShorthandProperties) {
        this.supportedCSSproperties = new HashSet<String>(70, 1.0f);
        this.defaultCSSproperties = new HashMap<String, CSSProperty>(70, 1.0f);
        this.defaultCSSvalues = new HashMap(70, 1.0f);
        this.setProperty("text-align", DEFAULT_UA_TEXT_ALIGN);
        this.setProperty("text-indent", BrailleCSSProperty.TextIndent.integer, DEFAULT_UA_TEXT_IDENT);
        this.setProperty("line-height", BrailleCSSProperty.LineHeight.number, DEFAULT_UA_LINE_HEIGHT);
        this.setProperty("left", BrailleCSSProperty.AbsoluteMargin.integer, DEFAULT_UA_MARGIN);
        this.setProperty("right", BrailleCSSProperty.AbsoluteMargin.integer, DEFAULT_UA_MARGIN);
        this.setProperty("margin-top", BrailleCSSProperty.Margin.integer, DEFAULT_UA_MARGIN);
        this.setProperty("margin-right", BrailleCSSProperty.Margin.integer, DEFAULT_UA_MARGIN);
        this.setProperty("margin-bottom", BrailleCSSProperty.Margin.integer, DEFAULT_UA_MARGIN);
        this.setProperty("margin-left", BrailleCSSProperty.Margin.integer, DEFAULT_UA_MARGIN);
        this.setProperty("margin", allowShorthandProperties, BrailleCSSProperty.Margin.component_values);
        this.setProperty("padding-top", BrailleCSSProperty.Padding.integer, DEFAULT_UA_PADDING);
        this.setProperty("padding-right", BrailleCSSProperty.Padding.integer, DEFAULT_UA_PADDING);
        this.setProperty("padding-bottom", BrailleCSSProperty.Padding.integer, DEFAULT_UA_PADDING);
        this.setProperty("padding-left", BrailleCSSProperty.Padding.integer, DEFAULT_UA_PADDING);
        this.setProperty("padding", allowShorthandProperties, BrailleCSSProperty.Padding.component_values);
        this.setProperty("border-top-pattern", allowComponentProperties, BrailleCSSProperty.BorderPattern.NONE);
        this.setProperty("border-right-pattern", allowComponentProperties, BrailleCSSProperty.BorderPattern.NONE);
        this.setProperty("border-bottom-pattern", allowComponentProperties, BrailleCSSProperty.BorderPattern.NONE);
        this.setProperty("border-left-pattern", allowComponentProperties, BrailleCSSProperty.BorderPattern.NONE);
        this.setProperty("border-top-style", allowComponentProperties, BrailleCSSProperty.BorderStyle.NONE);
        this.setProperty("border-right-style", allowComponentProperties, BrailleCSSProperty.BorderStyle.NONE);
        this.setProperty("border-bottom-style", allowComponentProperties, BrailleCSSProperty.BorderStyle.NONE);
        this.setProperty("border-left-style", allowComponentProperties, BrailleCSSProperty.BorderStyle.NONE);
        this.setProperty("border-style", allowShorthandProperties, BrailleCSSProperty.BorderStyle.component_values);
        this.setProperty("border-top-width", allowComponentProperties, BrailleCSSProperty.BorderWidth.integer, DEFAULT_UA_BORDER_WIDTH);
        this.setProperty("border-right-width", allowComponentProperties, BrailleCSSProperty.BorderWidth.integer, DEFAULT_UA_BORDER_WIDTH);
        this.setProperty("border-bottom-width", allowComponentProperties, BrailleCSSProperty.BorderWidth.integer, DEFAULT_UA_BORDER_WIDTH);
        this.setProperty("border-left-width", allowComponentProperties, BrailleCSSProperty.BorderWidth.integer, DEFAULT_UA_BORDER_WIDTH);
        this.setProperty("border-width", allowShorthandProperties, BrailleCSSProperty.BorderWidth.component_values);
        this.setProperty("border-top-align", allowComponentProperties, BrailleCSSProperty.BorderAlign.CENTER);
        this.setProperty("border-right-align", allowComponentProperties, BrailleCSSProperty.BorderAlign.CENTER);
        this.setProperty("border-bottom-align", allowComponentProperties, BrailleCSSProperty.BorderAlign.CENTER);
        this.setProperty("border-left-align", allowComponentProperties, BrailleCSSProperty.BorderAlign.CENTER);
        this.setProperty("border-align", allowShorthandProperties, BrailleCSSProperty.BorderAlign.component_values);
        this.setProperty("border-top", allowShorthandProperties, (CSSProperty)CSSProperty.Border.component_values);
        this.setProperty("border-right", allowShorthandProperties, (CSSProperty)CSSProperty.Border.component_values);
        this.setProperty("border-bottom", allowShorthandProperties, (CSSProperty)CSSProperty.Border.component_values);
        this.setProperty("border-left", allowShorthandProperties, (CSSProperty)CSSProperty.Border.component_values);
        this.setProperty("border", allowShorthandProperties, (CSSProperty)CSSProperty.Border.component_values);
        this.setProperty("display", BrailleCSSProperty.Display.INLINE);
        this.setProperty("list-style-type", BrailleCSSProperty.ListStyleType.NONE);
        this.setProperty("list-style", allowShorthandProperties, BrailleCSSProperty.ListStyleType.NONE);
        this.setProperty("size", BrailleCSSProperty.Size.AUTO);
        this.setProperty("page", BrailleCSSProperty.Page.AUTO);
        this.setProperty("page-break-before", (CSSProperty)CSSProperty.PageBreak.AUTO);
        this.setProperty("page-break-after", (CSSProperty)CSSProperty.PageBreak.AUTO);
        this.setProperty("page-break-inside", (CSSProperty)CSSProperty.PageBreakInside.AUTO);
        this.setProperty("orphans", (CSSProperty)CSSProperty.Orphans.integer, DEFAULT_UA_ORPHANS);
        this.setProperty("widows", (CSSProperty)CSSProperty.Widows.integer, DEFAULT_UA_WIDOWS);
        this.setProperty("max-height", BrailleCSSProperty.MaxHeight.NONE);
        this.setProperty("min-length", BrailleCSSProperty.MinLength.AUTO);
        this.setProperty("max-length", BrailleCSSProperty.MaxLength.AUTO);
        this.setProperty("volume-break-before", BrailleCSSProperty.VolumeBreak.AUTO);
        this.setProperty("volume-break-after", BrailleCSSProperty.VolumeBreak.AUTO);
        this.setProperty("volume-break-inside", BrailleCSSProperty.VolumeBreakInside.AUTO);
        this.setProperty("render-table-by", BrailleCSSProperty.RenderTableBy.AUTO);
        this.setProperty("table-header-policy", BrailleCSSProperty.TableHeaderPolicy.ONCE);
        this.setProperty("counter-reset", (CSSProperty)CSSProperty.CounterReset.NONE);
        this.setProperty("counter-set", (CSSProperty)CSSProperty.CounterSet.NONE);
        this.setProperty("counter-increment", (CSSProperty)CSSProperty.CounterIncrement.NONE);
        this.setProperty("string-set", BrailleCSSProperty.StringSet.NONE);
        this.setProperty("content", BrailleCSSProperty.Content.NONE);
        this.setProperty("text-transform", BrailleCSSProperty.TextTransform.AUTO);
        this.setProperty("braille-charset", BrailleCSSProperty.BrailleCharset.UNICODE);
        this.setProperty("white-space", BrailleCSSProperty.WhiteSpace.NORMAL);
        this.setProperty("hyphenate-character", BrailleCSSProperty.HyphenateCharacter.AUTO);
        this.setProperty("hyphens", BrailleCSSProperty.Hyphens.MANUAL);
        this.setProperty("letter-spacing", BrailleCSSProperty.LetterSpacing.length, DEFAULT_UA_LETTER_SPACING);
        this.setProperty("word-spacing", BrailleCSSProperty.WordSpacing.length, DEFAULT_UA_WORD_SPACING);
        this.setProperty("flow", BrailleCSSProperty.Flow.NORMAL);
    }

    private void setOridinals() {
        HashMap<String, Integer> ords = new HashMap<String, Integer>(this.getTotalProperties(), 1.0f);
        HashMap<Integer, String> ordsRev = new HashMap<Integer, String>(this.getTotalProperties(), 1.0f);
        int i = 0;
        for (String key : this.defaultCSSproperties.keySet()) {
            ords.put(key, i);
            ordsRev.put(i, key);
            ++i;
        }
        this.ordinals = ords;
        this.ordinalsRev = ordsRev;
    }
}

