/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.drivers;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.piperack.PiperackApplication;
import com.xmlcalabash.util.ParseArgs;
import com.xmlcalabash.util.UserArgs;
import net.sf.saxon.s9api.SaxonApiException;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.data.Protocol;

public class Piperack {
    public static void main(String[] args) throws Exception {
        UserArgs userArgs = null;
        try {
            userArgs = new ParseArgs().parsePiperack(args);
        }
        catch (XProcException xe) {
            System.err.println(xe.getMessage());
            System.exit(-1);
        }
        XProcConfiguration config = null;
        XProcRuntime runtime = null;
        try {
            config = userArgs.createConfiguration();
            runtime = new XProcRuntime(config);
        }
        catch (SaxonApiException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        if (userArgs.isShowVersion()) {
            System.out.println("Piperack, a web server for running XProc pipelines.");
            XProcConfiguration.showVersion(runtime);
        }
        Component component = new Component();
        component.getServers().add(Protocol.HTTP, config.piperackPort);
        PiperackApplication application = new PiperackApplication(config, runtime);
        component.getDefaultHost().attach((Restlet)application);
        component.start();
        while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (application.stopped()) {
                System.exit(0);
            }
            application.expirePipelines();
        }
    }
}

