/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import org.apache.http.cookie.Cookie;

@XMLCalabash(name="cx:get-cookies", type="{http://xmlcalabash.com/ns/extensions}get-cookies")
public class GetCookies
extends DefaultStep {
    private static final QName _cookies = new QName("", "cookies");
    private static final QName _domain = new QName("", "domain");
    private static final QName _name = new QName("", "name");
    private static final QName _value = new QName("", "value");
    private static final QName _path = new QName("", "path");
    private static final QName _expires = new QName("", "expires");
    private static final QName _version = new QName("", "version");
    private static final QName _secure = new QName("", "secure");
    private static final QName c_cookies = new QName("c", "http://www.w3.org/ns/xproc-step", "cookies");
    private static final QName c_cookie = new QName("c", "http://www.w3.org/ns/xproc-step", "cookie");
    private static DateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private WritablePipe result = null;

    public GetCookies(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String cookieKey = this.getOption(_cookies).getString();
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(c_cookies);
        tree.startContent();
        for (Cookie cookie : this.runtime.getCookieStore(cookieKey).getCookies()) {
            tree.addStartElement(c_cookie);
            tree.addAttribute(_name, cookie.getName());
            tree.addAttribute(_value, cookie.getValue());
            tree.addAttribute(_domain, cookie.getDomain());
            tree.addAttribute(_path, cookie.getPath());
            Date date = cookie.getExpiryDate();
            if (date != null) {
                String iso = iso8601.format(date);
                iso = iso.substring(0, 22) + ":" + iso.substring(22);
                tree.addAttribute(_expires, iso);
                Date date2 = new Date();
            }
            tree.startContent();
            String comment = cookie.getComment();
            if (comment != null) {
                tree.addText(comment);
            }
            tree.addEndElement();
        }
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

