/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.TreeWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

@XMLCalabash(name="cx:wait-for-update", type="{http://xmlcalabash.com/ns/extensions}wait-for-update")
public class WaitForUpdate
extends DefaultStep {
    private static final QName _href = new QName("", "href");
    private static final QName _pause_before = new QName("", "pause-before");
    private static final QName _pause_after = new QName("", "pause-after");
    private static final long FILESYSTEM_WAIT = 100L;
    private static final long HTTP_WAIT = 1000L;
    private WritablePipe result = null;
    private URI uri = null;
    private long pauseBefore = 0L;
    private long pauseAfter = 0L;

    public WaitForUpdate(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String href = this.getOption(_href).getString();
        URI baseURI = this.getOption(_href).getBaseURI();
        URI uri = baseURI.resolve(href);
        this.pauseBefore = this.getOption(_pause_before, 0L) * 1000L;
        this.pauseAfter = this.getOption(_pause_after, 0L) * 1000L;
        if (this.pauseBefore > 0L) {
            try {
                Thread.sleep(this.pauseBefore);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        String changed = "";
        if ("file".equals(uri.getScheme())) {
            changed = this.waitForFile(uri);
        } else if ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme())) {
            changed = this.waitForHttp(uri);
        } else {
            throw new XProcException("Only http: and file: URIs are supported on cx:wait-for-update");
        }
        if (this.pauseAfter > 0L) {
            try {
                Thread.sleep(this.pauseAfter);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(XProcConstants.c_result);
        tree.startContent();
        tree.addText(changed);
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }

    private String waitForFile(URI uri) {
        long dt;
        File f = new File(uri.getPath());
        boolean newFile = false;
        if (!f.exists()) {
            newFile = true;
            this.logger.debug(MessageFormatter.nodeMessage(this.step.getNode(), "Exist wait: " + f.getAbsolutePath()));
            while (!f.exists()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        long cdt = dt = f.lastModified();
        if (!newFile) {
            this.logger.debug(MessageFormatter.nodeMessage(this.step.getNode(), "Update wait: " + f.getAbsolutePath()));
            while (cdt == dt) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                cdt = f.lastModified();
            }
        }
        Calendar cal = GregorianCalendar.getInstance();
        TimeZone tz = TimeZone.getDefault();
        long gmt = cdt - (long)tz.getRawOffset();
        if (tz.useDaylightTime() && tz.inDaylightTime(cal.getTime())) {
            gmt -= (long)tz.getDSTSavings();
        }
        cal.setTimeInMillis(gmt);
        return String.format("%1$04d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02dZ", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13));
    }

    private String waitForHttp(URI uri) {
        long dt;
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(3, false));
        CloseableHttpClient client = builder.build();
        BasicHttpContext localContext = new BasicHttpContext();
        HttpHead httpRequest = new HttpHead(uri);
        HttpResponse httpResponse = null;
        httpResponse = this.head((HttpClient)client, (HttpUriRequest)httpRequest, (HttpContext)localContext);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        Object date = null;
        boolean newUri = false;
        if (statusCode == 404) {
            newUri = true;
            this.logger.debug(MessageFormatter.nodeMessage(this.step.getNode(), "Exist wait: " + uri.toASCIIString()));
            while (statusCode == 404) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                httpResponse = this.head((HttpClient)client, (HttpUriRequest)httpRequest, (HttpContext)localContext);
                statusCode = httpResponse.getStatusLine().getStatusCode();
            }
        }
        long cdt = dt = this.lastModified(httpResponse);
        if (statusCode == 200 && !newUri) {
            this.logger.debug(MessageFormatter.nodeMessage(this.step.getNode(), "Update wait: " + uri.toASCIIString()));
            while (statusCode == 200 && cdt == dt) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                httpResponse = this.head((HttpClient)client, (HttpUriRequest)httpRequest, (HttpContext)localContext);
                statusCode = httpResponse.getStatusLine().getStatusCode();
                cdt = this.lastModified(httpResponse);
            }
        }
        Calendar cal = GregorianCalendar.getInstance();
        TimeZone tz = TimeZone.getDefault();
        long gmt = cdt - (long)tz.getRawOffset();
        if (tz.useDaylightTime() && tz.inDaylightTime(cal.getTime())) {
            gmt -= (long)tz.getDSTSavings();
        }
        cal.setTimeInMillis(gmt);
        return String.format("%1$04d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02dZ", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13));
    }

    private long lastModified(HttpResponse httpResponse) {
        String date = this.getHeader(httpResponse, "Last-modified", null);
        if (date == null) {
            date = this.getHeader(httpResponse, "Date", null);
        }
        Date dt = DateUtils.parseDate((String)date);
        return dt.getTime();
    }

    private HttpResponse head(HttpClient client, HttpUriRequest httpRequest, HttpContext localContext) {
        try {
            return client.execute(httpRequest, localContext);
        }
        catch (ClientProtocolException cpe) {
            throw new XProcException(cpe);
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
    }

    private String getHeader(HttpResponse resp, String name, String def) {
        Header[] headers = resp.getHeaders(name);
        if (headers == null) {
            return def;
        }
        if (headers == null || headers.length == 0) {
            return def;
        }
        return headers[0].getValue();
    }
}

