/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.functions;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.functions.XProcExtensionFunctionDefinition;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XStep;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.SequenceType;

public class BaseURI
extends XProcExtensionFunctionDefinition {
    private static StructuredQName funcname = new StructuredQName("p", "http://www.w3.org/ns/xproc", "base-uri");

    protected BaseURI() {
    }

    public BaseURI(XProcRuntime runtime) {
        this.registry.registerRuntime((Object)this, runtime);
    }

    public StructuredQName getFunctionQName() {
        return funcname;
    }

    public int getMinimumNumberOfArguments() {
        return 0;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_NODE};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_ATOMIC;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new BaseURICall(this);
    }

    private class BaseURICall
    extends ExtensionFunctionCall {
        private XProcExtensionFunctionDefinition xdef = null;

        public BaseURICall(XProcExtensionFunctionDefinition def) {
            this.xdef = def;
        }

        public Sequence call(XPathContext xPathContext, Sequence[] sequences) throws XPathException {
            String baseURI = null;
            XProcRuntime runtime = BaseURI.this.registry.getRuntime((Object)this.xdef);
            XStep step = runtime.getXProcData().getStep();
            if (step != null && !(step instanceof XCompoundStep)) {
                throw XProcException.dynamicError(23);
            }
            if (sequences.length > 0) {
                NodeInfo item = (NodeInfo)sequences[0].head();
                baseURI = item.getBaseURI();
            } else {
                NodeInfo item = (NodeInfo)xPathContext.getContextItem();
                baseURI = item.getBaseURI();
            }
            if (baseURI == null) {
                return new AnyURIValue((CharSequence)"");
            }
            return new AnyURIValue((CharSequence)baseURI);
        }
    }
}

