/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.functions;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.functions.XProcExtensionFunctionDefinition;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XStep;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.SequenceType;

public class ResolveURI
extends XProcExtensionFunctionDefinition {
    private static StructuredQName funcname = new StructuredQName("p", "http://www.w3.org/ns/xproc", "resolve-uri");

    protected ResolveURI() {
    }

    public ResolveURI(XProcRuntime runtime) {
        this.registry.registerRuntime((Object)this, runtime);
    }

    public StructuredQName getFunctionQName() {
        return funcname;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.OPTIONAL_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_ATOMIC;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ResolveURICall(this);
    }

    private class ResolveURICall
    extends ExtensionFunctionCall {
        private XProcExtensionFunctionDefinition xdef = null;

        public ResolveURICall(XProcExtensionFunctionDefinition def) {
            this.xdef = def;
        }

        public Sequence call(XPathContext xPathContext, Sequence[] sequences) throws XPathException {
            String relativeURI = sequences[0].head().getStringValue();
            XProcRuntime runtime = ResolveURI.this.registry.getRuntime((Object)this.xdef);
            XStep step = runtime.getXProcData().getStep();
            if (step != null && !(step instanceof XCompoundStep)) {
                throw XProcException.dynamicError(23);
            }
            String baseURI = null;
            if (sequences.length > 1) {
                baseURI = sequences[1].head().getStringValue();
            } else {
                baseURI = runtime.getStaticBaseURI().toASCIIString();
                try {
                    Item item = xPathContext.getContextItem();
                    baseURI = ((TinyDocumentImpl)item).getBaseURI();
                }
                catch (Exception item) {
                    // empty catch block
                }
            }
            try {
                URI abs = net.sf.saxon.functions.ResolveURI.makeAbsolute((String)relativeURI, (String)baseURI);
                String resolvedURI = abs.toASCIIString();
                return new AnyURIValue((CharSequence)resolvedURI);
            }
            catch (URISyntaxException use) {
                throw new XProcException(use);
            }
        }
    }
}

