/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.io.DataStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpClientDataStore
implements DataStore {
    private final DataStore fallback;
    private HttpClient client;

    public HttpClientDataStore(HttpClient client, DataStore fallback) {
        this.client = client;
        this.fallback = fallback;
    }

    private synchronized HttpClient getHttpClient() {
        return this.client;
    }

    @Override
    public URI writeEntry(String href, String base, String media, final DataStore.DataWriter handler) throws MalformedURLException, FileNotFoundException, IOException {
        URI baseURI = URI.create(base);
        URI uri = baseURI.resolve(href);
        String sch = uri.getScheme();
        if ("http".equalsIgnoreCase(sch) || "https".equalsIgnoreCase(sch)) {
            BasicHttpContext localContext = new BasicHttpContext();
            HttpPost post = new HttpPost(uri);
            post.setHeader("Content-Type", media);
            post.setEntity((HttpEntity)new AbstractHttpEntity(){

                public void writeTo(OutputStream outstream) throws IOException {
                    handler.store(outstream);
                }

                public boolean isStreaming() {
                    return true;
                }

                public boolean isRepeatable() {
                    return false;
                }

                public long getContentLength() {
                    return -1L;
                }

                public InputStream getContent() throws IOException, IllegalStateException {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    this.writeTo(buf);
                    return new ByteArrayInputStream(buf.toByteArray());
                }
            });
            return this.execute((HttpUriRequest)post, new ResponseHandler<URI>((HttpContext)localContext){
                final /* synthetic */ HttpContext val$localContext;
                {
                    this.val$localContext = httpContext;
                }

                public URI handleResponse(HttpResponse response) throws IOException {
                    URI uri = HttpClientDataStore.this.getContentId(this.val$localContext);
                    Header location = response.getLastHeader("Content-Location");
                    if (location == null) {
                        return uri;
                    }
                    return uri.resolve(location.getValue());
                }
            }, (HttpContext)localContext);
        }
        return this.fallback.writeEntry(href, base, media, handler);
    }

    @Override
    public void readEntry(String href, String base, String accept, String overrideContentType, DataStore.DataReader handler) throws MalformedURLException, FileNotFoundException, IOException {
        URI baseURI = URI.create(base);
        URI uri = baseURI.resolve(href);
        String sch = uri.getScheme();
        if ("http".equalsIgnoreCase(sch) || "https".equalsIgnoreCase(sch)) {
            this.readHttpEntity(uri, accept, overrideContentType, handler);
        } else {
            this.fallback.readEntry(href, base, accept, overrideContentType, handler);
        }
    }

    @Override
    public void infoEntry(String href, String base, String accept, DataStore.DataInfo handler) throws MalformedURLException, FileNotFoundException, IOException {
        URI baseURI = URI.create(base);
        URI uri = baseURI.resolve(href);
        String sch = uri.getScheme();
        if ("http".equalsIgnoreCase(sch) || "https".equalsIgnoreCase(sch)) {
            BasicHttpContext localContext = new BasicHttpContext();
            HttpHead head = new HttpHead(uri);
            head.setHeader("Accept", accept);
            this.execute((HttpUriRequest)head, new ResponseHandler<Void>((HttpContext)localContext, handler){
                final /* synthetic */ HttpContext val$localContext;
                final /* synthetic */ DataStore.DataInfo val$handler;
                {
                    this.val$localContext = httpContext;
                    this.val$handler = dataInfo;
                }

                public Void handleResponse(HttpResponse response) throws IOException {
                    URI contentId = HttpClientDataStore.this.getContentId(this.val$localContext);
                    HttpEntity entity = response.getEntity();
                    try {
                        Header hd = entity.getContentType();
                        String type = null;
                        if (hd != null) {
                            type = hd.getValue();
                        }
                        long lm = HttpClientDataStore.this.getLastModified(response);
                        this.val$handler.list(contentId, type, lm);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException(e);
                    }
                    return null;
                }
            }, (HttpContext)localContext);
        } else {
            this.fallback.infoEntry(href, base, accept, handler);
        }
    }

    @Override
    public void listEachEntry(String href, String base, String accept, DataStore.DataInfo handler) throws MalformedURLException, FileNotFoundException, IOException {
        this.fallback.listEachEntry(href, base, accept, handler);
    }

    @Override
    public URI createList(String href, String base) throws MalformedURLException, FileNotFoundException, IOException {
        return this.fallback.createList(href, base);
    }

    @Override
    public void deleteEntry(String href, String base) throws MalformedURLException, FileNotFoundException, IOException {
        URI baseURI = URI.create(base);
        URI uri = baseURI.resolve(href);
        String sch = uri.getScheme();
        if ("http".equalsIgnoreCase(sch) || "https".equalsIgnoreCase(sch)) {
            BasicHttpContext localContext = new BasicHttpContext();
            this.execute((HttpUriRequest)new HttpDelete(uri), new ResponseHandler<Void>(){

                public Void handleResponse(HttpResponse response) throws IOException {
                    return null;
                }
            }, (HttpContext)localContext);
        } else {
            this.fallback.deleteEntry(href, base);
        }
    }

    private long getLastModified(HttpResponse response) {
        Header last = response.getLastHeader("Last-Modified");
        if (last == null) {
            return -1L;
        }
        return DateUtils.parseDate((String)last.getValue()).getTime();
    }

    private void readHttpEntity(URI uri, String accept, String overrideContentType, DataStore.DataReader handler) throws IOException, ClientProtocolException, Error {
        BasicHttpContext localContext = new BasicHttpContext();
        HttpGet get = new HttpGet(uri);
        get.setHeader("Accept", accept);
        this.execute((HttpUriRequest)get, new ResponseHandler<Void>((HttpContext)localContext, overrideContentType, handler){
            final /* synthetic */ HttpContext val$localContext;
            final /* synthetic */ String val$overrideContentType;
            final /* synthetic */ DataStore.DataReader val$handler;
            {
                this.val$localContext = httpContext;
                this.val$overrideContentType = string;
                this.val$handler = dataReader;
            }

            public Void handleResponse(HttpResponse response) throws IOException {
                URI contentId = HttpClientDataStore.this.getContentId(this.val$localContext);
                HttpEntity entity = response.getEntity();
                Header hd = entity.getContentType();
                String type = null;
                if (hd != null) {
                    type = hd.getValue();
                }
                if (this.val$overrideContentType != null) {
                    type = this.val$overrideContentType;
                }
                this.val$handler.load(contentId, type, entity.getContent(), entity.getContentLength());
                return null;
            }
        }, (HttpContext)localContext);
    }

    private <T> T execute(final HttpUriRequest request, final ResponseHandler<? extends T> handler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.getHttpClient().execute(request, new ResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                int respCode = response.getStatusLine().getStatusCode();
                if (respCode == 200 || respCode == 201 || respCode == 203 || respCode == 204 || respCode == 205) {
                    return handler.handleResponse(response);
                }
                throw HttpClientDataStore.this.error(request, respCode);
            }
        }, context);
    }

    IOException error(HttpUriRequest request, int respCode) {
        String uri = request.getURI().toASCIIString();
        if (respCode == 401 || respCode == 402 || respCode == 403) {
            return new IOException("Authentication failure for URL: " + uri);
        }
        if (respCode == 404 || respCode == 405 || respCode == 410) {
            return new FileNotFoundException(uri);
        }
        if (respCode == 406) {
            Header accept = request.getLastHeader("Accept");
            return new IOException("Unsupported media type: " + accept + " for URL: " + uri);
        }
        if (respCode == 415) {
            Header contentType = request.getLastHeader("Content-Type");
            return new IOException("Unsupported content type: " + contentType + " for URL: " + uri);
        }
        return new IOException("Server returned HTTP response code: " + respCode + " for URL: " + uri);
    }

    private URI getContentId(HttpContext localContext) {
        HttpHost host = (HttpHost)localContext.getAttribute("http.target_host");
        HttpUriRequest req = (HttpUriRequest)localContext.getAttribute("http.request");
        try {
            URI root = new URI(host.getSchemeName(), null, host.getHostName(), host.getPort(), "/", null, null);
            return root.resolve(req.getURI());
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }
}

