/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

@XMLCalabash(name="p:count", type="{http://www.w3.org/ns/xproc}count")
public class Count
extends DefaultStep {
    private static final QName c_result = new QName("c", "http://www.w3.org/ns/xproc-step", "result");
    private static final QName _limit = new QName("limit");
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public Count(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String limitStr = this.getOption(_limit).getString();
        int limit = 0;
        try {
            limit = Integer.parseInt(limitStr);
        }
        catch (NumberFormatException nfe) {
            throw XProcException.dynamicError(19, "The limit on p:count must be an integer");
        }
        boolean done = false;
        int count = 0;
        while (!done && this.source.moreDocuments()) {
            XdmNode node = this.source.read();
            done = limit > 0 && ++count == limit;
        }
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(c_result);
        tree.startContent();
        tree.addText("" + count);
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

