/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.DocumentSequenceIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

@XMLCalabash(name="p:split-sequence", type="{http://www.w3.org/ns/xproc}split-sequence")
public class SplitSequence
extends DefaultStep {
    private static final QName _test = new QName("", "test");
    private static final QName _initial_only = new QName("", "initial-only");
    private ReadablePipe source = null;
    private WritablePipe matched = null;
    private WritablePipe notMatched = null;
    private boolean initialOnly = false;

    public SplitSequence(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        if ("matched".equals(port)) {
            this.matched = pipe;
        } else {
            this.notMatched = pipe;
        }
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.matched.resetWriter();
        this.notMatched.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue test = this.getOption(_test);
        this.initialOnly = this.getOption(_initial_only, false);
        boolean stillOk = true;
        int count = 0;
        while (this.source.moreDocuments()) {
            ++count;
            this.source.read();
        }
        this.source.resetReader();
        DocumentSequenceIterator xsi = new DocumentSequenceIterator();
        xsi.setLast(count);
        XPathCompiler xcomp = this.runtime.getProcessor().newXPathCompiler();
        xcomp.setBaseURI(this.step.getNode().getBaseURI());
        for (String prefix : test.getNamespaceBindings().keySet()) {
            xcomp.declareNamespace(prefix, test.getNamespaceBindings().get(prefix));
        }
        XPathExecutable xexec = xcomp.compile(test.getString());
        XPathExpression xexpr = xexec.getUnderlyingExpression();
        int pos = 0;
        while (this.source.moreDocuments()) {
            XdmNode doc = this.source.read();
            ++pos;
            Item item = null;
            try {
                XPathDynamicContext xdc = xexpr.createDynamicContext((Item)doc.getUnderlyingNode());
                XPathContext xc = xdc.getXPathContextObject();
                xsi.setPosition(pos);
                xsi.setItem((Item)doc.getUnderlyingNode());
                xc.setCurrentIterator((FocusIterator)xsi);
                SequenceIterator results = xexpr.iterate(xdc);
                item = results.next();
            }
            catch (XPathException xe) {
                throw new XProcException(xe);
            }
            boolean pass = false;
            pass = item instanceof BooleanValue ? ((BooleanValue)item).getBooleanValue() : item != null;
            boolean bl = stillOk = stillOk && pass;
            if (pass && (!this.initialOnly || stillOk)) {
                this.matched.write(doc);
                continue;
            }
            this.notMatched.write(doc);
        }
    }
}

