/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.XMLtoJSON;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.util.zip.GZIPOutputStream;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;

@XMLCalabash(name="p:store", type="{http://www.w3.org/ns/xproc}store")
public class Store
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _content_type = new QName("content-type");
    private static final QName c_encoding = new QName("c", "http://www.w3.org/ns/xproc-step", "encoding");
    private static final QName c_body = new QName("c", "http://www.w3.org/ns/xproc-step", "body");
    private static final QName c_json = new QName("c", "http://www.w3.org/ns/xproc-step", "json");
    private static final QName cx_decode = new QName("cx", "http://xmlcalabash.com/ns/extensions", "decode");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    protected CompressionMethod method = CompressionMethod.NONE;

    public Store(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        RuntimeValue hrefOpt = this.getOption(_href);
        super.run(": href=" + hrefOpt.getValue().toString());
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        XdmNode doc = this.source.read();
        if (doc == null || this.source.moreDocuments()) {
            throw XProcException.dynamicError(6, "Reading source on " + this.getStep().getName());
        }
        String href = null;
        String base = null;
        if (hrefOpt != null) {
            href = hrefOpt.getString();
            base = hrefOpt.getBaseURI().toASCIIString();
        }
        if (this.method == CompressionMethod.GZIP) {
            this.logger.trace(MessageFormatter.nodeMessage(hrefOpt == null ? null : hrefOpt.getNode(), "Gzipping" + (href == null ? "" : " to \"" + href + "\".")));
        } else {
            this.logger.trace(MessageFormatter.nodeMessage(hrefOpt.getNode(), "Storing to \"" + href + "\"."));
        }
        XdmNode root = S9apiUtils.getDocumentElement(doc);
        String decode = this.step.getExtensionAttribute(cx_decode);
        if (decode == null) {
            decode = root.getAttributeValue(cx_decode);
        }
        String contentType = root.getAttributeValue(_content_type);
        URI contentId = ("true".equals(decode) || "1".equals(decode) || this.method != CompressionMethod.NONE) && ("http://www.w3.org/ns/xproc-step".equals(root.getNodeName().getNamespaceURI()) && "base64".equals(root.getAttributeValue(_encoding)) || "".equals(root.getNodeName().getNamespaceURI()) && "base64".equals(root.getAttributeValue(c_encoding))) ? this.storeBinary(doc, href, base, contentType) : (("true".equals(decode) || "1".equals(decode)) && XProcConstants.c_result.equals((Object)root.getNodeName()) && root.getAttributeValue(_content_type) != null && root.getAttributeValue(_content_type).startsWith("text/") ? this.storeText(doc, href, base, contentType) : (this.runtime.transparentJSON() && (c_body.equals((Object)root.getNodeName()) && ("application/json".equals(contentType) || "text/json".equals(contentType)) || c_json.equals((Object)root.getNodeName()) || "http://www.ibm.com/xmlns/prod/2009/jsonx".equals(root.getNodeName().getNamespaceURI()) || "http://www.xmlsh.org/jxml".equals(root.getNodeName().getNamespaceURI()) || "http://marklogic.com/json".equals(root.getNodeName().getNamespaceURI())) ? this.storeJSON(doc, href, base, contentType) : this.storeXML(doc, href, base, contentType)));
        if (contentId != null) {
            TreeWriter tree = new TreeWriter(this.runtime);
            tree.startDocument(this.step.getNode().getBaseURI());
            tree.addStartElement(XProcConstants.c_result);
            tree.startContent();
            tree.addText(contentId.toASCIIString());
            tree.addEndElement();
            tree.endDocument();
            this.result.write(tree.getResult());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI storeXML(final XdmNode doc, String href, String base, String media) throws SaxonApiException {
        final Serializer serializer = this.makeSerializer();
        if (media == null) {
            media = "application/xml";
        }
        try {
            if (href == null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (OutputStream outstr = baos;){
                    if (this.method == CompressionMethod.GZIP) {
                        GZIPOutputStream gzout = new GZIPOutputStream(outstr);
                        outstr = gzout;
                    }
                    serializer.setOutputStream(outstr);
                    S9apiUtils.serialize(this.runtime, doc, serializer);
                }
                this.returnData(baos);
                return null;
            }
            DataStore store = this.runtime.getDataStore();
            return store.writeEntry(href, base, media, new DataStore.DataWriter(){

                @Override
                public void store(OutputStream outstr) throws IOException {
                    if (Store.this.method == CompressionMethod.GZIP) {
                        GZIPOutputStream gzout = new GZIPOutputStream(outstr);
                        outstr = gzout;
                    }
                    serializer.setOutputStream(outstr);
                    try {
                        S9apiUtils.serialize(Store.this.runtime, doc, serializer);
                    }
                    catch (SaxonApiException e) {
                        throw new IOException(e);
                    }
                }
            });
        }
        catch (FileNotFoundException e) {
            throw XProcException.stepError(50);
        }
        catch (IOException ioe) {
            if (ioe.getCause() instanceof SaxonApiException) {
                throw (SaxonApiException)ioe.getCause();
            }
            throw XProcException.stepError(50, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI storeBinary(XdmNode doc, String href, String base, String media) {
        if (media == null) {
            media = "application/octet-stream";
        }
        try {
            final byte[] decoded = Base64.decode(doc.getStringValue());
            if (href == null) {
                OutputStream outstr = null;
                ByteArrayOutputStream baos = null;
                outstr = baos = new ByteArrayOutputStream();
                try {
                    if (this.method == CompressionMethod.GZIP) {
                        GZIPOutputStream gzout = new GZIPOutputStream(outstr);
                        outstr = gzout;
                    }
                    outstr.write(decoded);
                }
                finally {
                    ((OutputStream)outstr).close();
                }
                this.returnData(baos);
                return null;
            }
            DataStore store = this.runtime.getDataStore();
            return store.writeEntry(href, base, media, new DataStore.DataWriter(){

                @Override
                public void store(OutputStream outstr) throws IOException {
                    if (Store.this.method == CompressionMethod.GZIP) {
                        GZIPOutputStream gzout = new GZIPOutputStream(outstr);
                        outstr = gzout;
                    }
                    outstr.write(decoded);
                }
            });
        }
        catch (FileNotFoundException e) {
            throw XProcException.stepError(50);
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
    }

    private URI storeText(XdmNode doc, String href, String base, String media) {
        Serializer serializer = this.makeSerializer();
        serializer.setOutputProperty(Serializer.Property.METHOD, "text");
        if (media == null) {
            media = "text/plain";
        }
        try {
            ByteArrayOutputStream baos;
            OutputStream outstr = baos = new ByteArrayOutputStream();
            if (this.method == CompressionMethod.GZIP) {
                GZIPOutputStream gzout = new GZIPOutputStream(outstr);
                outstr = gzout;
            }
            serializer.setOutputStream(outstr);
            try {
                S9apiUtils.serialize(this.runtime, doc, serializer);
            }
            catch (SaxonApiException e) {
                throw new IOException(e);
            }
            if (href == null) {
                this.returnData(baos);
                return null;
            }
            DataStore store = this.runtime.getDataStore();
            return store.writeEntry(href, base, media, new DataStore.DataWriter(){

                @Override
                public void store(OutputStream outstr) throws IOException {
                    outstr.write(baos.toByteArray());
                }
            });
        }
        catch (FileNotFoundException e) {
            throw XProcException.stepError(50);
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI storeJSON(final XdmNode doc, String href, String base, String media) throws SaxonApiException {
        if (media == null) {
            media = "application/json";
        }
        try {
            if (href == null) {
                OutputStream outstr = null;
                ByteArrayOutputStream baos = null;
                baos = new ByteArrayOutputStream();
                outstr = baos;
                try {
                    if (this.method == CompressionMethod.GZIP) {
                        GZIPOutputStream gzout = new GZIPOutputStream(outstr);
                        outstr = gzout;
                    }
                    PrintWriter writer = new PrintWriter(new OutputStreamWriter(outstr, "UTF-8"));
                    String json = XMLtoJSON.convert(doc);
                    writer.print(json);
                }
                finally {
                    outstr.close();
                }
                this.returnData(baos);
                return null;
            }
            DataStore store = this.runtime.getDataStore();
            return store.writeEntry(href, base, media, new DataStore.DataWriter(){

                @Override
                public void store(OutputStream outstr) throws IOException {
                    if (Store.this.method == CompressionMethod.GZIP) {
                        GZIPOutputStream gzout = new GZIPOutputStream(outstr);
                        outstr = gzout;
                    }
                    PrintWriter writer = new PrintWriter(new OutputStreamWriter(outstr, "UTF-8"));
                    String json = XMLtoJSON.convert(doc);
                    writer.print(json);
                }
            });
        }
        catch (FileNotFoundException e) {
            throw XProcException.stepError(50);
        }
        catch (IOException ioe) {
            throw XProcException.stepError(50, ioe);
        }
    }

    public void returnData(ByteArrayOutputStream baos) {
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(XProcConstants.c_data);
        tree.addAttribute(_encoding, "base64");
        tree.addAttribute(_content_type, "application/x-gzip");
        tree.startContent();
        tree.addText(Base64.encodeBytes(baos.toByteArray()));
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }

    protected static enum CompressionMethod {
        NONE,
        GZIP;

    }
}

