/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.AxisNodes;
import com.xmlcalabash.util.HttpUtils;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.XPointer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Pattern;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;

@XMLCalabash(name="p:xinclude", type="{http://www.w3.org/ns/xproc}xinclude")
public class XInclude
extends DefaultStep
implements ProcessMatchingNodes {
    private static final String localAttrNS = "http://www.w3.org/2001/XInclude/local-attributes";
    private static final String xiNS = "http://www.w3.org/2001/XInclude";
    private static final QName xi_include = new QName("http://www.w3.org/2001/XInclude", "include");
    private static final QName xi_fallback = new QName("http://www.w3.org/2001/XInclude", "fallback");
    private static final QName _fixup_xml_base = new QName("", "fixup-xml-base");
    private static final QName _fixup_xml_lang = new QName("", "fixup-xml-lang");
    private static final QName _set_xml_id = new QName("", "set-xml-id");
    private static final QName _accept = new QName("", "accept");
    private static final QName _accept_language = new QName("", "accept-language");
    private static final QName cx_trim = new QName("cx", "http://xmlcalabash.com/ns/extensions", "trim");
    private static final QName cx_read_limit = new QName("cx", "http://xmlcalabash.com/ns/extensions", "read-limit");
    private static final QName _encoding = new QName("", "encoding");
    private static final QName _href = new QName("", "href");
    private static final QName _parse = new QName("", "parse");
    private static final QName _fragid = new QName("", "fragid");
    private static final QName _xpointer = new QName("", "xpointer");
    private static final Pattern linesXptrRE = Pattern.compile("\\s*lines\\s*\\(\\s*(\\d+)\\s*-\\s*(\\d+)\\s*\\)\\s*");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private Stack<ProcessMatch> matcherStack = new Stack();
    private Stack<String> inside = new Stack();
    private Stack<String> setXmlId = new Stack();
    private boolean fixupBase = false;
    private boolean fixupLang = false;
    private boolean copyAttributes = false;
    private boolean defaultTrimText = false;
    private boolean trimText = false;
    private int readLimit = 102400000;
    private Exception mostRecentException = null;

    public XInclude(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        this.fixupBase = this.getOption(_fixup_xml_base, false);
        this.fixupLang = this.getOption(_fixup_xml_lang, false);
        this.copyAttributes = true;
        String trim = this.getStep().getExtensionAttribute(cx_trim);
        if (trim != null && !"false".equals(trim)) {
            if ("true".equals(trim)) {
                this.defaultTrimText = true;
                this.trimText = true;
            } else {
                throw new XProcException("XInclude cx:trim must be 'true' or 'false'.");
            }
        }
        if ((trim = this.getStep().getExtensionAttribute(cx_read_limit)) != null) {
            try {
                this.readLimit = Integer.parseInt(trim);
            }
            catch (NumberFormatException nfe) {
                throw new XProcException(nfe);
            }
        }
        XdmNode doc = this.source.read();
        XdmNode xdoc = this.expandXIncludes(doc);
        this.result.write(xdoc);
    }

    private XdmNode expandXIncludes(XdmNode doc) {
        this.logger.trace(MessageFormatter.nodeMessage(doc, "Starting expandXIncludes"));
        ProcessMatch matcher = new ProcessMatch(this.runtime, this);
        this.matcherStack.push(matcher);
        matcher.match(doc, new RuntimeValue("/|*", this.step.getNode()));
        XdmNode result = matcher.getResult();
        matcher = this.matcherStack.pop();
        return result;
    }

    @Override
    public boolean processStartDocument(XdmNode node) throws SaxonApiException {
        this.matcherStack.peek().startDocument(node.getBaseURI());
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) throws SaxonApiException {
        this.matcherStack.peek().endDocument();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean processStartElement(XdmNode node) throws SaxonApiException {
        ProcessMatch matcher = this.matcherStack.peek();
        if (xi_include.equals((Object)node.getNodeName())) {
            String href = node.getAttributeValue(_href);
            String parse = node.getAttributeValue(_parse);
            String xptr = node.getAttributeValue(_xpointer);
            String fragid = node.getAttributeValue(_fragid);
            String setId = node.getAttributeValue(_set_xml_id);
            String accept = node.getAttributeValue(_accept);
            String accept_lang = node.getAttributeValue(_accept_language);
            if (href == null) {
                href = "";
            }
            if (accept != null && accept.matches(".*[^ -~].*")) {
                throw new XProcException("Invalid characters in accept value");
            }
            if (accept_lang != null && accept_lang.matches(".*[^ -~].*")) {
                throw new XProcException("Invalid characters in accept value");
            }
            XdmNode fallback = null;
            for (XdmNode child : new AxisNodes(node, Axis.CHILD, 7)) {
                if (child.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                if (xi_fallback.equals((Object)child.getNodeName())) {
                    if (fallback != null) {
                        throw new XProcException((XStep)this.step, "XInclude element must contain at most one xi:fallback element.");
                    }
                    fallback = child;
                    continue;
                }
                if (!xiNS.equals(child.getNodeName().getNamespaceURI())) continue;
                throw new XProcException((XStep)this.step, "Element not allowed as child of XInclude: " + child.getNodeKind());
            }
            boolean forceFallback = false;
            XPointer xpointer = null;
            XdmNode subdoc = null;
            if (parse == null) {
                parse = "xml";
            }
            if (parse.contains(";")) {
                parse = parse.substring(0, parse.indexOf(";")).trim();
            }
            if ("xml".equals(parse) || "application/xml".equals(parse) || "text/xml".equals(parse) || parse.endsWith("+xml")) {
                parse = "xml";
            } else if ("text".equals(parse) || parse.startsWith("text/")) {
                parse = "text";
            } else {
                this.logger.info("Unrecognized parse value on XInclude: " + parse);
                xptr = null;
                fragid = null;
                forceFallback = true;
            }
            if (xptr != null && fragid != null && !xptr.equals(fragid)) {
                if ("xml".equals(parse)) {
                    this.logger.info("XInclude specifies different xpointer/fragid, using xpointer for xml: " + xptr);
                } else {
                    xptr = fragid;
                    this.logger.info("XInclude specifies different xpointer/fragid, using fragid for " + parse + ": " + xptr);
                }
            }
            if (xptr == null && fragid != null) {
                xptr = fragid;
            }
            this.trimText = this.defaultTrimText;
            String trim = node.getAttributeValue(cx_trim);
            if (trim != null) {
                if ("true".equals(trim) || "false".equals(trim)) {
                    this.trimText = "true".equals(trim);
                } else {
                    throw new XProcException("XInclude cx:trim must be 'true' or 'false'.");
                }
            }
            if (xptr != null) {
                if ("text".equals(parse)) {
                    String xtrim = xptr.trim();
                    if (xtrim.startsWith("line=") || xtrim.startsWith("char=")) {
                        xptr = "text(" + xptr + ")";
                    } else if (xtrim.startsWith("search=")) {
                        xptr = "search(" + xptr + ")";
                    }
                }
                xpointer = new XPointer(this.runtime, xptr, this.readLimit);
            }
            if (forceFallback) {
                this.logger.trace(MessageFormatter.nodeMessage(node, "XInclude fallback forced"));
                this.fallback(node, href);
                return false;
            }
            if ("text".equals(parse)) {
                this.readText(href, node, node.getBaseURI().toASCIIString(), xpointer, matcher);
                return false;
            }
            this.setXmlId.push(setId);
            subdoc = this.readXML(node, href, node.getBaseURI().toASCIIString());
            String iuri = null;
            if (subdoc == null) {
                this.logger.trace(MessageFormatter.nodeMessage(node, "XInclude parse failed: " + href));
                this.fallback(node, href);
                this.setXmlId.pop();
                return false;
            }
            iuri = subdoc.getBaseURI().toASCIIString();
            if (xptr != null) {
                iuri = iuri + "#" + xptr;
            }
            if (this.inside.contains(iuri)) {
                throw XProcException.stepError(29, "XInclude document includes itself: " + href);
            }
            this.logger.trace(MessageFormatter.nodeMessage(node, "XInclude parse: " + href));
            Vector<Object> nodes = null;
            if (xpointer == null) {
                nodes = new Vector();
                XdmSequenceIterator iter = subdoc.axisIterator(Axis.CHILD);
                while (iter.hasNext()) {
                    XdmNode xdmNode = (XdmNode)iter.next();
                    nodes.add(xdmNode);
                }
            } else {
                Hashtable<String, String> nsBindings = xpointer.xpathNamespaces();
                nodes = xpointer.selectNodes(this.runtime, subdoc);
                if (nodes == null) {
                    this.logger.trace(MessageFormatter.nodeMessage(node, "XInclude parse failed: " + href));
                    this.fallback(node, href);
                    this.setXmlId.pop();
                    return false;
                }
            }
            for (XdmNode xdmNode : nodes) {
                void var18_23;
                if ((this.fixupBase || this.fixupLang || this.copyAttributes) && xdmNode.getNodeKind() == XdmNodeKind.ELEMENT) {
                    Fixup fixup = new Fixup(this.runtime, node);
                    XdmNode xdmNode2 = fixup.fixup(xdmNode);
                }
                if (var18_23.getNodeKind() == XdmNodeKind.ELEMENT || var18_23.getNodeKind() == XdmNodeKind.DOCUMENT) {
                    this.inside.push(iuri);
                    XdmNode ex = this.expandXIncludes((XdmNode)var18_23);
                    matcher.addSubtree(ex);
                    this.inside.pop();
                    continue;
                }
                matcher.addSubtree((XdmNode)var18_23);
            }
            this.setXmlId.pop();
            return false;
        }
        if (xi_fallback.equals((Object)node.getNodeName())) {
            throw new XProcException("Invalid placement for xi:fallback element");
        }
        matcher.addStartElement(node);
        matcher.addAttributes(node);
        matcher.startContent();
        return true;
    }

    @Override
    public void processAttribute(XdmNode node) throws SaxonApiException {
        throw new UnsupportedOperationException("processAttribute can't happen in XInclude");
    }

    @Override
    public void processEndElement(XdmNode node) throws SaxonApiException {
        if (!xi_include.equals((Object)node.getNodeName())) {
            this.matcherStack.peek().addEndElement();
        }
    }

    @Override
    public void processText(XdmNode node) throws SaxonApiException {
        throw new UnsupportedOperationException("processText can't happen in XInclude");
    }

    @Override
    public void processComment(XdmNode node) throws SaxonApiException {
        throw new UnsupportedOperationException("processComment can't happen in XInclude");
    }

    @Override
    public void processPI(XdmNode node) throws SaxonApiException {
        throw new UnsupportedOperationException("processPI can't happen in XInclude");
    }

    private void readText(final String href, final XdmNode node, String base, final XPointer xpointer, final TreeWriter matcher) {
        this.logger.trace("XInclude read text: " + href + " (" + base + ")");
        DataStore store = this.runtime.getDataStore();
        try {
            store.readEntry(href, base, "text/plain, text/*, */*", null, new DataStore.DataReader(){

                @Override
                public void load(URI id, String media, InputStream content, long len) throws IOException {
                    String text = XInclude.this.readText(node, xpointer, media, content, len);
                    if (text == null) {
                        XInclude.this.logger.trace(MessageFormatter.nodeMessage(node, "XInclude text parse failed: " + href));
                        XInclude.this.fallback(node, href);
                    } else {
                        XInclude.this.logger.trace(MessageFormatter.nodeMessage(node, "XInclude text parse: " + href));
                        matcher.addText(text);
                    }
                }
            });
        }
        catch (Exception e) {
            this.logger.debug("XInclude read text failed");
            this.mostRecentException = e;
            this.fallback(node, href);
        }
    }

    String readText(XdmNode node, XPointer xpointer, String media, InputStream content, long len) throws IOException {
        String charset = HttpUtils.getCharset(media);
        if (charset == null && node.getAttributeValue(_encoding) != null) {
            charset = node.getAttributeValue(_encoding);
        }
        if (charset == null) {
            charset = "utf-8";
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(content, charset));
        String data = "";
        if (xpointer != null) {
            data = xpointer.selectText(rd, (int)len);
        } else {
            String line;
            while ((line = rd.readLine()) != null) {
                data = data + line + "\n";
            }
        }
        rd.close();
        if (this.trimText) {
            return data.trim();
        }
        return data;
    }

    public XdmNode readXML(XdmNode node, String href, String base) {
        this.logger.trace("XInclude read XML: " + href + " (" + base + ")");
        if (href == null || "".equals(href)) {
            XdmNode ptr = node;
            while (ptr.getParent() != null) {
                ptr = ptr.getParent();
            }
            return ptr;
        }
        try {
            XdmNode doc = this.runtime.parse(href, base);
            return doc;
        }
        catch (Exception e) {
            this.logger.debug("XInclude read XML failed");
            this.mostRecentException = e;
            return null;
        }
    }

    public void fallback(XdmNode node, String href) {
        this.logger.trace(MessageFormatter.nodeMessage(node, "fallback: " + node.getNodeName()));
        XdmNode fallback = null;
        for (XdmNode child : new AxisNodes(node, Axis.CHILD, 7)) {
            if (child.getNodeKind() != XdmNodeKind.ELEMENT || !xi_fallback.equals((Object)child.getNodeName())) continue;
            fallback = child;
        }
        if (fallback == null) {
            if (this.mostRecentException != null) {
                throw new XProcException((XStep)this.step, (Throwable)new RuntimeException("XInclude resource error (" + href + ") and no fallback provided.", this.mostRecentException));
            }
            throw new XProcException((XStep)this.step, "XInclude resource error (" + href + ") and no fallback provided.");
        }
        XdmSequenceIterator iter = fallback.axisIterator(Axis.CHILD);
        while (iter.hasNext()) {
            XdmNode fbc = (XdmNode)iter.next();
            if (fbc.getNodeKind() == XdmNodeKind.ELEMENT) {
                fbc = this.expandXIncludes(fbc);
            }
            this.matcherStack.peek().addSubtree(fbc);
        }
    }

    private class Fixup
    implements ProcessMatchingNodes {
        private XProcRuntime runtime = null;
        private ProcessMatch matcher = null;
        private boolean root = true;
        private XdmNode xinclude = null;

        public Fixup(XProcRuntime runtime, XdmNode node) {
            this.runtime = runtime;
            this.xinclude = node;
        }

        public XdmNode fixup(XdmNode node) {
            this.matcher = new ProcessMatch(this.runtime, this);
            this.matcher.match(node, new RuntimeValue("*", XInclude.this.step.getNode()));
            XdmNode fixed = this.matcher.getResult();
            return fixed;
        }

        @Override
        public boolean processStartDocument(XdmNode node) throws SaxonApiException {
            this.matcher.startDocument(node.getBaseURI());
            return true;
        }

        @Override
        public void processEndDocument(XdmNode node) throws SaxonApiException {
            this.matcher.endDocument();
        }

        @Override
        public boolean processStartElement(XdmNode node) throws SaxonApiException {
            HashSet<QName> copied = new HashSet<QName>();
            this.matcher.addStartElement(node);
            if (this.root) {
                this.root = false;
                if (XInclude.this.copyAttributes) {
                    String setId = (String)XInclude.this.setXmlId.peek();
                    if (setId != null) {
                        copied.add(XProcConstants.xml_id);
                        if (!"".equals(setId)) {
                            this.matcher.addAttribute(XProcConstants.xml_id, setId);
                        }
                    }
                    XdmSequenceIterator iter = this.xinclude.axisIterator(Axis.ATTRIBUTE);
                    while (iter.hasNext()) {
                        XdmNode child = (XdmNode)iter.next();
                        boolean copy = !"".equals(child.getNodeName().getNamespaceURI());
                        if (!(copy = copy && !"http://www.w3.org/XML/1998/namespace".equals(child.getNodeName().getNamespaceURI()))) continue;
                        QName aname = child.getNodeName();
                        if (XInclude.localAttrNS.equals(aname.getNamespaceURI())) {
                            aname = new QName("", aname.getLocalName());
                        }
                        copied.add(aname);
                        this.matcher.addAttribute(aname, child.getStringValue());
                    }
                }
                XdmSequenceIterator iter = node.axisIterator(Axis.ATTRIBUTE);
                while (iter.hasNext()) {
                    XdmNode child = (XdmNode)iter.next();
                    if (XProcConstants.xml_base.equals((Object)child.getNodeName()) && XInclude.this.fixupBase || XProcConstants.xml_lang.equals((Object)child.getNodeName()) && XInclude.this.fixupLang || copied.contains(child.getNodeName())) continue;
                    copied.add(child.getNodeName());
                    this.matcher.addAttribute(child);
                }
                if (XInclude.this.fixupBase) {
                    copied.add(XProcConstants.xml_base);
                    this.matcher.addAttribute(XProcConstants.xml_base, node.getBaseURI().toASCIIString());
                }
                String lang = this.getLang(node);
                if (XInclude.this.fixupLang && lang != null) {
                    copied.add(XProcConstants.xml_lang);
                    this.matcher.addAttribute(XProcConstants.xml_lang, lang);
                }
            } else {
                XdmSequenceIterator iter = node.axisIterator(Axis.ATTRIBUTE);
                while (iter.hasNext()) {
                    XdmNode child = (XdmNode)iter.next();
                    if (copied.contains(child.getNodeName())) continue;
                    this.matcher.addAttribute(child);
                }
            }
            this.matcher.startContent();
            return true;
        }

        @Override
        public void processAttribute(XdmNode node) throws SaxonApiException {
            throw new XProcException(node, "This can't happen!?");
        }

        @Override
        public void processEndElement(XdmNode node) throws SaxonApiException {
            this.matcher.addEndElement();
        }

        @Override
        public void processText(XdmNode node) throws SaxonApiException {
            throw new XProcException(node, "This can't happen!?");
        }

        @Override
        public void processComment(XdmNode node) throws SaxonApiException {
            throw new XProcException(node, "This can't happen!?");
        }

        @Override
        public void processPI(XdmNode node) throws SaxonApiException {
            throw new XProcException(node, "This can't happen!?");
        }

        private String getLang(XdmNode node) {
            String lang = null;
            while (lang == null && node.getNodeKind() == XdmNodeKind.ELEMENT) {
                lang = node.getAttributeValue(XProcConstants.xml_lang);
                node = node.getParent();
            }
            return lang;
        }
    }
}

