/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadableEmpty;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.Variable;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.runtime.XCatch;
import com.xmlcalabash.runtime.XChoose;
import com.xmlcalabash.runtime.XForEach;
import com.xmlcalabash.runtime.XGroup;
import com.xmlcalabash.runtime.XInput;
import com.xmlcalabash.runtime.XOutput;
import com.xmlcalabash.runtime.XPipelineCall;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.runtime.XTry;
import com.xmlcalabash.runtime.XUntilUnchanged;
import com.xmlcalabash.runtime.XViewport;
import com.xmlcalabash.util.MessageFormatter;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class XCompoundStep
extends XAtomicStep {
    protected Hashtable<QName, RuntimeValue> variables = new Hashtable();
    protected Vector<XStep> subpipeline = new Vector();

    public XCompoundStep(XProcRuntime runtime, Step step, XCompoundStep parent) {
        super(runtime, step, parent);
    }

    @Override
    public boolean hasInScopeVariableBinding(QName name) {
        if (this.variables.containsKey(name) || this.inScopeOptions.containsKey(name)) {
            return true;
        }
        return this.getParent() == null ? false : this.getParent().hasInScopeVariableBinding(name);
    }

    @Override
    public boolean hasInScopeVariableValue(QName name) {
        if (this.variables.containsKey(name) || this.inScopeOptions.containsKey(name)) {
            RuntimeValue v = this.getVariable(name);
            return v != null && v.initialized();
        }
        return this.getParent() == null ? false : this.getParent().hasInScopeVariableValue(name);
    }

    public RuntimeValue getVariable(QName name) {
        if (this.variables.containsKey(name)) {
            return this.variables.get(name);
        }
        if (this.inScopeOptions.containsKey(name)) {
            return (RuntimeValue)this.inScopeOptions.get(name);
        }
        return null;
    }

    public ReadablePipe getBinding(String stepName, String portName) {
        if (this.name.equals(stepName)) {
            XInput input = this.getInput(portName);
            return input.getReader();
        }
        for (XStep step : this.subpipeline) {
            if (!stepName.equals(step.getName())) continue;
            XOutput output = step.getOutput(portName);
            if (output == null) {
                return new ReadableEmpty();
            }
            ReadablePipe rpipe = output.getReader();
            return rpipe;
        }
        return this.parent.getBinding(stepName, portName);
    }

    protected void addStep(XStep step) {
        this.subpipeline.add(step);
    }

    @Override
    public void instantiate(Step step) {
        XInput xinput;
        String port;
        this.logger.trace(MessageFormatter.nodeMessage(step.getNode(), "--> instantiate " + step));
        this.instantiateReaders(step);
        this.parent.addStep(this);
        DeclareStep decl = step.getDeclaration();
        for (Step substep : decl.subpipeline()) {
            XAtomicStep newstep;
            if (XProcConstants.p_choose.equals((Object)substep.getType())) {
                newstep = new XChoose(this.runtime, substep, this);
                ((XChoose)newstep).instantiate(substep);
                continue;
            }
            if (XProcConstants.p_group.equals((Object)substep.getType())) {
                newstep = new XGroup(this.runtime, substep, this);
                ((XCompoundStep)newstep).instantiate(substep);
                continue;
            }
            if (XProcConstants.p_try.equals((Object)substep.getType())) {
                newstep = new XTry(this.runtime, substep, this);
                ((XTry)newstep).instantiate(substep);
                continue;
            }
            if (XProcConstants.p_catch.equals((Object)substep.getType())) {
                newstep = new XCatch(this.runtime, substep, this);
                ((XCompoundStep)newstep).instantiate(substep);
                continue;
            }
            if (XProcConstants.p_for_each.equals((Object)substep.getType())) {
                newstep = new XForEach(this.runtime, substep, this);
                ((XCompoundStep)newstep).instantiate(substep);
                continue;
            }
            if (XProcConstants.p_viewport.equals((Object)substep.getType())) {
                newstep = new XViewport(this.runtime, substep, this);
                ((XCompoundStep)newstep).instantiate(substep);
                continue;
            }
            if (XProcConstants.cx_until_unchanged.equals((Object)substep.getType())) {
                newstep = new XUntilUnchanged(this.runtime, substep, this);
                ((XCompoundStep)newstep).instantiate(substep);
                continue;
            }
            if (substep.isPipelineCall()) {
                newstep = new XPipelineCall(this.runtime, substep, this);
                newstep.instantiate(substep);
                continue;
            }
            newstep = new XAtomicStep(this.runtime, substep, this);
            newstep.instantiate(substep);
        }
        for (Input input : step.inputs()) {
            port = input.getPort();
            if (!port.startsWith("|")) continue;
            Vector readers = null;
            if (this.inputs.containsKey(port)) {
                readers = (Vector)this.inputs.get(port);
            } else {
                readers = new Vector();
                this.inputs.put(port, readers);
            }
            for (Binding binding : input.getBinding()) {
                ReadablePipe pipe = this.getPipeFromBinding(binding);
                pipe.canReadSequence(input.getSequence());
                pipe.setReader(step);
                readers.add(pipe);
                this.logger.trace(MessageFormatter.nodeMessage(step.getNode(), step.getName() + " reads from " + pipe + " for " + port));
            }
            xinput = new XInput(this.runtime, input);
            this.addInput(xinput);
        }
        for (Output output : step.outputs()) {
            port = output.getPort();
            if (port.endsWith("|")) {
                String rport = port.substring(0, port.length() - 1);
                xinput = this.getInput(rport);
                Pipe wpipe = xinput.getWriter();
                wpipe.setWriter(step);
                wpipe.canWriteSequence(true);
                this.outputs.put(port, wpipe);
                this.logger.trace(MessageFormatter.nodeMessage(step.getNode(), step.getName() + " writes to " + wpipe + " for " + port));
                continue;
            }
            XOutput xoutput = new XOutput(this.runtime, output);
            xoutput.setLogger(step.getLog(port));
            this.addOutput(xoutput);
            Pipe wpipe = xoutput.getWriter();
            wpipe.setWriter(step);
            wpipe.canWriteSequence(output.getSequence());
            this.outputs.put(port, wpipe);
            this.logger.trace(MessageFormatter.nodeMessage(step.getNode(), step.getName() + " writes to " + wpipe + " for " + port));
        }
    }

    protected void copyInputs() throws SaxonApiException {
        for (String port : this.inputs.keySet()) {
            if (port.startsWith("|")) continue;
            String wport = port + "|";
            WritablePipe pipe = (WritablePipe)this.outputs.get(wport);
            for (ReadablePipe reader : (Vector)this.inputs.get(port)) {
                while (reader.moreDocuments()) {
                    XdmNode doc = reader.read();
                    pipe.write(doc);
                    this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "Compound input copy from " + reader + " to " + pipe));
                }
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        for (XStep step : this.subpipeline) {
            step.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() throws SaxonApiException {
        XProcData data = this.runtime.getXProcData();
        data.openFrame(this);
        this.copyInputs();
        this.inScopeOptions = this.parent.getInScopeOptions();
        for (QName name : this.step.getOptions()) {
            Option option = this.step.getOption(name);
            RuntimeValue value = this.computeValue(option);
            this.setOption(name, value);
            this.inScopeOptions.put(name, value);
        }
        for (Variable var : this.step.getVariables()) {
            RuntimeValue value = this.computeValue(var);
            this.inScopeOptions.put(var.getName(), value);
        }
        this.runtime.start(this);
        try {
            for (XStep step : this.subpipeline) {
                step.run();
            }
            for (String port : this.inputs.keySet()) {
                if (!port.startsWith("|")) continue;
                String wport = port.substring(1);
                WritablePipe pipe = (WritablePipe)this.outputs.get(wport);
                for (ReadablePipe reader : (Vector)this.inputs.get(port)) {
                    while (reader.moreDocuments()) {
                        XdmNode doc = reader.read();
                        pipe.write(doc);
                        this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "Compound output copy from " + reader + " to " + pipe));
                    }
                }
            }
        }
        finally {
            this.runtime.finish(this);
            data.closeFrame();
        }
    }
}

