/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadOnlyPipe;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.Variable;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.MessageFormatter;
import java.util.Iterator;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;

public class XUntilUnchanged
extends XCompoundStep {
    private static final QName doca = new QName("", "doca");
    private static final QName docb = new QName("", "docb");
    private Pipe current = null;
    private int sequencePosition = 0;
    private int sequenceLength = 0;

    public XUntilUnchanged(XProcRuntime runtime, Step step, XCompoundStep parent) {
        super(runtime, step, parent);
    }

    @Override
    public ReadablePipe getBinding(String stepName, String portName) {
        if (this.name.equals(stepName) && ("#current".equals(portName) || "current".equals(portName))) {
            if (this.current == null) {
                this.current = new Pipe(this.runtime);
            }
            return new ReadOnlyPipe(this.runtime, this.current.documents());
        }
        return super.getBinding(stepName, portName);
    }

    @Override
    protected void copyInputs() throws SaxonApiException {
    }

    @Override
    public void reset() {
        super.reset();
        this.sequenceLength = 0;
        this.sequencePosition = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() throws SaxonApiException {
        this.logger.trace("Running cx:until-unchanged " + this.step.getName());
        XProcData data = this.runtime.getXProcData();
        data.openFrame(this);
        if (this.current == null) {
            this.current = new Pipe(this.runtime);
        }
        String iport = "#iteration-source";
        this.sequencePosition = 0;
        this.sequenceLength = 1;
        this.inScopeOptions = this.parent.getInScopeOptions();
        this.runtime.getXProcData().setIterationSize(this.sequenceLength);
        String iPortName = null;
        String oPortName = null;
        for (String port : this.inputs.keySet()) {
            if (!port.startsWith("|")) continue;
            iPortName = port;
            oPortName = port.substring(1);
        }
        this.runtime.start(this);
        try {
            for (ReadablePipe is_reader : (Vector)this.inputs.get(iport)) {
                XdmNode os_doc = null;
                while (is_reader.moreDocuments()) {
                    XdmNode is_doc = is_reader.read();
                    boolean changed = true;
                    while (changed) {
                        Iterator step2;
                        RuntimeValue value;
                        this.current.resetWriter();
                        this.current.write(is_doc);
                        this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "Copy to current"));
                        ++this.sequencePosition;
                        this.runtime.getXProcData().setIterationPosition(this.sequencePosition);
                        for (Variable var : this.step.getVariables()) {
                            value = this.computeValue(var);
                            this.inScopeOptions.put(var.getName(), value);
                        }
                        this.inScopeOptions = this.parent.getInScopeOptions();
                        for (Variable var : this.step.getVariables()) {
                            value = this.computeValue(var);
                            this.inScopeOptions.put(var.getName(), value);
                        }
                        for (Iterator step2 : this.subpipeline) {
                            ((XStep)((Object)step2)).run();
                        }
                        int docsCopied = 0;
                        for (ReadablePipe reader : (Vector)this.inputs.get(iPortName)) {
                            while (reader.moreDocuments()) {
                                os_doc = reader.read();
                                ++docsCopied;
                            }
                            reader.resetReader();
                        }
                        if (docsCopied != 1) {
                            throw XProcException.dynamicError(6, "Writing to " + iPortName + " on " + this.getStep().getName());
                        }
                        step2 = this.subpipeline.iterator();
                        while (step2.hasNext()) {
                            XStep step3 = (XStep)step2.next();
                            step3.reset();
                        }
                        XPathCompiler xcomp = this.runtime.getProcessor().newXPathCompiler();
                        xcomp.declareVariable(doca);
                        xcomp.declareVariable(docb);
                        XPathExecutable xexec = xcomp.compile("deep-equal($doca,$docb)");
                        XPathSelector selector = xexec.load();
                        selector.setVariable(doca, (XdmValue)is_doc);
                        selector.setVariable(docb, (XdmValue)os_doc);
                        Iterator values = selector.iterator();
                        XdmAtomicValue item = (XdmAtomicValue)values.next();
                        changed = !item.getBooleanValue();
                        is_doc = os_doc;
                    }
                    WritablePipe pipe = (WritablePipe)this.outputs.get(oPortName);
                    pipe.write(os_doc);
                }
            }
        }
        finally {
            for (String port : this.inputs.keySet()) {
                if (!port.startsWith("|")) continue;
                String wport = port.substring(1);
                WritablePipe pipe = (WritablePipe)this.outputs.get(wport);
                pipe.close();
            }
            this.runtime.finish(this);
            data.closeFrame();
        }
    }
}

