/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadOnlyPipe;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.Variable;
import com.xmlcalabash.model.Viewport;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XOutput;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.XProcMessageListenerHelper;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Vector;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class XViewport
extends XCompoundStep
implements ProcessMatchingNodes {
    private Pipe current = null;
    private ProcessMatch matcher = null;
    private int sequencePosition = 0;
    private int sequenceLength = 0;

    public XViewport(XProcRuntime runtime, Step step, XCompoundStep parent) {
        super(runtime, step, parent);
    }

    @Override
    public ReadablePipe getBinding(String stepName, String portName) {
        if (this.name.equals(stepName) && ("#current".equals(portName) || "current".equals(portName))) {
            if (this.current == null) {
                this.current = new Pipe(this.runtime);
            }
            return new ReadOnlyPipe(this.runtime, this.current.documents());
        }
        return super.getBinding(stepName, portName);
    }

    @Override
    protected void copyInputs() throws SaxonApiException {
    }

    @Override
    public void reset() {
        super.reset();
        this.sequenceLength = 0;
        this.sequencePosition = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() throws SaxonApiException {
        this.logger.trace("Running p:viewport " + this.step.getName());
        XProcData data = this.runtime.getXProcData();
        data.openFrame(this);
        if (this.current == null) {
            this.current = new Pipe(this.runtime);
        }
        RuntimeValue match = ((Viewport)this.step).getMatch();
        String iport = "#viewport-source";
        ReadablePipe vsource = null;
        if (((Vector)this.inputs.get(iport)).size() != 1) {
            throw XProcException.dynamicError(3);
        }
        vsource = (ReadablePipe)((Vector)this.inputs.get(iport)).get(0);
        XdmNode doc = vsource.read();
        if (doc == null || vsource.moreDocuments()) {
            throw XProcException.dynamicError(3);
        }
        this.matcher = new ProcessMatch(this.runtime, this);
        this.sequenceLength = this.matcher.count(doc, match, false);
        this.runtime.getXProcData().setIterationSize(this.sequenceLength);
        this.runtime.start(this);
        XProcMessageListenerHelper.openStep(this.runtime, this);
        try {
            this.matcher.match(doc, match);
        }
        finally {
            this.runtime.getMessageListener().closeStep();
        }
        this.runtime.finish(this);
        for (String port : this.inputs.keySet()) {
            if (!port.startsWith("|")) continue;
            String wport = port.substring(1);
            WritablePipe pipe = (WritablePipe)this.outputs.get(wport);
            XdmNode result = this.matcher.getResult();
            pipe.write(result);
            this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "Viewport output copy from matcher to " + pipe));
        }
    }

    @Override
    public boolean processStartDocument(XdmNode node) {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processStartElement(XdmNode node) throws SaxonApiException {
        this.runtime.getMessageListener().openStep(this, this.getNode(), null, null, BigDecimal.ONE.divide(new BigDecimal(this.sequenceLength), MathContext.DECIMAL128));
        try {
            TreeWriter treeWriter = new TreeWriter(this.runtime);
            treeWriter.startDocument(node.getBaseURI());
            treeWriter.addSubtree(node);
            treeWriter.endDocument();
            this.current.resetWriter();
            this.current.write(treeWriter.getResult());
            this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "Viewport copy matching node to " + this.current));
            ++this.sequencePosition;
            this.runtime.getXProcData().setIterationPosition(this.sequencePosition);
            this.inScopeOptions = this.parent.getInScopeOptions();
            for (Variable var : this.step.getVariables()) {
                RuntimeValue value = this.computeValue(var);
                this.inScopeOptions.put(var.getName(), value);
            }
            for (XStep step : this.subpipeline) {
                step.reset();
                try {
                    step.run();
                }
                catch (SaxonApiException sae) {
                    throw new XProcException(sae);
                }
            }
            try {
                int count = 0;
                for (String port : this.inputs.keySet()) {
                    if (!port.startsWith("|")) continue;
                    for (ReadablePipe reader : (Vector)this.inputs.get(port)) {
                        while (reader.moreDocuments()) {
                            XOutput output;
                            if (++count > 1 && !(output = this.getOutput(port.substring(1))).getSequence()) {
                                throw XProcException.dynamicError(7);
                            }
                            XdmNode doc = reader.read();
                            this.matcher.addSubtree(doc);
                        }
                        reader.resetReader();
                    }
                }
            }
            catch (SaxonApiException sae) {
                throw new XProcException(sae);
            }
        }
        finally {
            this.runtime.getMessageListener().closeStep();
        }
        return false;
    }

    @Override
    public void processEndElement(XdmNode node) {
    }

    @Override
    public void processText(XdmNode node) {
        throw new UnsupportedOperationException("Can't run a viewport over text, PI, or comments");
    }

    @Override
    public void processComment(XdmNode node) {
        throw new UnsupportedOperationException("Can't run a viewport over text, PI, or comments");
    }

    @Override
    public void processPI(XdmNode node) {
        throw new UnsupportedOperationException("Can't run a viewport over text, PI, or comments");
    }

    @Override
    public void processAttribute(XdmNode node) {
        throw new UnsupportedOperationException("Can't run a viewport over attributes");
    }
}

