/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcMessageListener;
import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.util.URIUtils;
import java.math.BigDecimal;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultXProcMessageListener
implements XProcMessageListener {
    private static Logger defaultLogger = LoggerFactory.getLogger(DefaultXProcMessageListener.class);
    private Logger log = defaultLogger;

    @Override
    public void error(XProcRunnable step, XProcException error) {
        this.log = step != null ? LoggerFactory.getLogger(step.getClass()) : defaultLogger;
        this.log.error(this.message(step, error.getLocation()[0], error.getMessage(), error.getErrorCode()));
    }

    @Override
    public void error(Throwable exception) {
        this.log.error(this.exceptionMessage(exception) + exception.getMessage());
        if (exception.getCause() != null) {
            this.log.error("    cause: " + this.exceptionMessage(exception.getCause()) + exception.getCause().getMessage());
        }
    }

    private String exceptionMessage(Throwable exception) {
        StructuredQName qCode = null;
        SourceLocator loc = null;
        String message = "";
        if (exception instanceof XPathException) {
            qCode = ((XPathException)exception).getErrorCodeQName();
        }
        if (exception instanceof TransformerException) {
            TransformerException tx = (TransformerException)exception;
            if (qCode == null && tx.getException() instanceof XPathException) {
                qCode = ((XPathException)tx.getException()).getErrorCodeQName();
            }
            if (tx.getLocator() != null) {
                loc = tx.getLocator();
                boolean done = false;
                while (!done && loc == null) {
                    if (tx.getException() instanceof TransformerException) {
                        tx = (TransformerException)tx.getException();
                        loc = tx.getLocator();
                        continue;
                    }
                    if (exception.getCause() instanceof TransformerException) {
                        tx = (TransformerException)exception.getCause();
                        loc = tx.getLocator();
                        continue;
                    }
                    done = true;
                }
            }
        }
        if (exception instanceof XProcException) {
            XProcException err = (XProcException)exception;
            loc = err.getLocation()[0];
            if (err.getErrorCode() != null) {
                QName n = err.getErrorCode();
                qCode = new StructuredQName(n.getPrefix(), n.getNamespaceURI(), n.getLocalName());
            }
            if (loc instanceof XProcException.XProcLocator && ((XProcException.XProcLocator)loc).getStep() != null) {
                message = message + ((XProcException.XProcLocator)loc).getStep() + ":";
            }
        }
        if (loc != null) {
            if (loc.getSystemId() != null && !"".equals(loc.getSystemId())) {
                message = message + loc.getSystemId() + ":";
            }
            if (loc.getLineNumber() != -1) {
                message = message + loc.getLineNumber() + ":";
            }
            if (loc.getColumnNumber() != -1) {
                message = message + loc.getColumnNumber() + ":";
            }
        }
        if (qCode != null) {
            message = message + qCode.getDisplayName() + ":";
        }
        return message;
    }

    @Override
    public void warning(XProcRunnable step, XdmNode location, String message) {
        this.log = step != null ? LoggerFactory.getLogger(step.getClass()) : defaultLogger;
        this.log.warn(this.message(step, location, message));
    }

    @Override
    public void warning(Throwable exception) {
        this.log.warn(this.exceptionMessage(exception) + exception.getMessage());
    }

    @Override
    public void info(XProcRunnable step, XdmNode location, String message) {
        this.log = step != null ? LoggerFactory.getLogger(step.getClass()) : defaultLogger;
        this.log.info(this.message(step, location, message));
    }

    @Override
    public void fine(XProcRunnable step, XdmNode location, String message) {
        this.log = step != null ? LoggerFactory.getLogger(step.getClass()) : defaultLogger;
        this.log.debug(this.message(step, location, message));
    }

    @Override
    public void finer(XProcRunnable step, XdmNode location, String message) {
        this.log = step != null ? LoggerFactory.getLogger(step.getClass()) : defaultLogger;
        this.log.trace(this.message(step, location, message));
    }

    @Override
    public void finest(XProcRunnable step, XdmNode location, String message) {
        this.log = step != null ? LoggerFactory.getLogger(step.getClass()) : defaultLogger;
        this.log.trace(this.message(step, location, message));
    }

    private String message(XProcRunnable step, XdmNode location, String message) {
        String prefix = "";
        if (location != null) {
            String systemId = URIUtils.cwdAsURI().relativize(location.getBaseURI()).toASCIIString();
            int line = location.getLineNumber();
            int col = location.getColumnNumber();
            if (systemId != null && !"".equals(systemId)) {
                prefix = prefix + systemId + ":";
            }
            if (line != -1) {
                prefix = prefix + line + ":";
            }
            if (col != -1) {
                prefix = prefix + col + ":";
            }
        }
        return prefix + message;
    }

    private String message(XProcRunnable step, SourceLocator location, String message, QName code) {
        String prefix = "";
        if (location != null) {
            String systemId = location.getSystemId();
            int line = location.getLineNumber();
            int col = location.getColumnNumber();
            if (systemId != null && !"".equals(systemId)) {
                prefix = prefix + systemId + ":";
            }
            if (line != -1) {
                prefix = prefix + line + ":";
            }
            if (col != -1) {
                prefix = prefix + col + ":";
            }
        }
        return prefix + message;
    }

    @Override
    public void openStep(XProcRunnable step, XdmNode location, String message, String level, BigDecimal portion) {
    }

    @Override
    public void closeStep() {
    }
}

