/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.util.URIUtils;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class MessageFormatter {
    public static String codeMessage(QName code, String message) {
        if (code != null) {
            return message + ": " + code;
        }
        return message;
    }

    public static String nodeMessage(XdmNode node, String message) {
        String prefix = "";
        if (node != null) {
            URI cwd = URIUtils.cwdAsURI();
            String systemId = cwd.relativize(node.getBaseURI()).toASCIIString();
            int line = node.getLineNumber();
            int col = node.getColumnNumber();
            if (systemId != null && !"".equals(systemId)) {
                prefix = prefix + systemId + ":";
            }
            if (line != -1) {
                prefix = prefix + line + ":";
            }
            if (col != -1) {
                prefix = prefix + col + ":";
            }
        }
        return prefix + message;
    }
}

