/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.core;

import com.nwalsh.annotations.SaxonExtensionFunction;
import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.core.XProcStep;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.piperack.PipelineSource;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.AxisNodes;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.LogOptions;
import com.xmlcalabash.util.Output;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.URIUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Version;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmValue;
import org.atteo.classindex.ClassFilter;
import org.atteo.classindex.ClassIndex;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class XProcConfiguration {
    public static final QName _prefix = new QName("", "prefix");
    public static final QName _uri = new QName("", "uri");
    public static final QName _class_name = new QName("", "class-name");
    public static final QName _type = new QName("", "type");
    public static final QName _port = new QName("", "port");
    public static final QName _href = new QName("", "href");
    public static final QName _data = new QName("", "data");
    public static final QName _name = new QName("", "name");
    public static final QName _key = new QName("", "key");
    public static final QName _expires = new QName("", "expires");
    public static final QName _value = new QName("", "value");
    public static final QName _loader = new QName("", "loader");
    public static final QName _exclude_inline_prefixes = new QName("", "exclude-inline-prefixes");
    protected Logger logger = null;
    public String saxonProcessor = "he";
    public boolean schemaAware = false;
    public Input saxonConfig = null;
    public Hashtable<String, String> nsBindings = new Hashtable();
    public boolean debug = false;
    public boolean showMessages = false;
    public Output profile = null;
    public Hashtable<String, Vector<ReadablePipe>> inputs = new Hashtable();
    public ReadablePipe pipeline = null;
    public Hashtable<String, String> outputs = new Hashtable();
    public Hashtable<String, Hashtable<QName, String>> params = new Hashtable();
    public Hashtable<QName, String> options = new Hashtable();
    public boolean safeMode = false;
    public String stepName = null;
    public String entityResolver = "org.xmlresolver.Resolver";
    public String uriResolver = "org.xmlresolver.Resolver";
    public String errorListener = null;
    public Hashtable<QName, Class> implementations = new Hashtable();
    public Hashtable<String, String> serializationOptions = new Hashtable();
    public LogOptions logOpt = LogOptions.WRAPPED;
    public HashMap<String, SaxonExtensionFunction> extensionFunctions = new HashMap();
    public List<FunctionLibrary> inscopeXsltFunctions;
    public String foProcessor = null;
    public String cssProcessor = null;
    public String xprocConfigurer = null;
    public String htmlParser = "validator.nu";
    public String mailHost = null;
    public String mailPort = "25";
    public String mailUser = null;
    public String mailPass = null;
    public Hashtable<String, String> loaders = new Hashtable();
    public HashSet<String> setSaxonProperties = new HashSet();
    public boolean extensionValues = false;
    public boolean xpointerOnText = false;
    public boolean transparentJSON = false;
    public boolean sequenceAsContext = false;
    public String jsonFlavor = "marklogic";
    public boolean useXslt10 = false;
    public boolean htmlSerializer = false;
    public boolean allowTextResults = false;
    public Vector<String> catalogs = new Vector();
    public int piperackPort = 8088;
    public int piperackDefaultExpires = 300;
    public HashMap<String, PipelineSource> piperackDefaultPipelines = new HashMap();
    private Processor cfgProcessor = null;
    private boolean firstInput = false;
    private boolean firstOutput = false;

    public XProcConfiguration() {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.initSaxonProcessor("he", false, null);
        this.init();
    }

    public XProcConfiguration(boolean schemaAware) {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.initSaxonProcessor("he", schemaAware, null);
        this.init();
    }

    public XProcConfiguration(Input saxoncfg) {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.initSaxonProcessor(null, false, saxoncfg);
        this.init();
    }

    public XProcConfiguration(String proctype, boolean schemaAware) {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.initSaxonProcessor(proctype, schemaAware, null);
        this.init();
    }

    public XProcConfiguration(Processor processor) {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.cfgProcessor = processor;
        this.loadConfiguration();
        if (this.schemaAware != processor.isSchemaAware()) {
            throw new XProcException("Schema awareness in configuration conflicts with specified processor.");
        }
        this.init();
    }

    public Processor getProcessor() {
        return this.cfgProcessor;
    }

    private void initSaxonProcessor(String proctype, boolean schemaAware, Input saxoncfg) {
        if (schemaAware) {
            proctype = "ee";
        }
        this.createSaxonProcessor(proctype, schemaAware, saxoncfg);
        this.loadConfiguration();
        this.schemaAware = this.cfgProcessor.isSchemaAware();
        this.saxonProcessor = Version.softwareEdition.toLowerCase();
        if (saxoncfg != null) {
            schemaAware = this.schemaAware;
            proctype = this.saxonProcessor;
        }
        if (proctype != null && !this.saxonProcessor.equals(proctype) || schemaAware != this.schemaAware || saxoncfg == null && this.saxonConfig != null) {
            this.nsBindings.clear();
            this.inputs.clear();
            this.outputs.clear();
            this.params.clear();
            this.options.clear();
            this.implementations.clear();
            this.extensionFunctions.clear();
            this.createSaxonProcessor(this.saxonProcessor, this.schemaAware, this.saxonConfig);
            this.loadConfiguration();
            this.schemaAware = this.cfgProcessor.isSchemaAware();
            this.saxonProcessor = Version.softwareEdition.toLowerCase();
        }
    }

    private void init() {
        String[] pathElements;
        FunctionLibraryList list = new FunctionLibraryList();
        this.cfgProcessor.getUnderlyingConfiguration().getBuiltInExtensionLibraryList().addFunctionLibrary((FunctionLibrary)list);
        this.inscopeXsltFunctions = list.getLibraryList();
        this.schemaAware = this.cfgProcessor.isSchemaAware();
        this.saxonProcessor = Version.softwareEdition.toLowerCase();
        this.findStepClasses();
        this.findExtensionFunctions();
        String classPath = System.getProperty("java.class.path");
        for (String path : pathElements = classPath.split(System.getProperty("path.separator"))) {
            path = new File(path).getAbsolutePath();
            String jarFileURL = URLDecoder.decode(new File(path).toURI().toString().replace("+", "%2B"));
            try {
                JarFile jar = new JarFile(path);
                ZipEntry catalog = jar.getEntry("catalog.xml");
                if (catalog != null) {
                    this.catalogs.add("jar:" + jarFileURL + "!/catalog.xml");
                    this.logger.debug("Using catalog: jar:" + jarFileURL + "!/catalog.xml");
                }
                if ((catalog = jar.getEntry("META-INF/catalog.xml")) == null) continue;
                this.catalogs.add("jar:" + jarFileURL + "!/META-INF/catalog.xml");
                this.logger.debug("Using catalog: jar:" + jarFileURL + "!/META-INF/catalog.xml");
            }
            catch (IOException e) {
                File f;
                String catfn = path;
                if (!catfn.endsWith("/")) {
                    catfn = catfn + "/";
                }
                if (!(f = new File(catfn = catfn + "catalog.xml")).exists() || !f.isFile()) continue;
                this.catalogs.add(catfn);
                this.logger.debug("Using catalog: " + catfn);
            }
        }
    }

    private void createSaxonProcessor(String proctype, boolean schemaAware, Input saxoncfg) {
        boolean licensed;
        boolean bl = licensed = schemaAware || !"he".equals(proctype);
        if (saxoncfg != null) {
            try {
                InputStream instream = null;
                switch (saxoncfg.getKind()) {
                    case URI: {
                        URI furi = URI.create(saxoncfg.getUri());
                        instream = new FileInputStream(new File(furi));
                        break;
                    }
                    case INPUT_STREAM: {
                        instream = saxoncfg.getInputStream();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unsupported saxonConfig kind '%s'", new Object[]{saxoncfg.getKind()}));
                    }
                }
                SAXSource source = new SAXSource(new InputSource(instream));
                this.cfgProcessor = new Processor((Source)source);
            }
            catch (FileNotFoundException e) {
                throw new XProcException(e);
            }
            catch (SaxonApiException e) {
                throw new XProcException(e);
            }
        } else {
            this.cfgProcessor = new Processor(licensed);
        }
        this.cfgProcessor.getUnderlyingConfiguration().getParseOptions().setSpaceStrippingRule((SpaceStrippingRule)NoElementsSpaceStrippingRule.getInstance());
        String actualtype = Version.softwareEdition;
        if (proctype != null && !"he".equals(proctype) && !actualtype.toLowerCase().equals(proctype)) {
            System.err.println("Failed to obtain " + proctype.toUpperCase() + " processor; using " + actualtype + " instead.");
        }
    }

    private Iterable<Class<?>> findClasses(Class<? extends Annotation> type) {
        Iterable classes = null;
        try {
            classes = ClassFilter.only().from(ClassIndex.getAnnotated(type));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (classes == null || !classes.iterator().hasNext()) {
            HashSet set;
            block22: {
                set = new HashSet();
                try {
                    Bundle bundle = FrameworkUtil.getBundle(XProcConfiguration.class);
                    if (bundle == null) break block22;
                    String path = "META-INF/annotations/" + type.getCanonicalName();
                    URL url = bundle.getEntry(path);
                    if (url != null) {
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                            String line = reader.readLine();
                            while (line != null) {
                                try {
                                    set.add(XProcConfiguration.class.getClassLoader().loadClass(line));
                                }
                                catch (ClassNotFoundException e) {
                                    throw new RuntimeException("coding error");
                                }
                                line = reader.readLine();
                            }
                            break block22;
                        }
                    }
                    this.logger.warn("file " + path + " does not exist");
                }
                catch (IOException e) {
                    throw new RuntimeException("coding error");
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
            return set;
        }
        return classes;
    }

    private void findStepClasses() {
        Iterable<Class<?>> classes = this.findClasses(XMLCalabash.class);
        for (Class<?> klass : classes) {
            XMLCalabash annotation = klass.getAnnotation(XMLCalabash.class);
            for (String clarkName : annotation.type().split("\\s+")) {
                try {
                    QName name = QName.fromClarkName((String)clarkName);
                    this.logger.trace("Found step type annotation: " + clarkName);
                    if (this.implementations.containsKey(name)) {
                        this.logger.debug("Ignoring step type annotation for configured step: " + clarkName);
                    }
                    this.implementations.put(name, klass);
                }
                catch (IllegalArgumentException iae) {
                    this.logger.debug("Failed to parse step annotation type: " + clarkName);
                }
            }
        }
    }

    private void findExtensionFunctions() {
        Iterable<Class<?>> classes = this.findClasses(SaxonExtensionFunction.class);
        for (Class<?> klass : classes) {
            String name = klass.getCanonicalName();
            SaxonExtensionFunction annotation = klass.getAnnotation(SaxonExtensionFunction.class);
            this.logger.trace("Found Saxon extension function: " + klass.getCanonicalName());
            if (this.extensionFunctions.containsKey(name)) {
                this.logger.debug("Duplicate saxon extension function class: " + name);
            }
            this.extensionFunctions.put(name, annotation);
        }
    }

    private String fixUpURI(String uri) {
        File f = new File(uri);
        String fn = URIUtils.encode(f.getAbsolutePath());
        if ("\\".equals(System.getProperty("file.separator"))) {
            fn = "/" + fn;
        }
        return fn;
    }

    private void loadConfiguration() {
        String s;
        block29: {
            XdmNode cnode;
            String cfg;
            URI cwd;
            block28: {
                URI home = URIUtils.homeAsURI();
                cwd = URIUtils.cwdAsURI();
                URI puri = home;
                cfg = System.getProperty("com.xmlcalabash.config.global");
                try {
                    if (cfg == null) {
                        InputStream instream = this.getClass().getResourceAsStream("/etc/configuration.xml");
                        if (instream == null) {
                            return;
                        }
                        SAXSource source = new SAXSource(new InputSource(instream));
                        DocumentBuilder builder = this.cfgProcessor.newDocumentBuilder();
                        builder.setLineNumbering(true);
                        builder.setBaseURI(puri);
                        this.parse(builder.build((Source)source));
                    } else {
                        this.parse(this.readXML(cfg, cwd.toASCIIString()));
                    }
                }
                catch (SaxonApiException sae) {
                    throw new XProcException(sae);
                }
                cfg = System.getProperty("com.xmlcalabash.config.user", ".calabash");
                if (!"".equals(cfg)) {
                    try {
                        cnode = this.readXML(cfg, home.toASCIIString());
                        this.parse(cnode);
                    }
                    catch (XProcException xe) {
                        if (XProcConstants.dynamicError(11).equals((Object)xe.getErrorCode())) break block28;
                        throw xe;
                    }
                }
            }
            cfg = System.getProperty("com.xmlcalabash.config.local", ".calabash");
            if (!"".equals(cfg)) {
                try {
                    cnode = this.readXML(cfg, cwd.toASCIIString());
                    this.parse(cnode);
                }
                catch (XProcException xe) {
                    if (XProcConstants.dynamicError(11).equals((Object)xe.getErrorCode())) break block29;
                    throw xe;
                }
            }
        }
        this.saxonProcessor = System.getProperty("com.xmlcalabash.saxon-processor", this.saxonProcessor);
        if (!("he".equals(this.saxonProcessor) || "pe".equals(this.saxonProcessor) || "ee".equals(this.saxonProcessor))) {
            throw new XProcException("Invalid Saxon processor specified in com.xmlcalabash.saxon-processor property.");
        }
        String saxonConfigProperty = System.getProperty("com.xmlcalabash.saxon-configuration");
        if (saxonConfigProperty != null) {
            this.saxonConfig = new Input("file://" + this.fixUpURI(saxonConfigProperty));
        }
        this.schemaAware = "true".equals(System.getProperty("com.xmlcalabash.schema-aware", "" + this.schemaAware));
        this.debug = "true".equals(System.getProperty("com.xmlcalabash.debug", "" + this.debug));
        this.showMessages = "true".equals(System.getProperty("com.xmlcalabash.show-messages", "" + this.showMessages));
        String profileProperty = System.getProperty("com.xmlcalabash.profile");
        if (profileProperty != null) {
            this.profile = new Output("file://" + this.fixUpURI(profileProperty));
        }
        this.extensionValues = "true".equals(System.getProperty("com.xmlcalabash.general-values", "" + this.extensionValues));
        this.xpointerOnText = "true".equals(System.getProperty("com.xmlcalabash.xpointer-on-text", "" + this.xpointerOnText));
        this.transparentJSON = "true".equals(System.getProperty("com.xmlcalabash.transparent-json", "" + this.transparentJSON));
        this.sequenceAsContext = "true".equals(System.getProperty("com.xmlcalabash.sequence-as-context", "" + this.sequenceAsContext));
        this.allowTextResults = "true".equals(System.getProperty("com.xmlcalabash.allow-text-results", "" + this.allowTextResults));
        this.safeMode = "true".equals(System.getProperty("com.xmlcalabash.safe-mode", "" + this.safeMode));
        this.jsonFlavor = System.getProperty("com.xmlcalabash.json-flavor", this.jsonFlavor);
        this.useXslt10 = "true".equals(System.getProperty("com.xmlcalabash.use-xslt-10", "" + this.useXslt10));
        this.htmlSerializer = "true".equals(System.getProperty("com.xmlcalabash.html-serializer", "" + this.htmlSerializer));
        this.entityResolver = System.getProperty("com.xmlcalabash.entity-resolver", this.entityResolver);
        this.uriResolver = System.getProperty("com.xmlcalabash.uri-resolver", this.uriResolver);
        this.errorListener = System.getProperty("com.xmlcalabash.error-listener", this.errorListener);
        this.foProcessor = System.getProperty("com.xmlcalabash.fo-processor", this.foProcessor);
        this.cssProcessor = System.getProperty("com.xmlcalabash.css-processor", this.cssProcessor);
        this.xprocConfigurer = System.getProperty("com.xmlcalabash.xproc-configurer", this.xprocConfigurer);
        this.htmlParser = System.getProperty("com.xmlcalabash.html-parser", this.htmlParser);
        this.mailHost = System.getProperty("com.xmlcalabash.mail-host", this.mailHost);
        this.mailPort = System.getProperty("com.xmlcalabash.mail-port", this.mailPort);
        this.mailUser = System.getProperty("com.xmlcalabash.mail-username", this.mailUser);
        this.mailPass = System.getProperty("com.xmlcalabash.mail-password", this.mailPass);
        if (System.getProperty("com.xmlcalabash.log-style") != null) {
            String s2 = System.getProperty("com.xmlcalabash.log-style");
            if ("off".equals(s2)) {
                this.logOpt = LogOptions.OFF;
            } else if ("plain".equals(s2)) {
                this.logOpt = LogOptions.PLAIN;
            } else if ("wrapped".equals(s2)) {
                this.logOpt = LogOptions.WRAPPED;
            } else if ("directory".equals(s2)) {
                this.logOpt = LogOptions.DIRECTORY;
            } else {
                throw new XProcException("Invalid log-style specified in com.xmlcalabash.log-style property");
            }
        }
        if (System.getProperty("com.xmlcalabash.piperack-port") != null) {
            this.piperackPort = Integer.parseInt(System.getProperty("com.xmlcalabash.piperack-port"));
        }
        if (System.getProperty("com.xmlcalabash.piperack-default-expires") != null) {
            this.piperackDefaultExpires = Integer.parseInt(System.getProperty("com.xmlcalabash.piperack-port"));
        }
        String[] boolSerNames = new String[]{"byte-order-mark", "escape-uri-attributes", "include-content-type", "indent", "omit-xml-declaration", "undeclare-prefixes"};
        String[] strSerNames = new String[]{"doctype-public", "doctype-system", "encoding", "media-type", "normalization-form", "version", "standalone"};
        for (String name : boolSerNames) {
            s = System.getProperty("com.xmlcalabash.serial." + name);
            if (!"true".equals(s) && !"false".equals(s)) continue;
            this.serializationOptions.put(name, s);
        }
        for (String name : strSerNames) {
            s = System.getProperty("com.xmlcalabash.serial." + name);
            if (s == null) continue;
            this.serializationOptions.put(name, s);
        }
        String method = System.getProperty("com.xmlcalabash.serial.method");
        if ("html".equals(method) || "xhtml".equals(method) || "text".equals(method) || "xml".equals(method)) {
            this.serializationOptions.put(method, method);
        }
    }

    public XdmNode readXML(String href, String base) {
        SAXSource source = null;
        href = URIUtils.encode(href);
        try {
            URI baseURI = new URI(base);
            source = new SAXSource(new InputSource(baseURI.resolve(href).toASCIIString()));
        }
        catch (URISyntaxException use) {
            throw new XProcException(use);
        }
        DocumentBuilder builder = this.cfgProcessor.newDocumentBuilder();
        builder.setLineNumbering(true);
        try {
            return builder.build((Source)source);
        }
        catch (SaxonApiException sae) {
            throw XProcException.dynamicError(11, sae);
        }
    }

    public void parse(XdmNode doc) {
        if (doc.getNodeKind() == XdmNodeKind.DOCUMENT) {
            doc = S9apiUtils.getDocumentElement(doc);
        }
        for (XdmNode node : new AxisNodes(null, doc, Axis.CHILD, 31)) {
            String uri = node.getNodeName().getNamespaceURI();
            String localName = node.getNodeName().getLocalName();
            if (!"http://xmlcalabash.com/ns/configuration".equals(uri) && !"http://exproc.org/ns/configuration".equals(uri)) continue;
            if ("implementation".equals(localName)) {
                this.parseImplementation(node);
                continue;
            }
            if ("saxon-processor".equals(localName)) {
                this.parseSaxonProcessor(node);
                continue;
            }
            if ("saxon-configuration".equals(localName)) {
                this.parseSaxonConfiguration(node);
                continue;
            }
            if ("schema-aware".equals(localName)) {
                this.parseSchemaAware(node);
                continue;
            }
            if ("namespace-binding".equals(localName)) {
                this.parseNamespaceBinding(node);
                continue;
            }
            if ("debug".equals(localName)) {
                this.parseDebug(node);
                continue;
            }
            if ("show-messages".equals(localName)) {
                this.parseShowMessages(node);
                continue;
            }
            if ("profile".equals(localName)) {
                this.parseProfile(node);
                continue;
            }
            if ("entity-resolver".equals(localName)) {
                this.parseEntityResolver(node);
                continue;
            }
            if ("input".equals(localName)) {
                this.parseInput(node);
                continue;
            }
            if ("output".equals(localName)) {
                this.parseOutput(node);
                continue;
            }
            if ("with-option".equals(localName)) {
                this.parseWithOption(node);
                continue;
            }
            if ("with-param".equals(localName)) {
                this.parseWithParam(node);
                continue;
            }
            if ("safe-mode".equals(localName)) {
                this.parseSafeMode(node);
                continue;
            }
            if ("step-name".equals(localName)) {
                this.parseStepName(node);
                continue;
            }
            if ("uri-resolver".equals(localName)) {
                this.parseURIResolver(node);
                continue;
            }
            if ("step-error-listener".equals(localName)) {
                this.parseErrorListener(node);
                continue;
            }
            if ("pipeline".equals(localName)) {
                this.parsePipeline(node);
                continue;
            }
            if ("serialization".equals(localName)) {
                this.parseSerialization(node);
                continue;
            }
            if ("extension-function".equals(localName)) {
                this.parseExtensionFunction(node);
                continue;
            }
            if ("fo-processor".equals(localName)) {
                this.parseFoProcessor(node);
                continue;
            }
            if ("css-processor".equals(localName)) {
                this.parseCssProcessor(node);
                continue;
            }
            if ("xproc-configurer".equals(localName)) {
                this.parseXProcConfigurer(node);
                continue;
            }
            if ("default-system-property".equals(localName)) {
                this.parseSystemProperty(node);
                continue;
            }
            if ("extension".equals(localName)) {
                this.parseExtension(node);
                continue;
            }
            if ("html-parser".equals(localName)) {
                this.parseHtmlParser(node);
                continue;
            }
            if ("sendmail".equals(localName)) {
                this.parseSendMail(node);
                continue;
            }
            if ("saxon-configuration-property".equals(localName)) {
                this.saxonConfigurationProperty(node);
                continue;
            }
            if ("log-style".equals(localName)) {
                this.logStyle(node);
                continue;
            }
            if ("pipeline-loader".equals(localName)) {
                this.pipelineLoader(node);
                continue;
            }
            if ("piperack-port".equals(localName)) {
                this.piperackPort(node);
                continue;
            }
            if ("piperack-default-expires".equals(localName)) {
                this.piperackDefaultExpires(node);
                continue;
            }
            if ("piperack-load-pipeline".equals(localName)) {
                this.piperackLoadPipeline(node);
                continue;
            }
            throw new XProcException(doc, "Unexpected configuration option: " + localName);
        }
        this.firstInput = true;
        this.firstOutput = true;
    }

    public boolean isStepAvailable(QName type) {
        if (this.implementations.containsKey(type)) {
            Class klass = this.implementations.get(type);
            try {
                Method method = klass.getMethod("isAvailable", new Class[0]);
                Boolean available = (Boolean)method.invoke(null, new Object[0]);
                return available;
            }
            catch (NoSuchMethodException e) {
                return true;
            }
            catch (InvocationTargetException e) {
                return true;
            }
            catch (IllegalAccessException e) {
                return true;
            }
        }
        return false;
    }

    public XProcStep newStep(XProcRuntime runtime, XAtomicStep step) {
        Class klass = this.implementations.get(step.getType());
        if (klass == null) {
            throw new XProcException("Misconfigured. No 'class' in configuration for " + step.getType());
        }
        String className = klass.getName();
        if (runtime.getSafeMode() && !className.startsWith("com.xmlcalabash.")) {
            throw XProcException.dynamicError(21);
        }
        try {
            Constructor<XProcStep> constructor = Class.forName(className).asSubclass(XProcStep.class).getConstructor(XProcRuntime.class, XAtomicStep.class);
            return constructor.newInstance(runtime, step);
        }
        catch (NoSuchMethodException nsme) {
            throw new UnsupportedOperationException("No such method: " + className, nsme);
        }
        catch (ClassNotFoundException cfne) {
            throw new UnsupportedOperationException("Class not found: " + className, cfne);
        }
        catch (InstantiationException ie) {
            throw new UnsupportedOperationException("Instantiation error", ie);
        }
        catch (IllegalAccessException iae) {
            throw new UnsupportedOperationException("Illegal access error", iae);
        }
        catch (InvocationTargetException ite) {
            throw new UnsupportedOperationException("Invocation target exception", ite);
        }
    }

    public static void showVersion(XProcRuntime runtime) {
        System.out.println("XML Calabash version " + XProcConstants.XPROC_VERSION + ", an XProc processor.");
        if (runtime != null) {
            System.out.print("Running on Saxon version ");
            System.out.print(runtime.getConfiguration().getProcessor().getSaxonProductVersion());
            System.out.print(", ");
            System.out.print(runtime.getConfiguration().getProcessor().getUnderlyingConfiguration().getEditionCode());
            System.out.println(" edition.");
        }
        System.out.println("Copyright (c) 2007-2013 Norman Walsh");
        System.out.println("See docs/notices/NOTICES in the distribution for licensing");
        System.out.println("See also http://xmlcalabash.com/ for more information");
        System.out.println("");
    }

    private void parseSaxonProcessor(XdmNode node) {
        String value = node.getStringValue().trim();
        if (!("he".equals(value) || "pe".equals(value) || "ee".equals(value))) {
            throw new XProcException(node, "Invalid Saxon processor: " + value + ". Must be 'he', 'pe', or 'ee'.");
        }
        this.saxonProcessor = value;
    }

    private void parseSaxonConfiguration(XdmNode node) {
        String value = node.getStringValue().trim();
        this.saxonConfig = new Input("file://" + this.fixUpURI(value));
    }

    private void parseSchemaAware(XdmNode node) {
        String value = node.getStringValue().trim();
        if (!"true".equals(value) && !"false".equals(value)) {
            throw new XProcException(node, "Invalid configuration value for schema-aware: " + value);
        }
        this.schemaAware = "true".equals(value);
    }

    private void parseNamespaceBinding(XdmNode node) {
        String aname = node.getAttributeValue(_prefix);
        String avalue = node.getAttributeValue(_uri);
        this.nsBindings.put(aname, avalue);
    }

    private void parseDebug(XdmNode node) {
        String value = node.getStringValue().trim();
        this.debug = "true".equals(value);
        if (!"true".equals(value) && !"false".equals(value)) {
            throw new XProcException(node, "Invalid configuration value for debug: " + value);
        }
    }

    private void parseShowMessages(XdmNode node) {
        String value = node.getStringValue().trim();
        this.showMessages = "true".equals(value);
        if (!"true".equals(value) && !"false".equals(value)) {
            throw new XProcException(node, "Invalid configuration value for show-messages: " + value);
        }
    }

    private void parseProfile(XdmNode node) {
        this.profile = new Output("file://" + this.fixUpURI(node.getStringValue().trim()));
    }

    private void parseEntityResolver(XdmNode node) {
        String value;
        this.entityResolver = value = node.getAttributeValue(_class_name);
    }

    private void parseExtensionFunction(XdmNode node) {
        String value = node.getAttributeValue(_class_name);
        this.extensionFunctions.put(value, null);
    }

    private void parseFoProcessor(XdmNode node) {
        String value;
        this.foProcessor = value = node.getAttributeValue(_class_name);
    }

    private void parseCssProcessor(XdmNode node) {
        String value;
        this.cssProcessor = value = node.getAttributeValue(_class_name);
    }

    private void parseXProcConfigurer(XdmNode node) {
        String value;
        this.xprocConfigurer = value = node.getAttributeValue(_class_name);
    }

    private void parseSystemProperty(XdmNode node) {
        String name = node.getAttributeValue(_name);
        String value = node.getAttributeValue(_value);
        if (name == null || value == null) {
            throw new XProcException("Configuration option 'default-system-property' cannot have null name or value");
        }
        if (System.getProperty(name) == null) {
            System.setProperty(name, value);
        }
    }

    private void parseExtension(XdmNode node) {
        String name = node.getAttributeValue(_name);
        String value = node.getAttributeValue(_value);
        if (name == null || value == null) {
            throw new XProcException("Configuration option 'extension' cannot have null name or value");
        }
        if ("general-values".equals(name)) {
            this.extensionValues = "true".equals(value);
        } else if ("xpointer-on-text".equals(name)) {
            this.xpointerOnText = "true".equals(value);
        } else if ("transparent-json".equals(name)) {
            this.transparentJSON = "true".equals(value);
        } else if ("sequence-as-context".equals(name)) {
            this.sequenceAsContext = "true".equals(value);
        } else if ("json-flavor".equals(name)) {
            this.jsonFlavor = value;
            if (!JSONtoXML.knownFlavor(this.jsonFlavor)) {
                throw new XProcException("Unrecognized JSON flavor: " + this.jsonFlavor);
            }
        } else if ("allow-text-results".equals(name)) {
            this.allowTextResults = "true".equals(value);
        } else if ("use-xslt-1.0".equals(name) || "use-xslt-10".equals(name)) {
            this.useXslt10 = "true".equals(value);
        } else if ("html-serializer".equals(name)) {
            this.htmlSerializer = "true".equals(value);
        } else {
            throw new XProcException("Unrecognized extension in configuration: " + name);
        }
    }

    private void parseHtmlParser(XdmNode node) {
        String value = node.getAttributeValue(_value);
        if (value == null) {
            throw new XProcException("Configuration option 'html-parser' cannot have null value");
        }
        if (!"validator.nu".equals(value) && !"tagsoup".equals(value)) {
            throw new XProcException("Unrecognized value in html-parser: " + value);
        }
        this.htmlParser = value;
    }

    private void parseSendMail(XdmNode node) {
        String host = node.getAttributeValue(new QName("", "host"));
        String port = node.getAttributeValue(_port);
        String user = node.getAttributeValue(new QName("", "username"));
        String pass = node.getAttributeValue(new QName("", "password"));
        if (host != null) {
            this.mailHost = host;
        }
        if (port != null) {
            this.mailPort = port;
        }
        if (user != null) {
            this.mailUser = user;
            if (pass == null) {
                throw new XProcException("Misconfigured sendmail: user specified without password");
            }
            this.mailPass = pass;
        }
    }

    private void saxonConfigurationProperty(XdmNode node) {
        String value = node.getAttributeValue(_value);
        String key = node.getAttributeValue(_key);
        String type = node.getAttributeValue(_type);
        Object valueObj = null;
        if (key == null || value == null) {
            throw new XProcException("Configuration option 'saxon-configuration-property' cannot have a null key or value");
        }
        valueObj = "boolean".equals(type) ? Boolean.valueOf("true".equals(value)) : ("integer".equals(type) ? Integer.valueOf(Integer.parseInt(value)) : value);
        try {
            this.setSaxonProperties.add(key);
            this.cfgProcessor.setConfigurationProperty(key, valueObj);
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
    }

    private void logStyle(XdmNode node) {
        String style = node.getAttributeValue(_value);
        if ("off".equals(style)) {
            this.logOpt = LogOptions.OFF;
        } else if ("plain".equals(style)) {
            this.logOpt = LogOptions.PLAIN;
        } else if ("wrapped".equals(style)) {
            this.logOpt = LogOptions.WRAPPED;
        } else if ("directory".equals(style)) {
            this.logOpt = LogOptions.DIRECTORY;
        } else {
            throw new XProcException("Configuration option 'log-style' must be one of 'off', 'plain', 'wrapped', or 'directory'");
        }
    }

    private void pipelineLoader(XdmNode node) {
        String data = node.getAttributeValue(_data);
        String href = node.getAttributeValue(_href);
        String loader = node.getAttributeValue(_loader);
        if (data == null && href == null || data != null && href != null) {
            throw new XProcException("Configuration option 'pipeline-loader' must have one of 'href' or 'data'");
        }
        if (loader == null) {
            throw new XProcException("Configuration option 'pipeline-loader' must specify a 'loader'");
        }
        if (data == null) {
            this.loaders.put("href:" + href, loader);
        } else {
            this.loaders.put("data:" + data, loader);
        }
    }

    private void piperackPort(XdmNode node) {
        String portno = node.getStringValue().trim();
        this.piperackPort = Integer.parseInt(portno);
    }

    private void piperackDefaultExpires(XdmNode node) {
        String secs = node.getStringValue().trim();
        this.piperackDefaultExpires = Integer.parseInt(secs);
    }

    private void piperackLoadPipeline(XdmNode node) {
        String uri = node.getStringValue().trim();
        String name = node.getAttributeValue(_name);
        int expires = -1;
        String s = node.getAttributeValue(_expires);
        if (s != null) {
            expires = Integer.parseInt(s);
        }
        if (name == null) {
            throw new XProcException(node, "You must specify a name for default pipelines.");
        }
        PipelineSource src = new PipelineSource(uri, name, expires);
        this.piperackDefaultPipelines.put(name, src);
    }

    private void parseInput(XdmNode node) {
        String port = node.getAttributeValue(_port);
        String href = node.getAttributeValue(_href);
        Vector<XdmValue> docnodes = new Vector<XdmValue>();
        boolean sawElement = false;
        for (XdmNode child : new AxisNodes(null, node, Axis.CHILD, 0)) {
            if (child.getNodeKind() == XdmNodeKind.ELEMENT) {
                if (sawElement) {
                    throw new XProcException(node, "Invalid configuration value for input '" + port + "': content is not a valid XML document.");
                }
                sawElement = true;
            }
            docnodes.add((XdmValue)child);
        }
        if (this.firstInput) {
            this.inputs.clear();
            this.firstInput = false;
        }
        if (!this.inputs.containsKey(port)) {
            this.inputs.put(port, new Vector());
        }
        Vector<ReadablePipe> documents = this.inputs.get(port);
        if (href != null) {
            if (docnodes.size() > 0) {
                throw new XProcException(node, "Invalid configuration value for input '" + port + "': href and content on input.");
            }
            documents.add(new ConfigDocument(href, node.getBaseURI().toASCIIString()));
        } else {
            HashSet<String> excludeURIs = S9apiUtils.excludeInlinePrefixes(node, node.getAttributeValue(_exclude_inline_prefixes));
            documents.add(new ConfigDocument(docnodes, excludeURIs));
        }
    }

    private void parsePipeline(XdmNode node) {
        String href = node.getAttributeValue(_href);
        Vector<XdmValue> docnodes = new Vector<XdmValue>();
        boolean sawElement = false;
        for (XdmNode child : new AxisNodes(null, node, Axis.CHILD, 31)) {
            if (child.getNodeKind() == XdmNodeKind.ELEMENT) {
                if (sawElement) {
                    throw new XProcException(node, "Content of pipeline is not a valid XML document.");
                }
                sawElement = true;
            }
            docnodes.add((XdmValue)child);
        }
        if (href != null) {
            if (docnodes.size() > 0) {
                throw new XProcException(node, "XProcConfiguration error: href and content on pipeline");
            }
            this.pipeline = new ConfigDocument(href, node.getBaseURI().toASCIIString());
        } else {
            HashSet<String> excludeURIs = S9apiUtils.excludeInlinePrefixes(node, node.getAttributeValue(_exclude_inline_prefixes));
            this.pipeline = new ConfigDocument(docnodes, excludeURIs);
        }
    }

    private void parseOutput(XdmNode node) {
        String port = node.getAttributeValue(_port);
        String href = node.getAttributeValue(_href);
        for (XdmNode child : new AxisNodes(null, node, Axis.CHILD, 31)) {
            if (child.getNodeKind() != XdmNodeKind.ELEMENT) continue;
            throw new XProcException(node, "Output must be empty.");
        }
        if (this.firstOutput) {
            this.outputs.clear();
            this.firstOutput = false;
        }
        if ("-".equals(href = node.getBaseURI().resolve(href).toASCIIString()) || href.startsWith("http:") || href.startsWith("https:") || href.startsWith("file:")) {
            this.outputs.put(port, href);
        } else {
            File f = new File(href);
            String fn = URIUtils.encode(f.getAbsolutePath());
            if ("\\".equals(System.getProperty("file.separator"))) {
                fn = "/" + fn;
            }
            this.outputs.put(port, "file://" + fn);
        }
    }

    private void parseWithOption(XdmNode node) {
        String nameStr = node.getAttributeValue(_name);
        String value = node.getAttributeValue(_value);
        QName name = new QName(nameStr, node);
        this.options.put(name, value);
    }

    private void parseWithParam(XdmNode node) {
        String port = node.getAttributeValue(_port);
        String nameStr = node.getAttributeValue(_name);
        String value = node.getAttributeValue(_value);
        QName name = new QName(nameStr, node);
        if (port == null) {
            port = "*";
        }
        Hashtable<QName, String> pvalues = this.params.containsKey(port) ? this.params.get(port) : new Hashtable<QName, String>();
        pvalues.put(name, value);
        this.params.put(port, pvalues);
    }

    private void parseSafeMode(XdmNode node) {
        String value = node.getStringValue().trim();
        this.safeMode = "true".equals(value);
        if (!"true".equals(value) && !"false".equals(value)) {
            throw new XProcException(node, "Unexpected configuration value for safe-mode: " + value);
        }
    }

    private void parseStepName(XdmNode node) {
        String value;
        this.stepName = value = node.getStringValue().trim();
    }

    private void parseURIResolver(XdmNode node) {
        String value;
        this.uriResolver = value = node.getAttributeValue(_class_name);
    }

    private void parseErrorListener(XdmNode node) {
        String value;
        this.errorListener = value = node.getAttributeValue(_class_name);
    }

    private void parseImplementation(XdmNode node) {
        String nameStr = node.getAttributeValue(_type);
        String value = node.getAttributeValue(_class_name);
        if (nameStr == null || value == null) {
            throw new XProcException(node, "Unexpected implementation in configuration; must have both type and class-name attributes");
        }
        for (String tname : nameStr.split("\\s+")) {
            QName name = new QName(tname, node);
            try {
                Class<?> klass = Class.forName(value);
                this.implementations.put(name, klass);
            }
            catch (ClassNotFoundException e) {
                this.logger.debug("Class not found: " + value);
            }
            catch (NoClassDefFoundError e) {
                String msg = e.getMessage();
                this.logger.debug("Cannot instantiate " + value + ", missing class: " + msg);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSerialization(XdmNode node) {
        String[] attributeNames = new String[]{"byte-order-mark", "cdata-section-elements", "doctype-public", "doctype-system", "encoding", "escape-uri-attributes", "include-content-type", "indent", "media-type", "method", "normalization-form", "omit-xml-declaration", "standalone", "undeclare-prefixes", "version"};
        this.checkAttributes(node, attributeNames, false);
        for (String name : attributeNames) {
            String value = node.getAttributeValue(new QName(name));
            if (value == null) continue;
            if ("byte-order-mark".equals(name) || "escape-uri-attributes".equals(name) || "include-content-type".equals(name) || "indent".equals(name) || "omit-xml-declaration".equals(name) || "undeclare-prefixes".equals(name)) {
                this.checkBoolean(node, name, value);
                this.serializationOptions.put(name, value);
            } else if ("method".equals(name)) {
                QName methodName = new QName(value, node);
                if (!"".equals(methodName.getPrefix())) throw new XProcException(node, "Configuration error: only the xml, xhtml, html, and text serialization methods are supported.");
                String method = methodName.getLocalName();
                if (!"html".equals(method) && !"xhtml".equals(method) && !"text".equals(method) && !"xml".equals(method)) throw new XProcException(node, "Configuration error: only the xml, xhtml, html, and text serialization methods are supported.");
                this.serializationOptions.put(name, method);
            } else {
                this.serializationOptions.put(name, value);
            }
            Iterator<XdmNode> iterator = new AxisNodes(null, node, Axis.CHILD, 31).iterator();
            if (!iterator.hasNext()) continue;
            XdmNode snode = iterator.next();
            throw new XProcException(node, "Configuration error: serialization must be empty");
        }
    }

    private HashSet<String> checkAttributes(XdmNode node, String[] attrs, boolean optionShortcutsOk) {
        HashSet<String> hash = null;
        if (attrs != null) {
            hash = new HashSet<String>();
            for (String attr : attrs) {
                hash.add(attr);
            }
        }
        HashSet<String> options = null;
        for (XdmNode attr : new AxisNodes(node, Axis.ATTRIBUTE)) {
            QName aname = attr.getNodeName();
            if ("".equals(aname.getNamespaceURI())) {
                if (hash.contains(aname.getLocalName())) continue;
                if (optionShortcutsOk) {
                    if (options == null) {
                        options = new HashSet<String>();
                    }
                    options.add(aname.getLocalName());
                    continue;
                }
                throw new XProcException(node, "Configuration error: attribute \"" + aname + "\" not allowed on " + node.getNodeName());
            }
            if (!"http://www.w3.org/ns/xproc".equals(aname.getNamespaceURI())) continue;
            throw new XProcException(node, "Configuration error: attribute \"" + aname + "\" not allowed on " + node.getNodeName());
        }
        return options;
    }

    private void checkBoolean(XdmNode node, String name, String value) {
        if (value != null && !"true".equals(value) && !"false".equals(value)) {
            throw new XProcException(node, "Configuration error: " + name + " on serialization must be 'true' or 'false'");
        }
    }

    private class ConfigDocument
    implements ReadablePipe {
        private String href = null;
        private String base = null;
        private Vector<XdmValue> nodes = null;
        private boolean read = false;
        private XdmNode doc = null;
        private HashSet<String> excludeUris = null;

        public ConfigDocument(String href, String base) {
            this.href = href;
            this.base = base;
        }

        public ConfigDocument(Vector<XdmValue> nodes, HashSet<String> excludeUris) {
            this.nodes = nodes;
            this.excludeUris = excludeUris;
        }

        @Override
        public void canReadSequence(boolean sequence) {
        }

        @Override
        public boolean readSequence() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public XdmNode read() throws SaxonApiException {
            this.read = true;
            if (this.doc != null) {
                return this.doc;
            }
            if (this.nodes != null) {
                XdmNode node = null;
                for (int pos = 0; pos < this.nodes.size() && node == null; ++pos) {
                    if (((XdmNode)this.nodes.get(pos)).getNodeKind() != XdmNodeKind.ELEMENT) continue;
                    node = (XdmNode)this.nodes.get(pos);
                }
                XdmDestination dest = new XdmDestination();
                try {
                    S9apiUtils.writeXdmValue(XProcConfiguration.this.cfgProcessor, this.nodes, (Destination)dest, node.getBaseURI());
                    this.doc = dest.getXdmNode();
                    if (this.excludeUris.size() == 0) return this.doc;
                    this.doc = S9apiUtils.removeNamespaces(XProcConfiguration.this.cfgProcessor, this.doc, this.excludeUris, true);
                    return this.doc;
                }
                catch (SaxonApiException sae) {
                    throw new XProcException(sae);
                }
            } else {
                this.doc = XProcConfiguration.this.readXML(this.href, this.base);
            }
            return this.doc;
        }

        @Override
        public void setReader(Step step) {
        }

        @Override
        public void setNames(String stepName, String portName) {
        }

        @Override
        public void resetReader() {
            this.read = false;
        }

        @Override
        public boolean moreDocuments() {
            return !this.read;
        }

        public boolean closed() {
            return false;
        }

        @Override
        public int documentCount() {
            return 1;
        }

        @Override
        public DocumentSequence documents() {
            throw new XProcException("You can't get the document sequence of an input from the config file!");
        }
    }
}

