/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.core;

import com.nwalsh.annotations.SaxonExtensionFunction;
import com.xmlcalabash.config.XProcConfigurer;
import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcMessageListener;
import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.functions.BaseURI;
import com.xmlcalabash.functions.Cwd;
import com.xmlcalabash.functions.IterationPosition;
import com.xmlcalabash.functions.IterationSize;
import com.xmlcalabash.functions.ResolveURI;
import com.xmlcalabash.functions.StepAvailable;
import com.xmlcalabash.functions.SystemProperty;
import com.xmlcalabash.functions.ValueAvailable;
import com.xmlcalabash.functions.VersionAvailable;
import com.xmlcalabash.functions.XPathVersionAvailable;
import com.xmlcalabash.functions.XProcExtensionFunctionDefinition;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.FallbackDataStore;
import com.xmlcalabash.io.FileDataStore;
import com.xmlcalabash.io.HttpClientDataStore;
import com.xmlcalabash.io.ReadableData;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.URLDataStore;
import com.xmlcalabash.model.DeclarationScope;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Parser;
import com.xmlcalabash.model.PipelineLibrary;
import com.xmlcalabash.runtime.XLibrary;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.runtime.XRootStep;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.DefaultXProcConfigurer;
import com.xmlcalabash.util.DefaultXProcMessageListener;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.Output;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.StepErrorListener;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.URIUtils;
import com.xmlcalabash.util.XProcSystemPropertySet;
import com.xmlcalabash.util.XProcURIResolver;
import com.xmlcalabash.util.XProcURIResolverX;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XProcRuntime
implements DeclarationScope {
    protected Logger logger = LoggerFactory.getLogger(XProcRuntime.class);
    private Processor processor = null;
    private Parser parser = null;
    private XProcURIResolver uriResolver = null;
    private XProcConfiguration config = null;
    private XProcException error = null;
    private Hashtable<QName, DeclareStep> declaredSteps = new Hashtable();
    private DeclareStep pipeline = null;
    private XPipeline xpipeline = null;
    private static String episode = null;
    private Hashtable<String, Vector<XdmNode>> collections = null;
    private URI staticBaseURI = null;
    private URI baseURI = null;
    private boolean allowGeneralExpressions = true;
    private boolean allowXPointerOnText = true;
    private boolean allowTextResults = true;
    private boolean allowSequenceAsContext = true;
    private boolean transparentJSON = false;
    private String jsonFlavor = "marklogic";
    private boolean useXslt10 = false;
    private boolean htmlSerializer = false;
    private XProcData xprocData = null;
    private XProcMessageListener msgListener = null;
    private PipelineLibrary standardLibrary = null;
    private HttpClient httpClient;
    private Map<String, CookieStore> cookieStores;
    private DataStore dataStore;
    private XProcConfigurer configurer = null;
    private String htmlParser = null;
    private Vector<XProcExtensionFunctionDefinition> exFuncs = new Vector();
    private Vector<XProcSystemPropertySet> systemPropertySets = new Vector();
    private Output profile = null;
    private Hashtable<XStep, Calendar> profileHash = null;
    private TreeWriter profileWriter = null;
    private QName profileProfile = new QName("http://xmlcalabash.com/ns/profile", "profile");
    private QName profileType = new QName("", "type");
    private QName profileName = new QName("", "name");
    private QName profileHref = new QName("", "href");
    private QName profileLine = new QName("", "line");
    private QName profileTime = new QName("http://xmlcalabash.com/ns/profile", "time");
    private String p_declare_step_clark = XProcConstants.p_declare_step.getClarkName();
    private String p_pipeline_clark = XProcConstants.p_pipeline.getClarkName();

    public XProcRuntime(XProcConfiguration config) {
        this.config = config;
        this.processor = config.getProcessor();
        if (config.xprocConfigurer != null) {
            try {
                String className = config.xprocConfigurer;
                Constructor<XProcConfigurer> constructor = Class.forName(className).asSubclass(XProcConfigurer.class).getConstructor(XProcRuntime.class);
                this.configurer = constructor.newInstance(this);
            }
            catch (Exception e) {
                throw new XProcException(e);
            }
        } else {
            this.configurer = new DefaultXProcConfigurer(this);
        }
        this.xprocData = new XProcData(this);
        this.exFuncs.add(new Cwd(this));
        this.exFuncs.add(new BaseURI(this));
        this.exFuncs.add(new ResolveURI(this));
        this.exFuncs.add(new SystemProperty(this));
        this.exFuncs.add(new StepAvailable(this));
        this.exFuncs.add(new IterationSize(this));
        this.exFuncs.add(new IterationPosition(this));
        this.exFuncs.add(new ValueAvailable(this));
        this.exFuncs.add(new VersionAvailable(this));
        this.exFuncs.add(new XPathVersionAvailable(this));
        for (XProcExtensionFunctionDefinition xf : this.exFuncs) {
            this.processor.registerExtensionFunction((ExtensionFunctionDefinition)xf);
        }
        Configuration saxonConfig = this.processor.getUnderlyingConfiguration();
        this.uriResolver = new XProcURIResolver(this);
        XProcURIResolverX saxonFakeStaticResolver = new XProcURIResolverX();
        String saxonFakeClassName = saxonFakeStaticResolver.getClass().getName();
        saxonFakeStaticResolver.setRealResolver(this.uriResolver);
        if (!config.setSaxonProperties.contains("http://saxon.sf.net/feature/entityResolverClass")) {
            saxonConfig.setConfigurationProperty("http://saxon.sf.net/feature/entityResolverClass", (Object)saxonFakeClassName);
        }
        if (!config.setSaxonProperties.contains("http://saxon.sf.net/feature/uriResolverClass")) {
            saxonConfig.setConfigurationProperty("http://saxon.sf.net/feature/uriResolverClass", (Object)saxonFakeClassName);
        }
        saxonConfig.setURIResolver((URIResolver)this.uriResolver);
        this.staticBaseURI = URIUtils.cwdAsURI();
        try {
            if (config.uriResolver != null) {
                this.uriResolver.setUnderlyingURIResolver(Class.forName(config.uriResolver).asSubclass(URIResolver.class).newInstance());
            }
            if (config.entityResolver != null) {
                this.uriResolver.setUnderlyingEntityResolver(Class.forName(config.entityResolver).asSubclass(EntityResolver.class).newInstance());
            }
            this.msgListener = config.errorListener != null ? Class.forName(config.errorListener).asSubclass(XProcMessageListener.class).newInstance() : new DefaultXProcMessageListener();
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
        if (config.catalogs.size() > 0) {
            this.uriResolver.addCatalogs(config.catalogs);
        }
        StepErrorListener errListener = new StepErrorListener(this);
        saxonConfig.setErrorListener((ErrorListener)errListener);
        this.allowGeneralExpressions = config.extensionValues;
        this.allowXPointerOnText = config.xpointerOnText;
        this.allowTextResults = config.allowTextResults;
        this.allowSequenceAsContext = config.sequenceAsContext;
        this.transparentJSON = config.transparentJSON;
        this.jsonFlavor = config.jsonFlavor;
        this.useXslt10 = config.useXslt10;
        this.htmlSerializer = config.htmlSerializer;
        if (config.profile != null) {
            this.profile = config.profile;
            this.profileHash = new Hashtable();
            this.profileWriter = new TreeWriter(this);
            this.profileWriter.startDocument(URI.create("http://xmlcalabash.com/output/profile.xml"));
        }
        String warnLevel = "INFO";
        for (String className : config.extensionFunctions.keySet()) {
            try {
                SaxonExtensionFunction annotation = config.extensionFunctions.get(className);
                if (annotation != null) {
                    warnLevel = annotation.warnLevel().toUpperCase();
                }
                Object def = Class.forName(className).newInstance();
                this.logger.trace("Instantiated: " + className);
                if (def instanceof ExtensionFunctionDefinition) {
                    this.processor.registerExtensionFunction((ExtensionFunctionDefinition)def);
                    continue;
                }
                if (def instanceof ExtensionFunction) {
                    this.processor.registerExtensionFunction((ExtensionFunction)def);
                    continue;
                }
                this.logger.info("Failed to instantiate extension function " + className + " because that class implements neither ExtensionFunction nor ExtensionFunctionDefinition.");
            }
            catch (Throwable e) {
                if ("INFO".equals(warnLevel)) {
                    this.logger.info("Failed to instantiate extension function: " + className);
                    continue;
                }
                if ("DEBUG".equals(warnLevel)) {
                    this.logger.debug("Failed to instantiate extension function: " + className);
                    continue;
                }
                if ("TRACE".equals(warnLevel)) {
                    this.logger.trace("Failed to instantiate extension function: " + className);
                    continue;
                }
                this.logger.error("Failed to instantiate extension function: " + className);
            }
        }
        this.htmlParser = config.htmlParser;
        this.addSystemPropertySet(XProcSystemPropertySet.BUILTIN);
        this.reset();
        this.initializeSteps();
    }

    public XProcRuntime(XProcRuntime runtime) {
        this.processor = runtime.processor;
        this.uriResolver = runtime.uriResolver;
        this.config = runtime.config;
        this.staticBaseURI = runtime.staticBaseURI;
        this.useXslt10 = runtime.useXslt10;
        this.htmlSerializer = runtime.htmlSerializer;
        this.msgListener = runtime.msgListener;
        this.standardLibrary = runtime.standardLibrary;
        this.httpClient = runtime.httpClient;
        this.cookieStores = runtime.cookieStores;
        this.configurer = runtime.configurer;
        this.allowGeneralExpressions = runtime.allowGeneralExpressions;
        this.allowXPointerOnText = runtime.allowXPointerOnText;
        this.allowSequenceAsContext = runtime.allowSequenceAsContext;
        this.transparentJSON = runtime.transparentJSON;
        this.jsonFlavor = runtime.jsonFlavor;
        this.profile = runtime.profile;
        this.exFuncs.add(new Cwd(this));
        this.exFuncs.add(new BaseURI(this));
        this.exFuncs.add(new ResolveURI(this));
        this.exFuncs.add(new SystemProperty(this));
        this.exFuncs.add(new StepAvailable(this));
        this.exFuncs.add(new IterationSize(this));
        this.exFuncs.add(new IterationPosition(this));
        this.exFuncs.add(new ValueAvailable(this));
        this.exFuncs.add(new VersionAvailable(this));
        this.exFuncs.add(new XPathVersionAvailable(this));
        for (XProcExtensionFunctionDefinition xf : this.exFuncs) {
            this.processor.registerExtensionFunction((ExtensionFunctionDefinition)xf);
        }
        this.reset();
        this.initializeSteps();
    }

    public void resetExtensionFunctions() {
        for (XProcExtensionFunctionDefinition xf : this.exFuncs) {
            this.processor.registerExtensionFunction((ExtensionFunctionDefinition)xf);
        }
    }

    private void initializeSteps() {
        for (Class klass : this.config.implementations.values()) {
            try {
                Method config = klass.getMethod("configureStep", XProcRuntime.class);
                config.invoke(null, this);
            }
            catch (NoSuchMethodException config) {
            }
            catch (IllegalAccessException config) {
            }
            catch (InvocationTargetException config) {
            }
            catch (Exception e) {
                System.err.println("Caught: " + e);
            }
        }
    }

    public void close() {
        HttpClientUtils.closeQuietly((HttpClient)this.httpClient);
        this.httpClient = null;
        if (this.exFuncs != null) {
            for (XProcExtensionFunctionDefinition xf : this.exFuncs) {
                xf.close();
            }
        }
        this.exFuncs = null;
    }

    public XProcConfigurer getConfigurer() {
        return this.configurer;
    }

    public void setConfigurer(XProcConfigurer configurer) {
        this.configurer = configurer;
    }

    public XProcData getXProcData() {
        return this.xprocData;
    }

    public boolean getDebug() {
        return this.config.debug;
    }

    public boolean getShowMessages() {
        return this.config.showMessages;
    }

    public Output getProfile() {
        return this.profile;
    }

    public void setProfile(Output profile) {
        this.profile = profile;
    }

    public URI getStaticBaseURI() {
        return this.staticBaseURI;
    }

    public void setStaticBaseURI(URI staticBaseURI) {
        this.staticBaseURI = staticBaseURI;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    public String getSendmailHost() {
        return this.config.mailHost;
    }

    public String getSendmailPort() {
        return this.config.mailPort;
    }

    public String getSendmailUsername() {
        return this.config.mailUser;
    }

    public String getSendmailPassword() {
        return this.config.mailPass;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver.setUnderlyingURIResolver(resolver);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.uriResolver.setUnderlyingEntityResolver(resolver);
    }

    public synchronized DataStore getDataStore() {
        if (this.dataStore == null) {
            DataStore fallback = new URLDataStore(new FallbackDataStore());
            if (!this.getSafeMode()) {
                fallback = new FileDataStore(fallback);
            }
            this.dataStore = new HttpClientDataStore(this.getHttpClient(), fallback);
        }
        return this.dataStore;
    }

    public synchronized void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public XProcURIResolver getResolver() {
        return this.uriResolver;
    }

    public XProcMessageListener getMessageListener() {
        return this.msgListener;
    }

    public void setMessageListener(XProcMessageListener listener) {
        this.msgListener = listener;
    }

    public void setCollection(URI href, Vector<XdmNode> docs) {
        if (this.collections == null) {
            this.collections = new Hashtable();
        }
        this.collections.put(href.toASCIIString(), docs);
    }

    public Vector<XdmNode> getCollection(URI href) {
        if (this.collections == null) {
            return null;
        }
        if (this.collections.containsKey(href.toASCIIString())) {
            return this.collections.get(href.toASCIIString());
        }
        return null;
    }

    public boolean getSafeMode() {
        return this.config.safeMode;
    }

    public boolean getAllowGeneralExpressions() {
        return this.allowGeneralExpressions;
    }

    public boolean getAllowXPointerOnText() {
        return this.allowXPointerOnText;
    }

    public boolean getAllowTextResults() {
        return this.allowTextResults;
    }

    public boolean getAllowSequenceAsContext() {
        return this.allowSequenceAsContext;
    }

    public boolean transparentJSON() {
        return this.transparentJSON;
    }

    public String jsonFlavor() {
        return this.jsonFlavor;
    }

    public String htmlParser() {
        return this.htmlParser;
    }

    public boolean getUseXslt10Processor() {
        return this.useXslt10;
    }

    public boolean getHtmlSerializer() {
        return this.htmlSerializer;
    }

    public void cache(XdmNode doc, URI baseURI) {
        this.uriResolver.cache(doc, baseURI);
    }

    public XProcConfiguration getConfiguration() {
        return this.config;
    }

    public Parser getParser() {
        return this.parser;
    }

    public String getEpisode() {
        if (episode == null) {
            MessageDigest digest = null;
            GregorianCalendar calendar = new GregorianCalendar();
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw XProcException.dynamicError(36);
            }
            byte[] hash = digest.digest(calendar.toString().getBytes());
            episode = "CB";
            for (byte b : hash) {
                episode = episode + Integer.toHexString(b & 0xFF);
            }
        }
        return episode;
    }

    public String getLanguage() {
        return Locale.getDefault().toString().replace('_', '-');
    }

    public String getProductName() {
        return "XML Calabash";
    }

    public String getProductVersion() {
        String sver = this.processor.getSaxonProductVersion();
        String sed = this.processor.getUnderlyingConfiguration().getEditionCode();
        return XProcConstants.XPROC_VERSION + " (for Saxon " + sver + "/" + sed + ")";
    }

    public String getVendor() {
        return "Norman Walsh";
    }

    public String getVendorURI() {
        return "http://xmlcalabash.com/";
    }

    public String getXProcVersion() {
        return "1.0";
    }

    public String getXPathVersion() {
        return "2.0";
    }

    public boolean getPSVISupported() {
        return this.config.schemaAware;
    }

    private synchronized void reset() {
        this.error = null;
        this.declaredSteps = new Hashtable();
        this.pipeline = null;
        this.xpipeline = null;
        episode = null;
        this.collections = null;
        this.cookieStores = new HashMap<String, CookieStore>();
        this.xprocData = new XProcData(this);
        this.parser = new Parser(this);
        try {
            this.standardLibrary = this.parser.loadStandardLibrary();
            if (this.error != null) {
                throw this.error.copy();
            }
        }
        catch (FileNotFoundException ex) {
            throw XProcException.dynamicError(9, ex);
        }
        catch (URISyntaxException ex) {
            throw XProcException.dynamicError(9, ex);
        }
        catch (SaxonApiException ex) {
            throw XProcException.dynamicError(9, ex);
        }
        if (this.profile != null) {
            this.profileHash = new Hashtable();
            this.profileWriter = new TreeWriter(this);
            this.profileWriter.startDocument(URI.create("http://xmlcalabash.com/output/profile.xml"));
        }
    }

    public PipelineLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    public XPipeline load(Input pipeline) throws SaxonApiException {
        String uri;
        switch (pipeline.getKind()) {
            case URI: {
                uri = pipeline.getUri();
                break;
            }
            case INPUT_STREAM: {
                uri = pipeline.getInputStreamUri();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported pipeline kind '%s'", new Object[]{pipeline.getKind()}));
            }
        }
        for (String map : this.config.loaders.keySet()) {
            boolean data = map.startsWith("data:");
            String pattern = map.substring(5);
            if (!uri.matches(pattern)) continue;
            return this.runPipelineLoader(pipeline, this.config.loaders.get(map), data);
        }
        try {
            return this._load(pipeline);
        }
        catch (SaxonApiException sae) {
            this.error(sae);
            throw sae;
        }
        catch (XProcException xe) {
            this.error(xe);
            throw xe;
        }
        catch (IOException ioe) {
            this.error(ioe);
            throw new XProcException(ioe);
        }
    }

    private XPipeline _load(Input pipelineInput) throws SaxonApiException, IOException {
        this.reset();
        this.configurer.getXMLCalabashConfigurer().configRuntime(this);
        switch (pipelineInput.getKind()) {
            case URI: {
                if (this.baseURI == null) {
                    this.pipeline = this.parser.loadPipeline(pipelineInput.getUri());
                    break;
                }
                this.pipeline = this.parser.loadPipeline(pipelineInput.getUri(), this.baseURI.toASCIIString());
                break;
            }
            case INPUT_STREAM: {
                this.pipeline = this.parser.loadPipeline(pipelineInput.getInputStream(), pipelineInput.getInputStreamUri());
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported pipeline kind '%s'", new Object[]{pipelineInput.getKind()}));
            }
        }
        if (this.error != null) {
            throw this.error.copy();
        }
        XRootStep root = new XRootStep(this);
        DeclareStep decl = this.pipeline.getDeclaration();
        decl.setup();
        if (this.error != null) {
            throw this.error.copy();
        }
        this.xpipeline = new XPipeline(this, this.pipeline, root);
        this.xpipeline.instantiate(decl);
        if (this.error != null) {
            throw this.error.copy();
        }
        return this.xpipeline;
    }

    public XPipeline use(XdmNode p_pipeline) throws SaxonApiException {
        try {
            return this._use(p_pipeline);
        }
        catch (SaxonApiException sae) {
            this.error(sae);
            throw sae;
        }
        catch (XProcException xe) {
            this.error(xe);
            throw xe;
        }
    }

    private XPipeline _use(XdmNode p_pipeline) throws SaxonApiException {
        this.reset();
        this.configurer.getXMLCalabashConfigurer().configRuntime(this);
        this.pipeline = this.parser.usePipeline(p_pipeline);
        if (this.error != null) {
            throw this.error.copy();
        }
        XRootStep root = new XRootStep(this);
        DeclareStep decl = this.pipeline.getDeclaration();
        decl.setup();
        if (this.error != null) {
            throw this.error.copy();
        }
        this.xpipeline = new XPipeline(this, this.pipeline, root);
        this.xpipeline.instantiate(decl);
        if (this.error != null) {
            throw this.error.copy();
        }
        return this.xpipeline;
    }

    public XLibrary loadLibrary(Input library) throws SaxonApiException {
        String libraryURI;
        switch (library.getKind()) {
            case URI: {
                libraryURI = library.getUri();
                break;
            }
            case INPUT_STREAM: {
                libraryURI = library.getInputStreamUri();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported library kind '%s'", new Object[]{library.getKind()}));
            }
        }
        for (String map : this.config.loaders.keySet()) {
            boolean data = map.startsWith("data:");
            String pattern = map.substring(5);
            if (!libraryURI.matches(pattern)) continue;
            return this.runLibraryLoader(library, this.config.loaders.get(map), data);
        }
        try {
            return this._loadLibrary(library);
        }
        catch (SaxonApiException sae) {
            this.error(sae);
            throw sae;
        }
        catch (XProcException xe) {
            this.error(xe);
            throw xe;
        }
        catch (IOException ioe) {
            this.error(ioe);
            throw new XProcException(ioe);
        }
    }

    private XLibrary _loadLibrary(Input library) throws SaxonApiException, IOException {
        PipelineLibrary plibrary;
        switch (library.getKind()) {
            case URI: {
                plibrary = this.parser.loadLibrary(library.getUri());
                break;
            }
            case INPUT_STREAM: {
                plibrary = this.parser.loadLibrary(library.getInputStream(), library.getInputStreamUri());
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported library kind '%s'", new Object[]{library.getKind()}));
            }
        }
        if (this.error != null) {
            throw this.error.copy();
        }
        XLibrary xlibrary = new XLibrary(this, plibrary);
        if (this.error != null) {
            throw this.error.copy();
        }
        return xlibrary;
    }

    public XLibrary useLibrary(XdmNode library) throws SaxonApiException {
        try {
            return this._useLibrary(library);
        }
        catch (SaxonApiException sae) {
            this.error(sae);
            throw sae;
        }
        catch (XProcException xe) {
            this.error(xe);
            throw xe;
        }
    }

    private XLibrary _useLibrary(XdmNode library) throws SaxonApiException {
        PipelineLibrary plibrary = this.parser.useLibrary(library);
        if (this.error != null) {
            throw this.error.copy();
        }
        XLibrary xlibrary = new XLibrary(this, plibrary);
        if (this.error != null) {
            throw this.error.copy();
        }
        return xlibrary;
    }

    private XPipeline runPipelineLoader(Input pipeline, String loaderURI, boolean data) throws SaxonApiException {
        XdmNode pipeDoc = this.runLoader(pipeline, loaderURI, data);
        return this.use(pipeDoc);
    }

    private XLibrary runLibraryLoader(Input library, String loaderURI, boolean data) throws SaxonApiException {
        XdmNode libDoc = this.runLoader(library, loaderURI, data);
        return this.useLibrary(libDoc);
    }

    private XdmNode runLoader(Input pipeline, String loaderURI, boolean data) throws SaxonApiException {
        XPipeline loader = null;
        try {
            loader = this._load(new Input(loaderURI));
        }
        catch (SaxonApiException sae) {
            this.error(sae);
            throw sae;
        }
        catch (XProcException xe) {
            this.error(xe);
            throw xe;
        }
        catch (IOException ioe) {
            this.error(ioe);
            throw new XProcException(ioe);
        }
        XdmNode pipeDoc = null;
        switch (pipeline.getKind()) {
            case URI: {
                ReadableData rdata;
                if (data) {
                    rdata = new ReadableData(this, XProcConstants.c_result, this.getStaticBaseURI().resolve(pipeline.getUri()).toASCIIString(), "text/plain");
                    pipeDoc = rdata.read();
                    break;
                }
                pipeDoc = this.parse(pipeline.getUri(), this.getStaticBaseURI().toASCIIString());
                break;
            }
            case INPUT_STREAM: {
                ReadableData rdata;
                if (data) {
                    rdata = new ReadableData(this, XProcConstants.c_result, pipeline.getInputStream(), "text/plain");
                    pipeDoc = rdata.read();
                    break;
                }
                pipeDoc = this.parse(new InputSource(pipeline.getInputStream()));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported pipeline kind '%s'", new Object[]{pipeline.getKind()}));
            }
        }
        loader.clearInputs("source");
        loader.writeTo("source", pipeDoc);
        loader.run();
        ReadablePipe xformed = loader.readFrom("result");
        pipeDoc = xformed.read();
        this.reset();
        return pipeDoc;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public XdmNode parse(String uri, String base) {
        return this.parse(uri, base, false);
    }

    public XdmNode parse(String uri, String base, boolean validate) {
        return this.uriResolver.parse(uri, base, validate);
    }

    public XdmNode parse(InputSource isource) {
        return this.uriResolver.parse(isource);
    }

    @Override
    public void declareStep(QName name, DeclareStep step) {
        DeclareStep d = this.getDeclaration(name);
        if (d != null) {
            if (!d.equals(step)) {
                throw new XProcException(step, "Duplicate step type: " + name);
            }
        } else {
            this.declaredSteps.put(name, step);
        }
    }

    @Override
    public DeclareStep getDeclaration(QName type) {
        DeclareStep d;
        DeclareStep decl = null;
        if (this.standardLibrary != null) {
            decl = this.standardLibrary.getDeclaration(type);
        }
        if ((d = this.declaredSteps.get(type)) != null) {
            if (decl == null) {
                decl = d;
            } else {
                throw new XProcException(d, "Duplicate step type: " + type);
            }
        }
        return decl;
    }

    @Override
    public Set<QName> getInScopeTypes() {
        HashSet<QName> decls = new HashSet<QName>();
        decls.addAll(this.declaredSteps.keySet());
        if (this.standardLibrary != null) {
            decls.addAll(this.standardLibrary.getInScopeTypes());
        }
        return decls;
    }

    public synchronized CookieStore getCookieStore(String key) {
        if (this.cookieStores.containsKey(key)) {
            return this.cookieStores.get(key);
        }
        BasicCookieStore cookieStore = new BasicCookieStore();
        this.cookieStores.put(key, (CookieStore)cookieStore);
        return cookieStore;
    }

    public synchronized void setCookieStore(String key, CookieStore cookieStore) {
        if (cookieStore == null) {
            this.removeCookieStore(key);
        } else {
            this.cookieStores.put(key, cookieStore);
        }
    }

    public synchronized void removeCookieStore(String key) {
        this.cookieStores.remove(key);
    }

    public synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            HttpClientBuilder builder = HttpClientBuilder.create();
            builder.setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(3, false));
            this.httpClient = builder.build();
            return this.httpClient;
        }
        return this.httpClient;
    }

    public synchronized void setHttpClient(HttpClient client) {
        this.httpClient = client;
    }

    public XProcException getError() {
        return this.error;
    }

    public void error(XProcRunnable step, XProcException error) {
        if (this.error == null) {
            this.error = error;
        }
        this.msgListener.error(step, error);
    }

    public void error(Throwable error) {
        this.msgListener.error(error);
    }

    public void warning(XProcRunnable step, XdmNode location, String message) {
        this.msgListener.warning(step, location, message);
    }

    public void warning(Throwable error) {
        this.msgListener.warning(error);
    }

    public void info(XProcRunnable step, XdmNode location, String message) {
        this.msgListener.info(step, location, message);
    }

    public void start(XStep step) {
        String name;
        if (this.profile == null) {
            return;
        }
        boolean first = this.profileHash.isEmpty();
        Calendar start = GregorianCalendar.getInstance();
        this.profileHash.put(step, start);
        this.profileWriter.addStartElement(this.profileProfile);
        if (first) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.profileWriter.addAttribute(new QName("", "timestamp"), df.format(new Date()));
            this.profileWriter.addAttribute(new QName("", "episode"), this.getEpisode());
            this.profileWriter.addAttribute(new QName("", "language"), this.getLanguage());
            this.profileWriter.addAttribute(new QName("", "product-name"), this.getProductName());
            this.profileWriter.addAttribute(new QName("", "product-version"), this.getProductVersion());
            this.profileWriter.addAttribute(new QName("", "product-vendor"), this.getVendor());
            this.profileWriter.addAttribute(new QName("", "product-vendor-uri"), this.getVendorURI());
            this.profileWriter.addAttribute(new QName("", "xproc-version"), this.getXProcVersion());
            this.profileWriter.addAttribute(new QName("", "xpath-version"), this.getXPathVersion());
            this.profileWriter.addAttribute(new QName("", "psvi-supported"), "" + this.getPSVISupported());
        }
        if ((this.p_declare_step_clark.equals(name = step.getType().getClarkName()) || this.p_pipeline_clark.equals(name)) && step.getType() != null && step.getStep().getDeclaredType() != null) {
            this.profileWriter.addAttribute(this.profileType, step.getStep().getDeclaredType().getClarkName());
        } else {
            this.profileWriter.addAttribute(this.profileType, name);
        }
        this.profileWriter.addAttribute(this.profileName, step.getStep().getName());
        if (step.getStep().getNode() != null) {
            this.profileWriter.addAttribute(this.profileHref, step.getStep().xplFile());
            this.profileWriter.addAttribute(this.profileLine, "" + step.getStep().xplLine());
        }
        this.profileWriter.startContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(XStep step) {
        if (this.profile == null) {
            return;
        }
        Calendar start = this.profileHash.get(step);
        long time = GregorianCalendar.getInstance().getTimeInMillis() - start.getTimeInMillis();
        this.profileHash.remove(step);
        this.profileWriter.addStartElement(this.profileTime);
        this.profileWriter.startContent();
        this.profileWriter.addText("" + time);
        this.profileWriter.addEndElement();
        this.profileWriter.addEndElement();
        if (this.profileHash.isEmpty()) {
            this.profileWriter.endDocument();
            XdmNode profile = this.profileWriter.getResult();
            InputStream xsl = this.getClass().getResourceAsStream("/etc/patch-profile.xsl");
            if (xsl == null) {
                throw new UnsupportedOperationException("Failed to load profile_patch.xsl from JAR file.");
            }
            try {
                XsltCompiler compiler = this.getProcessor().newXsltCompiler();
                compiler.setSchemaAware(false);
                XsltExecutable exec = compiler.compile((Source)new SAXSource(new InputSource(xsl)));
                XsltTransformer transformer = exec.load();
                transformer.setInitialContextNode(profile);
                XdmDestination result = new XdmDestination();
                transformer.setDestination((Destination)result);
                transformer.transform();
                Serializer serializer = this.getProcessor().newSerializer();
                serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
                OutputStream outstr = null;
                try {
                    switch (this.profile.getKind()) {
                        case URI: {
                            URI furi = URI.create(this.profile.getUri());
                            outstr = new FileOutputStream(new File(furi));
                            break;
                        }
                        case OUTPUT_STREAM: {
                            outstr = this.profile.getOutputStream();
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(String.format("Unsupported profile kind '%s'", new Object[]{this.profile.getKind()}));
                        }
                    }
                    serializer.setOutputStream(outstr);
                    S9apiUtils.serialize(this, result.getXdmNode(), serializer);
                }
                finally {
                    if (!System.out.equals(outstr) && !System.err.equals(outstr)) {
                        outstr.close();
                    }
                }
                this.profileWriter = new TreeWriter(this);
                this.profileWriter.startDocument(URI.create("http://xmlcalabash.com/output/profile.xml"));
            }
            catch (SaxonApiException sae) {
                throw new XProcException(sae);
            }
            catch (FileNotFoundException fnfe) {
                throw new XProcException(fnfe);
            }
            catch (IOException ioe) {
                throw new XProcException(ioe);
            }
        }
    }

    public void addSystemPropertySet(XProcSystemPropertySet systemPropertySet) {
        this.systemPropertySets.add(systemPropertySet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSystemProperty(QName propertyName) throws XProcException {
        Vector<XProcSystemPropertySet> vector = this.systemPropertySets;
        synchronized (vector) {
            for (XProcSystemPropertySet propSet : this.systemPropertySets) {
                String value = propSet.systemProperty(this, propertyName);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }
}

