/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.drivers;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadableData;
import com.xmlcalabash.io.WritableDocument;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.util.Closer;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.Output;
import com.xmlcalabash.util.ParseArgs;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.UserArgs;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class Main {
    private static QName _code = new QName("code");
    private static int exitStatus = 0;
    private XProcRuntime runtime = null;
    private Logger logger = LoggerFactory.getLogger(Main.class);
    private boolean debug = false;
    private int chaseMemoryLeaks = 0;

    public static void main(String[] args) throws IOException {
        Main main = new Main();
        main.run(args);
        if (exitStatus != 0) {
            System.exit(exitStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) throws IOException {
        UserArgs userArgs = null;
        try {
            userArgs = new ParseArgs().parse(args);
        }
        catch (XProcException xe) {
            System.err.println(xe.getMessage());
            this.usage();
        }
        try {
            XProcConfiguration config = userArgs.createConfiguration();
            this.runtime = new XProcRuntime(config);
            this.debug = config.debug;
            if (this.chaseMemoryLeaks != 0) {
                while (this.chaseMemoryLeaks > 0) {
                    System.err.println("Checking for memory leaks, running " + this.chaseMemoryLeaks);
                    this.run(userArgs, config);
                    --this.chaseMemoryLeaks;
                }
            } else if (this.run(userArgs, config)) {
                System.out.println();
            }
        }
        catch (UnsupportedOperationException uoe) {
            this.usage();
        }
        catch (XProcException err) {
            Throwable cause;
            exitStatus = 1;
            if (err.getErrorCode() != null) {
                this.logger.error(this.errorMessage(err.getErrorCode()));
            } else {
                this.logger.error(err.getMessage());
            }
            for (cause = err.getCause(); cause != null && cause instanceof XProcException; cause = cause.getCause()) {
            }
            if (cause != null) {
                this.logger.error("Underlying exception: " + cause.getMessage());
            }
            this.logger.debug(err.getMessage(), (Throwable)err);
        }
        catch (Exception err) {
            exitStatus = 1;
            this.logger.error("Pipeline failed: " + err.getMessage());
            if (err.getCause() != null) {
                Throwable cause = err.getCause();
                this.logger.error("Underlying exception: " + cause.getMessage());
            }
            this.logger.debug(err.getMessage(), (Throwable)err);
        }
        finally {
            if (this.runtime != null) {
                this.runtime.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMethod(String[] args) throws IOException, SaxonApiException, URISyntaxException {
        UserArgs userArgs = new ParseArgs().parse(args);
        XProcConfiguration config = userArgs.createConfiguration();
        this.runtime = new XProcRuntime(config);
        this.debug = config.debug;
        try {
            this.run(userArgs, config);
        }
        finally {
            if (this.runtime != null) {
                this.runtime.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean run(UserArgs userArgs, XProcConfiguration config) throws SaxonApiException, IOException, URISyntaxException {
        block93: {
            if (userArgs.isShowVersion()) {
                XProcConfiguration.showVersion(this.runtime);
            }
            pipeline = null;
            if (userArgs.getPipeline() != null) {
                pipeline = this.runtime.load(userArgs.getPipeline());
            } else if (userArgs.hasImplicitPipeline()) {
                implicitPipeline = userArgs.getImplicitPipeline(this.runtime);
                if (this.debug) {
                    System.err.println("Implicit pipeline:");
                    serializer = this.runtime.getProcessor().newSerializer();
                    serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
                    serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
                    serializer.setOutputStream((OutputStream)System.err);
                    S9apiUtils.serialize(this.runtime, implicitPipeline, serializer);
                }
                pipeline = this.runtime.use(implicitPipeline);
            } else {
                if (config.pipeline == null) {
                    throw new UnsupportedOperationException("Either a pipeline or libraries and / or steps must be given");
                }
                doc = config.pipeline.read();
                pipeline = this.runtime.use(doc);
            }
            for (String port : config.params.keySet()) {
                parameters = (Map<QName, String>)config.params.get(port);
                this.setParametersOnPipeline(pipeline, port, parameters);
            }
            for (String port : userArgs.getParameterPorts()) {
                parameters = userArgs.getParameters(port);
                this.setParametersOnPipeline(pipeline, port, parameters);
            }
            ports = pipeline.getInputs();
            userArgsInputPorts = userArgs.getInputPorts();
            cfgInputPorts = config.inputs.keySet();
            allPorts = new HashSet<Object>();
            allPorts.addAll(userArgsInputPorts);
            allPorts.addAll(cfgInputPorts);
            for (Object port : ports) {
                if (allPorts.contains(port) || !allPorts.contains(null) || !pipeline.getDeclareStep().getInput((String)port).getPrimary() || pipeline.getDeclareStep().getInput((String)port).getParameterInput()) continue;
                if (!userArgsInputPorts.contains(null)) break;
                userArgs.setDefaultInputPort((String)port);
                allPorts.remove(null);
                allPorts.add(port);
                break;
            }
            var8_8 = allPorts.iterator();
            block32: while (true) {
                if (var8_8.hasNext()) {
                    port = var8_8.next();
                    if (!ports.contains(port)) {
                        throw new XProcException("There is a binding for the port '" + (String)port + "' but the pipeline declares no such port.");
                    }
                    pipeline.clearInputs((String)port);
                    if (!userArgsInputPorts.contains(port)) {
                        doc = config.inputs.get(port).iterator();
                        while (true) {
                            if (!doc.hasNext()) continue block32;
                            pipe = doc.next();
                            doc = pipe.read();
                            pipeline.writeTo((String)port, doc);
                        }
                    }
                } else {
                    implicitPort = null;
                    for (String port : ports) {
                        if (allPorts.contains(port) || !pipeline.getDeclareStep().getInput(port).getPrimary() || pipeline.getDeclareStep().getInput(port).getParameterInput()) continue;
                        implicitPort = port;
                    }
                    if (implicitPort != null && !pipeline.hasReadablePipes(implicitPort)) {
                        doc = this.runtime.parse(new InputSource(System.in));
                        pipeline.writeTo(implicitPort, doc);
                    }
                    portOutputs = new HashMap<String, Output>();
                    userArgsOutputs = userArgs.getOutputs();
                    var11_11 = pipeline.getOutputs().iterator();
                    break block93;
                }
                doc = null;
                var11_11 = userArgs.getInputs((String)port).iterator();
                block35: while (true) {
                    if (!var11_11.hasNext()) ** break;
                    input = (Input)var11_11.next();
                    switch (1.$SwitchMap$com$xmlcalabash$util$Input$Type[input.getType().ordinal()]) {
                        case 1: {
                            switch (1.$SwitchMap$com$xmlcalabash$util$Input$Kind[input.getKind().ordinal()]) {
                                case 1: {
                                    uri = input.getUri();
                                    doc = "-".equals(uri) ? this.runtime.parse(new InputSource(System.in)) : this.runtime.parse(new InputSource(uri));
                                    ** GOTO lbl114
                                }
                                case 2: {
                                    inputStream = input.getInputStream();
                                    try {
                                        doc = this.runtime.parse(new InputSource(inputStream));
                                        ** GOTO lbl114
                                    }
                                    finally {
                                        Closer.close(inputStream);
                                    }
                                }
                                default: {
                                    throw new UnsupportedOperationException(String.format("Unsupported input kind '%s'", new Object[]{input.getKind()}));
                                }
                            }
                        }
                        case 2: {
                            switch (1.$SwitchMap$com$xmlcalabash$util$Input$Kind[input.getKind().ordinal()]) {
                                case 1: {
                                    rd = new ReadableData(this.runtime, XProcConstants.c_data, input.getUri(), input.getContentType());
                                    doc = rd.read();
                                    break;
                                }
                                case 2: {
                                    inputStream = input.getInputStream();
                                    try {
                                        rd = new ReadableData(this.runtime, XProcConstants.c_data, inputStream, input.getContentType());
                                        doc = rd.read();
                                        break;
                                    }
                                    finally {
                                        Closer.close(inputStream);
                                    }
                                }
                                default: {
                                    throw new UnsupportedOperationException(String.format("Unsupported input kind '%s'", new Object[]{input.getKind()}));
                                }
                            }
lbl114:
                            // 4 sources

                            pipeline.writeTo((String)port, doc);
                            continue block35;
                        }
                    }
                    break;
                }
                break;
            }
            throw new UnsupportedOperationException(String.format("Unsupported input type '%s'", new Object[]{input.getType()}));
        }
        while (var11_11.hasNext()) {
            port = (String)var11_11.next();
            output = null;
            if (userArgsOutputs.containsKey(port)) {
                output = userArgsOutputs.get(port);
            } else if (config.outputs.containsKey(port)) {
                output = new Output(config.outputs.get(port));
            } else if (userArgsOutputs.containsKey(null) && pipeline.getDeclareStep().getOutput(port).getPrimary()) {
                output = userArgsOutputs.get(null);
            }
            if (output != null && output.getKind() == Output.Kind.URI && "-".equals(output.getUri())) {
                output = null;
            }
            portOutputs.put(port, output);
        }
        for (QName optname : config.options.keySet()) {
            value = new RuntimeValue(config.options.get(optname), null, null);
            pipeline.passOption(optname, value);
        }
        for (QName optname : userArgs.getOptionNames()) {
            value = new RuntimeValue(userArgs.getOption(optname), null, null);
            pipeline.passOption(optname, value);
        }
        pipeline.run();
        var11_11 = pipeline.getOutputs().iterator();
        block39: while (true) {
            if (!var11_11.hasNext()) {
                return portOutputs.containsValue(null);
            }
            port = (String)var11_11.next();
            if (!portOutputs.containsKey(port)) continue;
            output = (Output)portOutputs.get(port);
            if (output == null || output.getKind() == Output.Kind.OUTPUT_STREAM && System.out.equals(output.getOutputStream())) {
                this.logger.trace("Copy output from " + port + " to stdout");
            } else {
                switch (1.$SwitchMap$com$xmlcalabash$util$Output$Kind[output.getKind().ordinal()]) {
                    case 1: {
                        this.logger.trace("Copy output from " + port + " to " + output.getUri());
                        break;
                    }
                    case 2: {
                        outputStreamClassName = output.getOutputStream().getClass().getName();
                        this.logger.trace("Copy output from " + port + " to " + outputStreamClassName + " stream");
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unsupported output kind '%s'", new Object[]{output.getKind()}));
                    }
                }
            }
            serial = pipeline.getSerialization(port);
            if (serial == null) {
                serial = new Serialization(this.runtime, pipeline.getNode());
                for (String name : config.serializationOptions.keySet()) {
                    value = config.serializationOptions.get(name);
                    if ("byte-order-mark".equals(name)) {
                        serial.setByteOrderMark("true".equals(value));
                    }
                    if ("escape-uri-attributes".equals(name)) {
                        serial.setEscapeURIAttributes("true".equals(value));
                    }
                    if ("include-content-type".equals(name)) {
                        serial.setIncludeContentType("true".equals(value));
                    }
                    if ("indent".equals(name)) {
                        serial.setIndent("true".equals(value));
                    }
                    if ("omit-xml-declaration".equals(name)) {
                        serial.setOmitXMLDeclaration("true".equals(value));
                    }
                    if ("undeclare-prefixes".equals(name)) {
                        serial.setUndeclarePrefixes("true".equals(value));
                    }
                    if ("method".equals(name)) {
                        serial.setMethod(new QName("", value));
                    }
                    if ("doctype-public".equals(name)) {
                        serial.setDoctypePublic(value);
                    }
                    if ("doctype-system".equals(name)) {
                        serial.setDoctypeSystem(value);
                    }
                    if ("encoding".equals(name)) {
                        serial.setEncoding(value);
                    }
                    if ("media-type".equals(name)) {
                        serial.setMediaType(value);
                    }
                    if ("normalization-form".equals(name)) {
                        serial.setNormalizationForm(value);
                    }
                    if ("standalone".equals(name)) {
                        serial.setStandalone(value);
                    }
                    if (!"version".equals(name)) continue;
                    serial.setVersion(value);
                }
            }
            for (String name : new String[]{"byte-order-mark", "escape-uri-attributes", "include-content-type", "indent", "omit-xml-declaration", "undeclare-prefixes", "method", "doctype-public", "doctype-system", "encoding", "media-type", "normalization-form", "standalone", "version"}) {
                value = userArgs.getSerializationParameter(port, name);
                if (value == null && (value = userArgs.getSerializationParameter(name)) == null) continue;
                if ("byte-order-mark".equals(name)) {
                    serial.setByteOrderMark("true".equals(value));
                }
                if ("escape-uri-attributes".equals(name)) {
                    serial.setEscapeURIAttributes("true".equals(value));
                }
                if ("include-content-type".equals(name)) {
                    serial.setIncludeContentType("true".equals(value));
                }
                if ("indent".equals(name)) {
                    serial.setIndent("true".equals(value));
                }
                if ("omit-xml-declaration".equals(name)) {
                    serial.setOmitXMLDeclaration("true".equals(value));
                }
                if ("undeclare-prefixes".equals(name)) {
                    serial.setUndeclarePrefixes("true".equals(value));
                }
                if ("method".equals(name)) {
                    serial.setMethod(new QName("", value));
                }
                if ("doctype-public".equals(name)) {
                    serial.setDoctypePublic(value);
                }
                if ("doctype-system".equals(name)) {
                    serial.setDoctypeSystem(value);
                }
                if ("encoding".equals(name)) {
                    serial.setEncoding(value);
                }
                if ("media-type".equals(name)) {
                    serial.setMediaType(value);
                }
                if ("normalization-form".equals(name)) {
                    serial.setNormalizationForm(value);
                }
                if ("standalone".equals(name)) {
                    serial.setStandalone(value);
                }
                if (!"version".equals(name)) continue;
                serial.setVersion(value);
            }
            wd = null;
            if (output == null) {
                wd = new WritableDocument(this.runtime, null, serial);
            } else {
                switch (1.$SwitchMap$com$xmlcalabash$util$Output$Kind[output.getKind().ordinal()]) {
                    case 1: {
                        furi = new URI(output.getUri());
                        filename = furi.getPath();
                        outfile = new FileOutputStream(filename);
                        wd = new WritableDocument(this.runtime, filename, serial, outfile);
                        break;
                    }
                    case 2: {
                        outputStream = output.getOutputStream();
                        wd = new WritableDocument(this.runtime, null, serial, outputStream);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unsupported output kind '%s'", new Object[]{output.getKind()}));
                    }
                }
            }
            try {
                rpipe = pipeline.readFrom(port);
                while (true) {
                    if (!rpipe.moreDocuments()) continue block39;
                    wd.write(rpipe.read());
                }
            }
            finally {
                if (output == null) continue;
                wd.close();
                continue;
            }
            break;
        }
    }

    private void setParametersOnPipeline(XPipeline pipeline, String port, Map<QName, String> parameters) {
        if ("*".equals(port)) {
            for (QName name : parameters.keySet()) {
                pipeline.setParameter(name, new RuntimeValue(parameters.get(name)));
            }
        } else {
            for (QName name : parameters.keySet()) {
                pipeline.setParameter(port, name, new RuntimeValue(parameters.get(name)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usage() throws IOException {
        System.out.println();
        XProcConfiguration.showVersion(this.runtime);
        InputStream instream = this.getClass().getResourceAsStream("/etc/usage.txt");
        if (instream == null) {
            throw new UnsupportedOperationException("Failed to load usage text from JAR file. This \"can't happen\".");
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(instream));){
            String line = null;
            while ((line = br.readLine()) != null) {
                System.err.println(line);
            }
        }
        System.exit(1);
    }

    private String errorMessage(QName code) {
        InputStream instream = this.getClass().getResourceAsStream("/etc/error-list.xml");
        if (instream != null) {
            XdmNode doc = this.runtime.parse(new InputSource(instream));
            XdmSequenceIterator iter = doc.axisIterator(Axis.DESCENDANT, new QName("http://www.w3.org/ns/xproc-error", "error"));
            while (iter.hasNext()) {
                XdmNode error = (XdmNode)iter.next();
                if (!code.getLocalName().equals(error.getAttributeValue(_code))) continue;
                return error.getStringValue();
            }
        }
        return "Unknown error";
    }
}

