/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import java.net.URI;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

@XMLCalabash(name="cx:collection-manager", type="{http://xmlcalabash.com/ns/extensions}collection-manager")
public class CollectionManager
extends DefaultStep {
    private static final QName _href = new QName("", "href");
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public CollectionManager(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        URI href = this.step.getNode().getBaseURI().resolve(this.getOption(_href).getString());
        Vector<XdmNode> collection = new Vector<XdmNode>();
        while (this.source.moreDocuments()) {
            collection.add(this.source.read());
        }
        if (collection.size() == 0) {
            collection = this.runtime.getCollection(href);
        } else {
            this.runtime.setCollection(href, collection);
        }
        if (collection != null) {
            for (XdmNode doc : collection) {
                this.result.write(doc);
            }
        }
    }
}

