/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.S9apiUtils;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@XMLCalabash(name="cx:nvdl", type="{http://xmlcalabash.com/ns/extensions}nvdl {http://exproc.org/proposed/steps}nvdl")
public class NVDL
extends DefaultStep {
    private static final QName _assert_valid = new QName("", "assert-valid");
    private ReadablePipe source = null;
    private ReadablePipe nvdlSource = null;
    private ReadablePipe schemaSource = null;
    private WritablePipe result = null;

    public NVDL(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.source = pipe;
        } else if ("nvdl".equals(port)) {
            this.nvdlSource = pipe;
        } else if ("schemas".equals(port)) {
            this.schemaSource = pipe;
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        boolean assertValid = this.getOption(_assert_valid, false);
        ErrorHandlerImpl eh = new ErrorHandlerImpl((OutputStream)System.out);
        PropertyMapBuilder properties = new PropertyMapBuilder();
        properties.put(ValidateProperty.ERROR_HANDLER, (Object)eh);
        RngProperty.CHECK_ID_IDREF.add(properties);
        properties.put(ValidateProperty.ENTITY_RESOLVER, (Object)this.runtime.getResolver());
        XdmNode srcdoc = this.source.read();
        XdmNode nvdldoc = this.nvdlSource.read();
        while (this.schemaSource.moreDocuments()) {
            XdmNode schema = this.schemaSource.read();
            this.runtime.getResolver().cache(schema, schema.getBaseURI());
        }
        ValidationDriver driver = new ValidationDriver(properties.toPropertyMap());
        InputSource nvdl = S9apiUtils.xdmToInputSource(this.runtime, nvdldoc);
        InputSource doc = S9apiUtils.xdmToInputSource(this.runtime, srcdoc);
        try {
            driver.loadSchema(nvdl);
            if (!driver.validate(doc) && assertValid) {
                throw XProcException.stepError(53, this.step);
            }
        }
        catch (SAXException e) {
            throw new XProcException(new RuntimeException("SAX Exception", e));
        }
        catch (IOException e) {
            throw new XProcException(new RuntimeException("IO Exception", e));
        }
        this.result.write(srcdoc);
    }
}

