/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.AxisNodes;
import com.xmlcalabash.util.TreeWriter;
import java.net.URI;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

@XMLCalabash(name="pxp:set-base-uri", type="{http://exproc.org/proposed/steps}set-base-uri")
public class SetBaseURI
extends DefaultStep {
    private static final QName _uri = new QName("", "uri");
    private XProcRuntime runtime = null;
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private TreeWriter tree = null;
    private URI baseURI = null;

    public SetBaseURI(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
        this.runtime = runtime;
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String uris = this.getOption(_uri, (String)null);
        if (uris == null) {
            throw new XProcException("URI is required");
        }
        this.baseURI = this.getOption(_uri).getBaseURI().resolve(uris);
        XdmNode doc = this.source.read();
        this.tree = new TreeWriter(this.runtime);
        this.tree.startDocument(this.baseURI);
        for (XdmNode node : new AxisNodes(doc, Axis.CHILD)) {
            this.write(node, false);
        }
        this.tree.endDocument();
        this.result.write(this.tree.getResult());
    }

    private void write(XdmNode node, boolean underXmlBase) {
        switch (node.getNodeKind()) {
            case ELEMENT: {
                boolean bl = underXmlBase = underXmlBase || node.getAttributeValue(XProcConstants.xml_base) != null;
                if (underXmlBase) {
                    this.tree.addStartElement(node);
                } else {
                    this.tree.addStartElement(node, this.baseURI);
                }
                for (XdmNode child : new AxisNodes(node, Axis.ATTRIBUTE)) {
                    this.tree.addAttribute(child);
                }
                for (XdmNode child : new AxisNodes(node, Axis.CHILD)) {
                    this.write(child, underXmlBase);
                }
                this.tree.addEndElement();
                break;
            }
            case TEXT: {
                this.tree.addSubtree(node);
                break;
            }
            case COMMENT: {
                this.tree.addSubtree(node);
                break;
            }
            case PROCESSING_INSTRUCTION: {
                this.tree.addSubtree(node);
                break;
            }
            default: {
                throw new XProcException("Unexpected node kind!?");
            }
        }
    }
}

