/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.PipeLogger;
import com.xmlcalabash.io.ReadableDocumentSequence;
import com.xmlcalabash.model.Log;
import com.xmlcalabash.util.S9apiUtils;
import java.util.Vector;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class DocumentSequence
implements ReadableDocumentSequence {
    protected static final String logger = "com.xmlcalabash.io.documentsequence";
    private XProcRuntime runtime = null;
    private Vector<XdmNode> documents = new Vector();
    private boolean closed = false;
    private static int idCounter = 0;
    private int id = 0;
    private PipeLogger outputlog = null;

    public DocumentSequence(XProcRuntime xproc) {
        this.runtime = xproc;
        this.id = idCounter++;
    }

    @Override
    public void setLogger(Log log) {
        if (log != null) {
            this.outputlog = new PipeLogger(this.runtime, log);
        }
    }

    public void add(XdmNode document) {
        if (this.closed) {
            throw new XProcException("You can't add a document to a closed DocumentSequence.");
        }
        S9apiUtils.assertDocument(document);
        this.documents.add(document);
        if (this.outputlog != null) {
            this.outputlog.log(document);
        }
    }

    @Override
    public XdmNode get(int count) throws SaxonApiException {
        this.beforeRead();
        if (count < this.documents.size()) {
            XdmNode doc = this.documents.get(count);
            return doc;
        }
        return null;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.outputlog != null) {
            this.outputlog.stopLogging();
        }
    }

    public boolean closed() {
        return this.closed;
    }

    @Override
    public int size() throws SaxonApiException {
        this.beforeRead();
        return this.documents.size();
    }

    public void reset() {
        this.documents.clear();
        this.closed = false;
        if (this.outputlog != null) {
            this.outputlog.stopLogging();
        }
    }

    public String toString() {
        return "[document-sequence #" + this.id + " (" + this.documents.size() + " docs)]";
    }

    void beforeRead() throws SaxonApiException {
    }
}

